/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import com.jeesite.common.mybatis.mapper.query.QueryWhereEntity;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.ThreadCpu;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.pager.PageFetchException;
import org.hyperic.sigar.pager.StaticPageFetcher;
import org.hyperic.sigar.shell.CollectionCompleter;
import org.hyperic.sigar.shell.ProcessQueryCompleter;
import org.hyperic.sigar.shell.ShellCommandBase;
import org.hyperic.sigar.shell.ShellCommandExecException;
import org.hyperic.sigar.shell.ShellCommandUsageException;
import org.hyperic.sigar.util.GetlineCompleter;
import org.hyperic.sigar.util.PrintfFormat;

public abstract class SigarCommandBase
extends ShellCommandBase
implements GetlineCompleter {
    protected Shell shell;
    protected Sigar sigar;
    private PrintfFormat formatter;
    private CollectionCompleter completer;
    protected PrintStream err;
    private Collection completions;
    protected PrintStream out;
    private ArrayList printfItems;
    private GetlineCompleter ptqlCompleter;
    protected SigarProxy proxy;
    protected List output;

    public boolean isPidCompleter() {
        return false;
    }

    public SigarCommandBase() {
        SigarCommandBase sigarCommandBase = this;
        sigarCommandBase(new Shell());
        sigarCommandBase.shell.setPageSize(-1);
    }

    public void printf(List items) {
        this.printf(items.toArray(new Object[0]));
    }

    public void flush() {
        this.flushPrintfItems();
        try {
            this.shell.performPaging(new StaticPageFetcher(this.output));
            return;
        }
        catch (PageFetchException a) {
            this.err.println(new StringBuilder().insert(0, ThreadCpu.ALLATORIxDEMO("1\u007f\u0006b\u0006-\u0004l\u0013d\u001ajN-")).append(a.getMessage()).toString());
            return;
        }
        finally {
            this.output.clear();
        }
    }

    public String sprintf(String format, Object[] items) {
        return new PrintfFormat(format).sprintf(items);
    }

    @Override
    public void processCommand(String[] args) throws ShellCommandUsageException, ShellCommandExecException {
        if (!this.validateArgs(args)) {
            throw new ShellCommandUsageException(this.getSyntax());
        }
        try {
            this.output(args);
            return;
        }
        catch (SigarException a) {
            throw new ShellCommandExecException(a.getMessage());
        }
    }

    public PrintfFormat getFormatter() {
        return this.formatter;
    }

    private /* synthetic */ void flushPrintfItems() {
        int a;
        if (this.printfItems.size() == 0) {
            return;
        }
        int[] a2 = null;
        for (Object[] a3 : this.printfItems) {
            int a4;
            if (a2 == null) {
                a2 = new int[a3.length];
                Arrays.fill(a2, 0);
            }
            int n = a4 = 0;
            while (n < a3.length) {
                int a5 = a3[a4].toString().length();
                if (a5 > a2[a4]) {
                    a2[a4] = a5;
                }
                n = ++a4;
            }
        }
        StringBuffer a6 = new StringBuffer();
        int n = a = 0;
        while (n < a2.length) {
            a6.append(QueryWhereEntity.ALLATORIxDEMO(".d") + a2[a] + ThreadCpu.ALLATORIxDEMO("~"));
            if (a < a2.length - 1) {
                a6.append(QueryWhereEntity.ALLATORIxDEMO("+i+i"));
            }
            n = ++a;
        }
        Iterator iterator = a = this.printfItems.iterator();
        while (iterator.hasNext()) {
            this.printf(a6.toString(), (Object[])a.next());
            iterator = a;
        }
        this.printfItems.clear();
    }

    public String completePid(String line) {
        if (line.length() >= 1 && Character.isDigit(line.charAt(0))) {
            return line;
        }
        return this.ptqlCompleter.complete(line);
    }

    @Override
    public String complete(String line) {
        if (this.isPidCompleter()) {
            return this.completePid(line);
        }
        GetlineCompleter a = this.getCompleter();
        if (a != null) {
            return a.complete(line);
        }
        SigarCommandBase sigarCommandBase = this;
        sigarCommandBase.completer.setCollection(this.getCompletions());
        return sigarCommandBase.completer.complete(line);
    }

    public abstract void output(String[] var1) throws SigarException;

    protected boolean validateArgs(String[] args) {
        return args.length == 0;
    }

    public void printf(String format, Object[] items) {
        SigarCommandBase sigarCommandBase = this;
        sigarCommandBase.println(sigarCommandBase.sprintf(format, items));
    }

    public GetlineCompleter getCompleter() {
        return null;
    }

    public void println(String line) {
        if (this.shell.isInteractive()) {
            this.output.add(line);
            return;
        }
        this.out.println(line);
    }

    public void printf(Object[] items) {
        PrintfFormat a = this.getFormatter();
        if (a == null) {
            this.printfItems.add(items);
            return;
        }
        this.println(a.sprintf(items));
    }

    public SigarCommandBase(Shell shell) {
        SigarCommandBase sigarCommandBase = this;
        Shell shell2 = shell;
        SigarCommandBase sigarCommandBase2 = this;
        this.out = System.out;
        this.err = System.err;
        SigarCommandBase sigarCommandBase3 = this;
        this.output = new ArrayList();
        this.completions = new ArrayList();
        this.printfItems = new ArrayList();
        sigarCommandBase2.shell = shell;
        sigarCommandBase2.out = shell.getOutStream();
        this.err = shell2.getErrStream();
        sigarCommandBase.sigar = shell2.getSigar();
        this.proxy = shell.getSigarProxy();
        sigarCommandBase.completer = new CollectionCompleter(shell);
        if (this.isPidCompleter()) {
            this.ptqlCompleter = new ProcessQueryCompleter(shell);
        }
    }

    public Collection getCompletions() {
        return this.completions;
    }

    /*
     * WARNING - void declaration
     */
    public void setOutputFormat(String string) {
        void format;
        SigarCommandBase sigarCommandBase = this;
        sigarCommandBase.formatter = new PrintfFormat((String)format);
    }
}

