/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.vmware;

import com.jeesite.autoconfigure.core.TransactionAutoConfiguration;
import com.jeesite.common.cache.JedisUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.hyperic.jni.ArchName;
import org.hyperic.sigar.SigarLoader;
import org.hyperic.sigar.vmware.VMwareObject;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Win32Exception;

public class VMControlLibrary {
    private static final String VMCONTROL;
    private static final String TAR;
    private static final String VMCONTROL_OBJ;
    private static final String LIBSSL;
    private static final String VMCONTROL_TAR;
    private static final String LIBCRYPTO;
    private static final boolean IS64;
    private static final String VMWARE_LIB;
    public static final String PROP_VMCONTROL_SHLIB = "vmcontrol.shlib";
    private static boolean isDebug;
    public static final String REGISTRY_ROOT = "SOFTWARE\\VMware, Inc.";
    private static final String GCC;
    private static final String VMCONTROL_SO;
    private static final String VMCONTROL_DLL;

    static {
        IS64 = ArchName.is64();
        VMWARE_LIB = VMControlLibrary.getProperty(TransactionAutoConfiguration.ALLATORIxDEMO("M\u0004CCW\u0000V\fS\b"), VMControlLibrary.getVMwareLib().getPath());
        VMCONTROL_TAR = VMControlLibrary.getProperty(JedisUtils.ALLATORIxDEMO("W:Z!F:X{@4F"), new StringBuilder().insert(0, VMWARE_LIB).append(TransactionAutoConfiguration.ALLATORIxDEMO("BQ\bS\u0001\u000e\u000eN\u0003U\u001fN\u0001\u000f\u0019@\u001f")).toString());
        VMCONTROL = new StringBuilder().insert(0, JedisUtils.ALLATORIxDEMO("B8W:Z!F:X")).append(IS64 ? TransactionAutoConfiguration.ALLATORIxDEMO("\u0017Y") : "").toString();
        VMCONTROL_DLL = new StringBuilder().insert(0, VMCONTROL).append(JedisUtils.ALLATORIxDEMO("X<V{P9X")).toString();
        VMCONTROL_SO = new StringBuilder().insert(0, VMCONTROL).append(TransactionAutoConfiguration.ALLATORIxDEMO("CR\u0002")).toString();
        VMCONTROL_OBJ = VMControlLibrary.getProperty(JedisUtils.ALLATORIxDEMO("B8W:Z!F:X{["), new StringBuilder().insert(0, TransactionAutoConfiguration.ALLATORIxDEMO("\u000eN\u0003U\u001fN\u0001\f\u0002O\u0001XB")).append(VMCONTROL).append(JedisUtils.ALLATORIxDEMO("{[")).toString());
        GCC = VMControlLibrary.getProperty(TransactionAutoConfiguration.ALLATORIxDEMO("\u000fH\u0003\u000f\nB\u000e"), JedisUtils.ALLATORIxDEMO("zA&FzV<ZzS6W"));
        TAR = VMControlLibrary.getProperty(TransactionAutoConfiguration.ALLATORIxDEMO("\u000fH\u0003\u000f\u0019@\u001f"), JedisUtils.ALLATORIxDEMO("zV<Zz@4F"));
        LIBSSL = VMControlLibrary.getProperty(TransactionAutoConfiguration.ALLATORIxDEMO("M\u0004C\u001eR\u0001"), JedisUtils.ALLATORIxDEMO("X<V&G9\u001a&[{\u0004{\r{\u0003"));
        LIBCRYPTO = VMControlLibrary.getProperty(TransactionAutoConfiguration.ALLATORIxDEMO("\u0001H\u000fB\u001fX\u001dU\u0002"), JedisUtils.ALLATORIxDEMO("9]7W'M%@:\u001a&[{\u0004{\r{\u0003"));
        isDebug = false;
    }

    public static boolean isLoaded() {
        return VMwareObject.LOADED;
    }

    private static /* synthetic */ File getLib(String name) {
        File a = new File(VMWARE_LIB, new StringBuilder().insert(0, TransactionAutoConfiguration.ALLATORIxDEMO("M\u0004CB")).append(name).toString());
        if (a.isDirectory()) {
            a = new File(a, name);
        }
        return a;
    }

    public static void link() throws IOException {
        VMControlLibrary.link(VMCONTROL_SO);
    }

    private static /* synthetic */ void exec(String[] args) throws IOException {
        Process a = Runtime.getRuntime().exec(args);
        try {
            int a2 = a.waitFor();
            if (a2 != 0) {
                String a3 = new StringBuilder().insert(0, JedisUtils.ALLATORIxDEMO("Q-Q6\u001c")).append(VMControlLibrary.toString(args)).append(TransactionAutoConfiguration.ALLATORIxDEMO("\bMG\fH\u0001D\t\u001bM")).append(a2).toString();
                throw new IOException(a3);
            }
        }
        catch (InterruptedException a2) {
            // empty catch block
        }
        if (isDebug) {
            System.out.println(new StringBuilder().insert(0, JedisUtils.ALLATORIxDEMO("Q-Q6\u001c")).append(VMControlLibrary.toString(args)).append(TransactionAutoConfiguration.ALLATORIxDEMO("\bMn&")).toString());
        }
    }

    private static /* synthetic */ File getVMwareLib() {
        File a;
        int a2;
        String[] stringArray = new String[2];
        stringArray[0] = JedisUtils.ALLATORIxDEMO("\u001b G'\u001b9]7\u001b#Y\"U'Q");
        stringArray[1] = TransactionAutoConfiguration.ALLATORIxDEMO("BT\u001eSBM\u0002B\fMBM\u0004CBW\u0000V\fS\b");
        String[] a3 = stringArray;
        int n = a2 = 0;
        while (n < a3.length) {
            a = new File(a3[a2]);
            if (a.exists()) {
                return a;
            }
            n = ++a2;
        }
        int n2 = a2 = 0;
        while (n2 < a3.length) {
            a = new File(new StringBuilder().insert(0, a3[a2]).append(JedisUtils.ALLATORIxDEMO("xU%]")).toString());
            if (a.exists()) {
                return a;
            }
            n2 = ++a2;
        }
        return new File(a3[0]);
    }

    public static void link(String name) throws IOException {
        String[] stringArray;
        String[] a;
        if (SigarLoader.IS_WIN32) {
            VMControlLibrary.linkWin32();
            return;
        }
        File a2 = new File(name).getAbsoluteFile();
        if (a2.isDirectory()) {
            a2 = new File(a2, VMCONTROL_SO);
        }
        if (a2.exists()) {
            VMControlLibrary.setSharedLibrary(a2.getPath());
            return;
        }
        if (!new File(VMCONTROL_TAR).exists()) {
            return;
        }
        File a3 = a2.getParentFile();
        if (!a3.isDirectory() || !a3.canWrite()) {
            throw new IOException(new StringBuilder().insert(0, TransactionAutoConfiguration.ALLATORIxDEMO(".@\u0003O\u0002UMV\u001fH\u0019DMU\u0002\u001bM")).append(a3).toString());
        }
        File a4 = new File(a3, VMCONTROL_OBJ);
        if (!a4.exists()) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = TAR;
            stringArray2[1] = JedisUtils.ALLATORIxDEMO("\u0019-R");
            stringArray2[2] = VMCONTROL_TAR;
            stringArray2[3] = TransactionAutoConfiguration.ALLATORIxDEMO("\f.");
            stringArray2[4] = a3.toString();
            stringArray2[5] = VMCONTROL_OBJ;
            a = stringArray2;
            VMControlLibrary.exec(stringArray2);
        }
        a = new ArrayList();
        a.add(GCC);
        a.add(JedisUtils.ALLATORIxDEMO("\u0019&\\4F0P"));
        a.add(TransactionAutoConfiguration.ALLATORIxDEMO("\f\u0002"));
        a.add(a2.getPath());
        a.add(a4.getPath());
        if (IS64) {
            a.add(JedisUtils.ALLATORIxDEMO("xX6F,D!["));
            stringArray = a;
            a.add(TransactionAutoConfiguration.ALLATORIxDEMO("@M\u001eR\u0001"));
        } else {
            File a5 = VMControlLibrary.getLib(VMControlLibrary.LIBSSL);
            File a6 = VMControlLibrary.getLib(VMControlLibrary.LIBCRYPTO);
            if (!a5.exists()) {
                throw new FileNotFoundException(a5.toString());
            }
            if (!new File(a5.getParent(), JedisUtils.ALLATORIxDEMO("X<V6\u001a&[{\u0002")).exists()) {
                String a7 = TransactionAutoConfiguration.ALLATORIxDEMO("\f:MA\f\u001fQ\fU\u0005");
                File file = a5;
                a.add(JedisUtils.ALLATORIxDEMO("xc9\u0018xF%U!\\"));
                a.add(file.getParent());
                if (!file.getParent().equals(a6.getParent())) {
                    a.add(TransactionAutoConfiguration.ALLATORIxDEMO("\f:MA\f\u001fQ\fU\u0005"));
                    a.add(a6.getParent());
                }
            }
            stringArray = a;
            a.add(a5.getPath());
            a.add(a6.getPath());
        }
        VMControlLibrary.exec(stringArray.toArray(new String[0]));
        VMControlLibrary.setSharedLibrary(a2.getPath());
    }

    private static /* synthetic */ String getProperty(String key, String defval) {
        return System.getProperty(new StringBuilder().insert(0, JedisUtils.ALLATORIxDEMO("#Y6[;@'[9\u001a")).append(key).toString(), defval);
    }

    public static void main(String[] stringArray) throws Exception {
        String[] args;
        System.out.println(TransactionAutoConfiguration.ALLATORIxDEMO("g\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N+N\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0002g\u0002M\u0001M\u0001M\u0001M\u0001N\u0002M\u0002M\u0001M\u0002M\u0001M\u0001N\u0002M\u0002N\u0002M\u0002N\u0002M\u0002N\u0001M\u0002N\u0002M\u0001M\u0001M\u0001M\u0001N+N\u0001M\u0001M\u0001M\u0001N\u0001N\u0001N\u0001M\u0001N\u0001M\u0001N\u0001N\u0001M\u0002M\u0001N\u0001N\u0001N\u0001N\u0001M\u0002M\u0001M\u0001M\u0001M\u0001M\u0002g\u0002M\u0001M\u0001M\u0001M\u0002N\u0002M\u0002M\u0001M\u0002M\u0001M\u0002N\u0002M\u0001N\u0001M\u0002M\u0002M\u0002N\u0001M\u0001N\u0001M\u0001M\u0001M\u0001M\u0001N+N\u0001M\u0001M\u0001M\u0001N\u0001N\u0001N\u0002N\u0001N\u0002N\u0001N\u0001N\u0001M\u0002M\u0001N\u0002N\u0001N\u0001N\u0001N\u0002N\u0001M\u0001M\u0001M\u0001M\u0002g\u0002M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001N+N\u0001\"C\u000bT\u001eB\fU\u0004N\u0003\u0001\u000fXM`\u0001M\fU\u0002S\u0004\u0001\"C\u000bT\u001eB\fU\u0002SMW[\u000fZ\u0001)d nM\u0002g\u0002M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001N+N\u0001M\u0001M\u0001M\u0001M\u0001M\u0001\u0005U\u0019QW\u000eBV\u001aVC@\u0001M\fU\u0002S\u0004\u000f\u000eN\u0000\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0002g\u0002M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001N+N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002N\u0002g"));
        isDebug = true;
        if (args.length == 0) {
            VMControlLibrary.link();
        } else {
            VMControlLibrary.link(args[0]);
        }
        String a = VMControlLibrary.getSharedLibrary();
        if (a == null) {
            System.out.println(JedisUtils.ALLATORIxDEMO("\u001b[uX<V'U'MuR:A;P"));
            return;
        }
        System.out.println(new StringBuilder().insert(0, TransactionAutoConfiguration.ALLATORIxDEMO("W\u0000B\u0002O\u0019S\u0002MCR\u0005M\u0004CP")).append(a).append(JedisUtils.ALLATORIxDEMO("\u0014}X:U1Q1\t")).append(VMControlLibrary.isLoaded()).append(TransactionAutoConfiguration.ALLATORIxDEMO("D")).toString());
    }

    public static void setSharedLibrary(String lib) {
        System.setProperty(PROP_VMCONTROL_SHLIB, lib);
    }

    public static String getSharedLibrary() {
        return System.getProperty(PROP_VMCONTROL_SHLIB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ void linkWin32() {
        ArrayList<String> arrayList;
        ArrayList<String> a;
        block22: {
            block21: {
                a = new ArrayList<String>();
                RegistryKey a2 = null;
                try {
                    a2 = RegistryKey.LocalMachine.openSubKey(REGISTRY_ROOT);
                    String[] a3 = a2.getSubKeyNames();
                    for (int a4 = 0; a4 < a3.length; ++a4) {
                        RegistryKey registryKey;
                        String a5;
                        RegistryKey a6;
                        String a7;
                        block20: {
                            block19: {
                                a7 = a3[a4];
                                if (!a7.startsWith(JedisUtils.ALLATORIxDEMO("b\u0018C4F0\u0014"))) continue;
                                a6 = null;
                                a6 = a2.openSubKey(a7);
                                a5 = a6.getStringValue(TransactionAutoConfiguration.ALLATORIxDEMO("$O\u001eU\fM\u0001q\fU\u0005"));
                                if (a5 != null) break block19;
                                if (a6 == null) continue;
                                a6.close();
                                continue;
                            }
                            a5 = a5.trim();
                            if (a5.length() != 0) break block20;
                            if (a6 == null) continue;
                            a6.close();
                            continue;
                        }
                        try {
                            File a8 = new File(new StringBuilder().insert(0, a5).append(VMCONTROL_DLL).toString());
                            if (a8.exists()) {
                                if (a7.endsWith(JedisUtils.ALLATORIxDEMO("\u0014\u0006Q'B0F"))) {
                                    registryKey = a6;
                                    a.add(0, a8.getPath());
                                    continue;
                                }
                                if (a7.endsWith(TransactionAutoConfiguration.ALLATORIxDEMO("\u0001,q$"))) {
                                    a.add(a8.getPath());
                                }
                            }
                            registryKey = a6;
                            continue;
                        }
                        catch (Win32Exception win32Exception) {
                            continue;
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        finally {
                            if (registryKey != null) {
                                a6.close();
                            }
                        }
                    }
                    if (a2 == null) break block21;
                    arrayList = a;
                    a2.close();
                    break block22;
                }
                catch (Win32Exception win32Exception) {
                    if (a2 == null) break block21;
                    arrayList = a;
                    a2.close();
                    break block22;
                }
                catch (Throwable throwable) {
                    if (a2 != null) {
                        a2.close();
                    }
                    throw throwable;
                }
            }
            arrayList = a;
        }
        if (arrayList.size() != 0) {
            VMControlLibrary.setSharedLibrary((String)a.get(0));
        }
    }

    private static /* synthetic */ String toString(String[] args) {
        int a;
        StringBuffer a2 = new StringBuffer();
        int n = a = 0;
        while (n < args.length) {
            if (a2.length() != 0) {
                a2.append(' ');
            }
            StringBuffer stringBuffer = a2.append(JedisUtils.ALLATORIxDEMO("\u0013")).append(args[a]);
            stringBuffer.append(TransactionAutoConfiguration.ALLATORIxDEMO("J"));
            n = ++a;
        }
        return a2.toString();
    }
}

