/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.Who;
import org.hyperic.sigar.win32.ServiceConfig;
import org.hyperic.sigar.win32.Win32;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.sigar.win32.d;

public class Service
extends Win32 {
    private static final int SC_MANAGER_CONNECT = 1;
    private static final int SC_MANAGER_QUERY_LOCK_STATUS = 16;
    public static final int SERVICE_PAUSE_PENDING = 6;
    private static final int SERVICE_ALL_ACCESS = 983551;
    private long service;
    private static final int SC_MANAGER_CREATE_SERVICE = 2;
    public static final int SERVICE_PAUSED = 7;
    private static final int SERVICE_ENUMERATE_DEPENDENTS = 8;
    public static final int SERVICE_STOPPED = 1;
    private static final int SERVICE_INTERROGATE = 128;
    private static final int SERVICE_USER_DEFINED_CONTROL = 256;
    private static final int CONTROL_RESUME = 3;
    private static final int SC_MANAGER_ALL_ACCESS = 983103;
    private static final int SC_MANAGER_LOCK = 8;
    private static final String[] STATUS;
    private static final int SERVICE_QUERY_CONFIG = 1;
    public static final int SERVICE_CONTINUE_PENDING = 5;
    public static final int SERVICE_RUNNING = 4;
    private static final int SERVICE_CHANGE_CONFIG = 2;
    private static final int SERVICE_PAUSE_CONTINUE = 64;
    private static final int CONTROL_STOP = 1;
    private static final int SERVICE_QUERY_STATUS = 4;
    private static final int STANDARD_RIGHTS_REQUIRED = 983040;
    private long manager = Service.OpenSCManager("", 983103);
    public static final int SERVICE_START_PENDING = 2;
    private static final int CONTROL_PAUSE = 2;
    private String name;
    private static final int SERVICE_STOP = 32;
    private static final int CONTROL_START = 0;
    private static final int SC_MANAGER_MODIFY_BOOT_CONFIG = 32;
    public static final int SERVICE_STOP_PENDING = 3;
    private static final int SERVICE_START = 16;
    private static final int SC_MANAGER_ENUMERATE_SERVICE = 4;

    public void resume() throws Win32Exception {
        this.control(3);
    }

    static {
        String[] stringArray = new String[8];
        stringArray[0] = Who.ALLATORIxDEMO("M's'w>v");
        stringArray[1] = ProcMem.ALLATORIxDEMO("\u0004V8R'G3");
        stringArray[2] = Who.ALLATORIxDEMO("K=y;liH,v-q'\u007f");
        stringArray[3] = ProcMem.ALLATORIxDEMO("q#M'\u0002\u0007G9F>L0");
        stringArray[4] = Who.ALLATORIxDEMO("J<v'q'\u007f");
        stringArray[5] = ProcMem.ALLATORIxDEMO("a8L#K9W2\u0002\u0007G9F>L0");
        stringArray[6] = Who.ALLATORIxDEMO("H(m:}iH,v-q'\u007f");
        stringArray[7] = ProcMem.ALLATORIxDEMO("r6W$G3");
        STATUS = stringArray;
    }

    private static native /* synthetic */ long OpenSCManager(String var0, int var1) throws Win32Exception;

    public int getStatus() {
        return Service.QueryServiceStatus(this.service);
    }

    public static List getServiceNames() throws Win32Exception {
        return Service.getServiceNames(null, null);
    }

    private static native /* synthetic */ boolean QueryServiceConfig(long var0, ServiceConfig var2) throws Win32Exception;

    public void stopAndWait(long timeout) throws Win32Exception {
        this.stop(timeout);
    }

    private static native /* synthetic */ void ControlService(long var0, int var2) throws Win32Exception;

    private static native /* synthetic */ long CreateService(long var0, String var2, String var3, int var4, int var5, int var6, String var7, String[] var8, String var9, String var10) throws Win32Exception;

    public static List getServiceConfigs(String exe) throws Win32Exception {
        try (Sigar a = new Sigar();){
            List list = Service.getServiceConfigs(a, exe);
            return list;
        }
    }

    public void list(PrintStream out) throws Win32Exception {
        this.getConfig().list(out);
        out.println(Who.ALLATORIxDEMO("k=y=m:6g6g6g6gC") + this.getStatusString() + ProcMem.ALLATORIxDEMO("\n"));
    }

    public String getStatusString() {
        return STATUS[this.getStatus()];
    }

    public void start(long timeout) throws Win32Exception {
        this.start();
        if (!new d(this, timeout, 4, 2).ALLATORIxDEMO()) {
            throw new Win32Exception(Who.ALLATORIxDEMO("^(q%}-8=wik=y;lik,j?q*}"));
        }
    }

    public synchronized void close() {
        if (this.service != 0L) {
            Service.CloseServiceHandle(this.service);
            this.service = 0L;
        }
        if (this.manager != 0L) {
            Service.CloseServiceHandle(this.manager);
            this.manager = 0L;
        }
    }

    private static native /* synthetic */ boolean ChangeServiceDescription(long var0, String var2);

    private static native /* synthetic */ void DeleteService(long var0) throws Win32Exception;

    public void pause() throws Win32Exception {
        this.control(2);
    }

    private static native /* synthetic */ long OpenService(long var0, String var2, int var3) throws Win32Exception;

    public void stop() throws Win32Exception {
        this.control(1);
    }

    public static Service create(ServiceConfig config) throws Win32Exception {
        if (config.getName() == null) {
            throw new IllegalArgumentException(ProcMem.ALLATORIxDEMO("9C:GjL\"N;"));
        }
        if (config.getPath() == null) {
            throw new IllegalArgumentException(Who.ALLATORIxDEMO("h(l!%'m%t"));
        }
        Service a = new Service();
        a.service = Service.CreateService(a.manager, config.getName(), config.getDisplayName(), config.getType(), config.getStartType(), config.getErrorControl(), config.getPath(), config.getDependencies(), config.getStartName(), config.getPassword());
        if (config.getDescription() != null) {
            a.setDescription(config.getDescription());
        }
        return a;
    }

    public void pause(long timeout) throws Win32Exception {
        this.pause();
        if (!new d(this, timeout, 7, 6).ALLATORIxDEMO()) {
            throw new Win32Exception(ProcMem.ALLATORIxDEMO("\u0011C>N2FwV8\u0002'C\"Q2\u0002$G%T>A2"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static List getServiceConfigs(Sigar sigar, String exe) throws Win32Exception {
        void a;
        int a2;
        ArrayList arrayList = new ArrayList();
        List a3 = Service.getServiceNames(sigar, Who.ALLATORIxDEMO("\u001a};n {,6\f`,6\u0000}8%") + exe);
        int n = a2 = 0;
        while (n < a3.size()) {
            try (Service a4 = null;){
                a4 = new Service((String)a3.get(a2));
                ServiceConfig a5 = a4.getConfig();
                a.add(a5);
            }
            n = ++a2;
        }
        return a;
    }

    private /* synthetic */ Service() throws Win32Exception {
    }

    private static native /* synthetic */ int QueryServiceStatus(long var0);

    public static native List getServiceNames(Sigar var0, String var1) throws Win32Exception;

    private /* synthetic */ void control(int ctl) throws Win32Exception {
        Service.ControlService(this.service, ctl);
    }

    public void stop(long timeout) throws Win32Exception {
        this.stop();
        if (!new d(this, timeout, 1, 3).ALLATORIxDEMO()) {
            throw new Win32Exception(ProcMem.ALLATORIxDEMO("d6K;G3\u0002#MwQ#M'\u0002$G%T>A2"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        int a;
        List a2;
        String[] args;
        System.out.println(Who.ALLATORIxDEMO("\u0012j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;C;i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8j\u0012j8i8i8i8i;j8j8i8j8i8i;j8j;j8j;j8j;i8j;j8i8i8i8i;C;i8i8i8i;i;i;i8i;i8i;i;i8j8i;i;i;i;i8j8i8i8i8i8j\u0012j8i8i8i8j;j8j8i8j8i8j;j8i;i8j8j8j;i8i;i8i8i8i8i;C;i8i8i8i;i;i;j;i;j;i;i;i8j8i;j;i;i;i;j;i8i8i8i8j\u0012j8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i;C;iW+~<k*y=q&viz08\bt%y=w;qiW+~<k*y=w;8?.g/i\\\fU\u00068j\u0012j8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i;C;i8i8i8i8i8ip=l9\"f7>o>6(t%y=w;qg{&ui8i8i8i8i8i8j\u0012j8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i8i;C;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j;j\u0012"));
        if (args.length == 0) {
            a2 = Service.getServiceNames();
        } else {
            if (args.length == 2 && args[0].equals(ProcMem.ALLATORIxDEMO("zV8E0N2"))) {
                long a3 = 5000L;
                Service a4 = new Service(args[1]);
                if (a4.getStatus() == 4) {
                    System.out.println(Who.ALLATORIxDEMO("K=w9h v.8:};n {,6g6"));
                    a4.stop(a3);
                } else {
                    System.out.println(ProcMem.ALLATORIxDEMO("\u0004V6P#K9EwQ2P!K4Gy\fy"));
                    a4.start(a3);
                }
                System.out.println(a4.getStatusString());
                return;
            }
            if (args.length == 1 && args[0].startsWith(Who.ALLATORIxDEMO("\u001a};n {,6"))) {
                try (Sigar a5 = new Sigar();){
                    a2 = Service.getServiceNames(a5, args[0]);
                }
            }
            if (args.length == 1 && args[0].endsWith(".exe")) {
                int a6;
                List a7;
                try (Sigar a8 = new Sigar();){
                    a7 = Service.getServiceConfigs(args[0]);
                }
                int n = a6 = 0;
                while (n < a7.size()) {
                    ServiceConfig a9 = (ServiceConfig)a7.get(a6);
                    a9.list(System.out);
                    System.out.println("");
                    n = ++a6;
                }
                return;
            }
            a2 = Arrays.asList(args);
        }
        int n = a = 0;
        while (n < a2.size()) {
            String a10 = (String)a2.get(a);
            Service a11 = new Service(a10);
            a11.list(System.out);
            System.out.println("");
            n = ++a;
        }
    }

    public ServiceConfig getConfig() throws Win32Exception {
        ServiceConfig a;
        ServiceConfig serviceConfig = a = new ServiceConfig();
        Service.QueryServiceConfig(this.service, serviceConfig);
        a.setName(this.name);
        return serviceConfig;
    }

    private static native /* synthetic */ boolean CloseServiceHandle(long var0);

    public int status() {
        return this.getStatus();
    }

    protected void finalize() {
        this.close();
    }

    public void setDescription(String description) {
        Service.ChangeServiceDescription(this.service, description);
    }

    public void delete() throws Win32Exception {
        Service.DeleteService(this.service);
    }

    /*
     * WARNING - void declaration
     */
    public Service(String string) throws Win32Exception {
        this();
        void serviceName;
        this.service = Service.OpenService(this.manager, (String)serviceName, 983551);
        this.name = string;
    }

    public void start() throws Win32Exception {
        this.control(0);
    }
}

