/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.xa.DruidXADataSource;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.datasource.DataSourceHolder;
import com.jeesite.common.datasource.a.h;
import com.jeesite.common.lang.StringUtils;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.hyperic.sigar.cmd.EventLogTail;
import org.hyperic.sigar.pager.PageList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.jta.atomikos.AtomikosDataSourceBean;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class RoutingDataSource
extends AbstractRoutingDataSource {
    private static final Logger logger = LoggerFactory.getLogger(RoutingDataSource.class);
    private Object defaultTargetDataSource;
    private Map<Object, Object> targetDataSources;

    public void addTargetDataSource(String dataSourceName, DataSource dataSource) {
        if (dataSource == null) {
            logger.warn(new StringBuilder().insert(0, EventLogTail.float("u\fPH@\tF\u000fQ\u001c\u0014\fU\u001cUHG\u0007A\u001aW\r\u0014\u0001GHZ\u001dX\u0004\u000eH")).append(dataSourceName).toString());
            return;
        }
        this.targetDataSources.put(dataSourceName, dataSource);
        logger.debug(new StringBuilder().insert(0, PageList.float("M\u0000hDx\u0005~\u0003i\u0010,\u0000m\u0010mD\u007f\u000by\u0016o\u0001,\u0017y\u0007o\u0001\u007f\u00176D")).append(dataSourceName).toString());
    }

    public void removeTargetDataSource(String dataSourceName) {
        this.targetDataSources.remove(dataSourceName);
        logger.debug(new StringBuilder().insert(0, EventLogTail.float(":Q\u0005[\u001eQH@\tF\u000fQ\u001c\u0014\fU\u001cUHG\u0007A\u001aW\r\u000eH")).append(dataSourceName).toString());
    }

    protected Object determineCurrentLookupKey() {
        return DataSourceHolder.getDataSourceName();
    }

    public RoutingDataSource() throws SQLException {
        RoutingDataSource routingDataSource = this;
        routingDataSource.setTargetDataSources(MapUtils.newConcurrentMap());
    }

    public DataSource getTargetDataSource(String dataSourceName) {
        if (StringUtils.isBlank((CharSequence)dataSourceName) || "default".equals(dataSourceName)) {
            return (DataSource)this.defaultTargetDataSource;
        }
        Object a = this.targetDataSources.get(dataSourceName);
        if (a == null) {
            return (DataSource)this.defaultTargetDataSource;
        }
        return (DataSource)a;
    }

    public static DataSource createDataSource(String dataSourceName, boolean isJta) throws SQLException {
        DruidXADataSource druidXADataSource;
        String a;
        if (StringUtils.isBlank((CharSequence)dataSourceName)) {
            dataSourceName = "default";
        }
        String a2 = PageList.float("f\u0000n\u0007");
        if (!"default".equals(dataSourceName)) {
            a2 = new StringBuilder().insert(0, a2).append(".").append(dataSourceName).toString();
        }
        if (StringUtils.isBlank((CharSequence)(a = Global.getProperty(new StringBuilder().insert(0, a2).append(EventLogTail.float("F@\u0011D\r")).toString()))) && !PageList.float("f\u0000n\u0007").equals(a2)) {
            a2 = EventLogTail.float("^\fV\u000b");
            a = Global.getProperty(new StringBuilder().insert(0, a2).append(PageList.float("Jx\u001d|\u0001")).toString());
        }
        if (StringUtils.isBlank((CharSequence)a)) {
            return null;
        }
        DruidXADataSource a3 = null;
        (isJta ? (a3 = new DruidXADataSource()) : (a3 = new DruidDataSource())).setName(dataSourceName);
        DruidXADataSource druidXADataSource2 = a3;
        druidXADataSource2.setDriverClassName(Global.getProperty(a2 + EventLogTail.float("FP\u001a]\u001eQ\u001a")));
        a3.setUrl(Global.getProperty(new StringBuilder().insert(0, a2).append(PageList.float("\"\u0011~\b")).toString()));
        druidXADataSource2.setUsername(Global.getProperty(new StringBuilder().insert(0, a2).append(EventLogTail.float("FA\u001bQ\u001aZ\tY\r")).toString()));
        druidXADataSource2.setPassword(Global.getProperty(new StringBuilder().insert(0, a2).append(PageList.float("J|\u0005\u007f\u0017{\u000b~\u0000")).toString()));
        CharSequence[] charSequenceArray = new CharSequence[3];
        charSequenceArray[0] = a3.getDriverClassName();
        charSequenceArray[1] = a3.getUrl();
        charSequenceArray[2] = a3.getUsername();
        if (StringUtils.isAnyBlank((CharSequence[])charSequenceArray)) {
            a3.close();
            return null;
        }
        String a4 = Global.getProperty(new StringBuilder().insert(0, a2).append(EventLogTail.float("\u001a\u001cQ\u001b@;E\u0004")).toString());
        DruidXADataSource druidXADataSource3 = a3;
        if (StringUtils.isNotBlank((CharSequence)a4)) {
            druidXADataSource3.setTestWhileIdle(true);
            DruidXADataSource druidXADataSource4 = a3;
            druidXADataSource = druidXADataSource4;
            druidXADataSource4.setValidationQuery(a4);
        } else {
            druidXADataSource3.setTestWhileIdle(false);
            logger.warn(new StringBuilder().insert(0, PageList.float("\u5f37\u5241D")).append(a2).append(EventLogTail.float("F@\rG\u001cg\u0019XH\u671e\u8bd6\u7f5a\uff64\u7ccf\u7eb7\u5c32\u4e65\u4f2e\u8fb3\u8878\u7a12\u95c6\u8fb6\u6391\u68a8\u67d1\u306a")).toString());
            druidXADataSource = a3;
        }
        druidXADataSource.setInitialSize(Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(PageList.float("\"\u0014c\u000b`Je\ne\u0010")).toString(), "1").intValue());
        DruidXADataSource druidXADataSource5 = a3;
        druidXADataSource5.setMinIdle(Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(EventLogTail.float("FD\u0007[\u0004\u001a\u0005]\u0006}\fX\r")).toString(), "3").intValue());
        druidXADataSource5.setMaxActive(Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(PageList.float("J|\u000bc\b\"\tm\u001cM\u0007x\rz\u0001")).toString(), EventLogTail.float("\u0006X")).intValue());
        druidXADataSource5.setMaxWait((long)Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(PageList.float("J|\u000bc\b\"\tm\u001c[\u0005e\u0010")).toString(), EventLogTail.float("^\u0004X\u0004X")).intValue());
        druidXADataSource5.setTestOnBorrow(Global.getPropertyToBoolean(new StringBuilder().insert(0, a2).append(PageList.float("\"\u0014c\u000b`Jx\u0001\u007f\u0010C\nN\u000b~\u0016c\u0013")).toString(), "false").booleanValue());
        druidXADataSource5.setTestOnReturn(Global.getPropertyToBoolean(new StringBuilder().insert(0, a2).append(EventLogTail.float("\u001a\u0018[\u0007XF@\rG\u001c{\u0006f\r@\u001dF\u0006")).toString(), "false").booleanValue());
        druidXADataSource5.setTimeBetweenEvictionRunsMillis((long)Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(PageList.float("J|\u000bc\b\"\u0010e\ti&i\u0010{\u0001i\nI\u0012e\u0007x\rc\n^\u0011b\u0017A\r`\be\u0017")).toString(), EventLogTail.float("^\u0004X\u0004X")).intValue());
        druidXADataSource5.setMinEvictableIdleTimeMillis((long)Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(PageList.float("\"\u0014c\u000b`Ja\rb!z\ro\u0010m\u0006`\u0001E\u0000`\u0001X\ra\u0001A\r`\be\u0017")).toString(), EventLogTail.float("Y\u0006X\u0004X\u0004X")).intValue());
        druidXADataSource5.setMaxEvictableIdleTimeMillis((long)Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(PageList.float("\"\u0014c\u000b`Ja\u0005t!z\ro\u0010m\u0006`\u0001E\u0000`\u0001X\ra\u0001A\r`\be\u0017")).toString(), EventLogTail.float("Y\fX\u0004X\u0004X")).intValue());
        druidXADataSource5.setRemoveAbandoned(Global.getPropertyToBoolean(new StringBuilder().insert(0, a2).append(PageList.float("J|\u000bc\b\"\u0016i\tc\u0012i%n\u0005b\u0000c\ni\u0000")).toString(), "true").booleanValue());
        druidXADataSource5.setRemoveAbandonedTimeout(Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(EventLogTail.float("\u001a\u0018[\u0007XFF\rY\u0007B\ru\nU\u0006P\u0007Z\rP<]\u0005Q\u0007A\u001c")).toString(), PageList.float(">U<T")).intValue());
        if (EventLogTail.float("[\u001aU\u000bX\r").equals(a)) {
            DruidXADataSource druidXADataSource6 = a3;
            druidXADataSource6.setPoolPreparedStatements(true);
            druidXADataSource6.setMaxPoolPreparedStatementPerConnectionSize(druidXADataSource6.getMaxActive());
        }
        DruidXADataSource druidXADataSource7 = a3;
        druidXADataSource7.setFilters(PageList.float("\u007f\u0010m\u0010"));
        druidXADataSource7.getProxyFilters().add(new h(a2));
        a3.init();
        if (druidXADataSource7 instanceof XADataSource) {
            AtomikosDataSourceBean a5 = new AtomikosDataSourceBean();
            a5.setXaDataSource((XADataSource)a3);
            AtomikosDataSourceBean atomikosDataSourceBean = a5;
            a5.setUniqueResourceName(a3.getName());
            atomikosDataSourceBean.setMinPoolSize(0);
            atomikosDataSourceBean.setMaxPoolSize(a3.getMaxActive());
            return atomikosDataSourceBean;
        }
        return a3;
    }

    public void setDefaultTargetDataSource(Object defaultTargetDataSource) {
        if (defaultTargetDataSource == null) {
            logger.warn(EventLogTail.float(";Q\u001c\u0014\fQ\u000eU\u001dX\u001c\u0014\u001cU\u001aS\r@HP\t@\t\u0014\u001b[\u001dF\u000bQH]\u001b\u0014\u0006A\u0004XF"));
            return;
        }
        this.defaultTargetDataSource = defaultTargetDataSource;
        super.setDefaultTargetDataSource(this.defaultTargetDataSource);
        logger.debug(PageList.float("7i\u0010,\u0000i\u0002m\u0011`\u0010,\u0010m\u0016k\u0001xDh\u0005x\u0005,\u0017c\u0011~\u0007iD\u007f\u0011o\u0007i\u0017\u007fJ"));
    }

    public void initJeeSiteTargetDataSource() {
        Object a;
        try {
            a = RoutingDataSource.createDataSource("default");
            this.setDefaultTargetDataSource(a);
        }
        catch (SQLException a2) {
            logger.error(EventLogTail.float("}\u0006]\u001c\u0014\u001cU\u001aS\r@HP\t@\t\u0014\u001b[\u001dF\u000bQHQ\u001aF\u0007FR\u0014\fQ\u000eU\u001dX\u001c"), (Throwable)a2);
        }
        a = Global.getProperty(PageList.float("f\u0000n\u0007\"\u0000m\u0010m7c\u0011~\u0007i*m\ti\u0017"));
        if (StringUtils.isNotBlank((CharSequence)a)) {
            int n;
            String[] stringArray = StringUtils.split((String)a, (String)EventLogTail.float("D"));
            int n2 = stringArray.length;
            int n3 = n = 0;
            while (n3 < n2) {
                String a3 = stringArray[n];
                try {
                    a3 = StringUtils.trim((String)a3);
                    DataSource a4 = RoutingDataSource.createDataSource(a3);
                    this.addTargetDataSource(a3, a4);
                }
                catch (SQLException a5) {
                    logger.error(new StringBuilder().insert(0, PageList.float("-b\rxDx\u0005~\u0003i\u0010,\u0000m\u0010mD\u007f\u000by\u0016o\u0001,\u0001~\u0016c\u00166D")).append(a3).toString(), (Throwable)a5);
                }
                n3 = ++n;
            }
        }
    }

    public void setTargetDataSources(Map<Object, Object> targetDataSources) {
        this.targetDataSources = targetDataSources;
        super.setTargetDataSources(this.targetDataSources);
    }

    public static DataSource createDataSource(String dataSourceName) throws SQLException {
        boolean a = Global.getPropertyToBoolean(EventLogTail.float("^\fV\u000b\u001a\u0002@\t\u001a\rZ\tV\u0004Q\f"), "false");
        return RoutingDataSource.createDataSource(dataSourceName, a);
    }
}

