/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.gen.entity.config;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.j2cache.cache.support.utils.J2CacheConfigUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.service.ServiceException;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.validator.constraints.Length;

@XmlRootElement(name="template")
public class GenTemplate
extends DataEntity<GenTemplate> {
    private String name;
    private static final long serialVersionUID = 1L;
    private String fileName;
    private String filePath;
    private String content;
    private String category;

    public void setName(String name) {
        this.name = name;
    }

    public String getCategory() {
        return this.category;
    }

    public GenTemplate(String id) {
        super(id);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    @NotBlank
    @Length(min=0, max=200)
    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @XmlTransient
    public List<String> getCategoryList() {
        if (this.category == null) {
            return ListUtils.newArrayList();
        }
        return ListUtils.newArrayList((Object[])StringUtils.split((String)this.category, (String)J2CacheConfigUtils.float("|")));
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setCategoryList(List<String> categoryList) {
        if (categoryList == null) {
            this.category = "";
            return;
        }
        this.category = new StringBuilder().insert(0, ServiceException.float("(")).append(StringUtils.join(categoryList, (String)J2CacheConfigUtils.float("|"))).append(ServiceException.float("(")).toString();
    }

    public GenTemplate() {
    }
}

