/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.utils;

import com.jeesite.common.cache.CacheUtils;
import com.jeesite.common.codec.Md5Utils;
import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.collect.SetUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.annotation.MyBatisDao;
import com.jeesite.common.service.ServiceException;
import com.jeesite.common.shiro.realm.LoginInfo;
import com.jeesite.common.shiro.session.StaticSession;
import com.jeesite.common.utils.SpringUtils;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.sys.entity.Menu;
import com.jeesite.modules.sys.entity.Role;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.utils.A;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.hyperic.sigar.NfsClientV3;
import org.hyperic.sigar.NfsServerV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUtils {
    public static final String USER_CACHE = "userCache";
    public static final String CACHE_MENU_LIST = "menuList";
    private static final String USER_CACHE_USER_CODE_ = "code_";
    private static final String USER_CACHE_USER_TYPE_AND_REF_CODE_ = "type_ref_";
    private static Lock userCacheLock = new ReentrantLock();
    private static Logger logger = LoggerFactory.getLogger(UserUtils.class);
    public static final String CACHE_AUTH_INFO = "authInfo";
    private static final String USER_CACHE_LOGIN_CODE_ = "login_";

    public static String getSsoToken(String username) {
        String a = Global.getConfig(NfsClientV3.float("7A-[+\u00077Z+\u00077L'[!]\u000fL="));
        if (StringUtils.isBlank((CharSequence)a)) {
            logger.warn(NfsServerV2.float("\u5c11\u6018\u65c8\u4ec9oL'V=PaL<PaL*\\=Z;t*Fo\u4e05\u7a35\uff33\u8bb8\u8b81\u7f21\u5431\u51c2\u64f2\u4f13\u303d"));
            return null;
        }
        if (Global.getConfigToBoolean(NfsClientV3.float("Z,@6FjZ7FjL*J6P4]\u000fL="), "true").booleanValue()) {
            a = Global.getPropertyDecodeAndEncode(NfsServerV2.float(")\t.\\\u007f\u000fw\n\u007f\r}[+\u000bxY~Y*\nwZ\u007f[)YyY\u007f\u0007w\f"), NfsClientV3.float("7A-[+\u00077Z+\u00077L'[!]\u000fL="), a);
        }
        return Md5Utils.md5((String)new StringBuilder().insert(0, a).append(username).append(DateUtils.getDate((String)NfsServerV2.float("6F6F\u0002r+["))).toString());
    }

    public static List<Menu> getMenuTree() {
        ArrayList a = ListUtils.newArrayList();
        List<Menu> a2 = UserUtils.getMenuList();
        A.float().convertChildList(a2, a, "0");
        return a2;
    }

    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static void removeCache(String key) {
        LoginInfo a = UserUtils.getLoginInfo();
        if (a != null) {
            String a2 = a.getId();
            CacheUtils.remove(new StringBuilder().insert(0, NfsClientV3.float("\\7L6j%J,L\u001b")).append(a2).toString(), key);
            return;
        }
        UserUtils.getSession().removeAttribute((Object)key);
    }

    public static <V> void putCache(String key, V value) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            LoginInfo a = UserUtils.getLoginInfo();
            if (a != null) {
                String a2 = a.getId();
                CacheUtils.put(new StringBuilder().insert(0, NfsServerV2.float(":L*M\f^,W*`")).append(a2).toString(), key, value);
                return;
            }
            UserUtils.getSession().setAttribute((Object)key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User getByLoginCode(String loginCode) {
        if (StringUtils.isBlank((CharSequence)loginCode)) {
            return null;
        }
        String a = new StringBuilder().insert(0, USER_CACHE_LOGIN_CODE_).append(loginCode).toString();
        String a2 = CacheUtils.get(USER_CACHE, a);
        if (a2 != null) {
            return UserUtils.get(a2);
        }
        userCacheLock.lock();
        try {
            a2 = CacheUtils.get(USER_CACHE, a);
            if (a2 != null) {
                User user = UserUtils.get(a2);
                return user;
            }
            User a3 = new User();
            a3.setLoginCode(loginCode);
            a3 = A.float().getByLoginCode(a3);
            a3 = UserUtils.returnUser(a3);
            if (a3 != null) {
                User user = (User)a3.clone();
                return user;
            }
        }
        finally {
            userCacheLock.unlock();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadRefObj(User user) {
        if (user.getRefObj() != null) return;
        if (!StringUtils.isNotBlank((CharSequence)user.getUserType())) return;
        if (!StringUtils.isNotBlank((CharSequence)user.getRefCode())) return;
        String a = UserUtils.getUserTypeValue(user.getUserType(), NfsClientV3.float(" H+"));
        if (!StringUtils.isNotBlank((CharSequence)a)) return;
        try {
            User user2;
            Object a2;
            block6: {
                int n;
                a2 = SpringUtils.getBean(a);
                Class<?>[] classArray = a2.getClass().getInterfaces();
                int n2 = classArray.length;
                int n3 = n = 0;
                while (n3 < n2) {
                    MyBatisDao a3 = classArray[n].getAnnotation(MyBatisDao.class);
                    if (a3 != null) {
                        Class[] classArray2 = new Class[1];
                        classArray2[0] = String.class;
                        Object[] objectArray = new Object[1];
                        objectArray[0] = user.getRefCode();
                        user.setRefObj(a3.entity().getConstructor(classArray2).newInstance(objectArray));
                        user2 = user;
                        break block6;
                    }
                    n3 = ++n;
                }
                user2 = user;
            }
            if (user2.getRefObj() == null) return;
            Class[] classArray = new Class[1];
            classArray[0] = Object.class;
            Object[] objectArray = new Object[1];
            objectArray[0] = user.getRefObj();
            Object a4 = a2.getClass().getMethod(NfsServerV2.float("X*K"), classArray).invoke(a2, objectArray);
            if (a4 == null) return;
            user.setRefObj(a4);
            return;
        }
        catch (Exception a5) {
            a5.printStackTrace();
        }
    }

    public static void removeCacheByKeyPrefix(String keyPrefix) {
        LoginInfo a = UserUtils.getLoginInfo();
        if (a != null) {
            String a2 = a.getId();
            CacheUtils.removeByKeyPrefix(new StringBuilder().insert(0, NfsClientV3.float("\\7L6j%J,L\u001b")).append(a2).toString(), keyPrefix);
        }
    }

    public static User getUser() {
        User a;
        LoginInfo a2 = UserUtils.getLoginInfo();
        if (a2 != null && (a = UserUtils.get(a2.getId())) != null) {
            return a;
        }
        return new User();
    }

    public static <V> V getCache(String key) {
        LoginInfo a = UserUtils.getLoginInfo();
        if (a != null) {
            String a2 = a.getId();
            return (V)CacheUtils.get(new StringBuilder().insert(0, NfsServerV2.float(":L*M\f^,W*`")).append(a2).toString(), key);
        }
        return (V)UserUtils.getSession().getAttribute((Object)key);
    }

    public static <V> V getCache(String key, V defaultValue) {
        V a = UserUtils.getCache(key);
        if (a != null) {
            return a;
        }
        return defaultValue;
    }

    /*
     * Unable to fully structure code
     */
    public static List<Menu> getMenuListByParentCode(String parentCode) {
        block3: {
            block5: {
                block4: {
                    a = ObjectUtils.toStringIgnoreNull((Object)UserUtils.getSession().getAttribute((Object)NfsClientV3.float("7P7j+M!")), (String)"default");
                    a = new StringBuilder().insert(0, NfsServerV2.float("R*Q:s&L;`")).append(a).append(NfsClientV3.float("\u001b")).append(parentCode).toString();
                    a = (List<Menu>)UserUtils.getCache(a);
                    if (a != null) break block3;
                    var5_4 = new Menu();
                    v0 = a;
                    v0.setSysCode(a);
                    v0.setParentCode(parentCode);
                    a = UserUtils.getUser();
                    if (!User.isSuperAdmin(a.getUserCode())) break block4;
                    a.setWeight_gte(Menu.SUPER_ADMIN_GET_MENU_MIN_WEIGHT);
                    a = A.float().findList((Menu)a);
                    v1 = a;
                    break block5;
                }
                if (!"none".equals(a.getUserType()) && StringUtils.isNotBlank((CharSequence)(a = Global.getConfig(new StringBuilder().insert(0, NfsServerV2.float("<F<\u0011:L*Ma[*Y.J#K\u001dP#Z\fP+Z<\u0011")).append(a.getUserType()).toString())))) {
                    a.setDefaultRoleCodes(StringUtils.split((String)a, (char)','));
                }
                if (!"1".equals(a.getMgrType())) ** GOTO lbl34
                if (a.getDefaultRoleCodes() != null) {
                    v2 = a;
                    a = SetUtils.newHashSet((Object[])v2.getDefaultRoleCodes());
                    a.add(Role.CORP_ADMIN_ROLE_CODE);
                    v2.setDefaultRoleCodes(a.toArray(new String[a.size()]));
                    v3 = a;
                } else {
                    v4 = new String[1];
                    v4[0] = Role.CORP_ADMIN_ROLE_CODE;
                    a.setDefaultRoleCodes(v4);
lbl34:
                    // 2 sources

                    v3 = a;
                }
                v3.setUserCode(a.getId());
                a = A.float().findByUserCode((Menu)a);
                v1 = a;
            }
            UserUtils.putCache(v1, a);
        }
        return a;
    }

    public static void clearCache(User user) {
        if (user == null || StringUtils.isBlank((CharSequence)user.getUserCode())) {
            return;
        }
        User a = (User)((Object)CacheUtils.get(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_USER_CODE_).append(user.getUserCode()).toString()));
        if (a != null && StringUtils.isNotBlank((CharSequence)a.getUserCode())) {
            CacheUtils.remove(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_USER_CODE_).append(a.getUserCode()).toString());
            CacheUtils.remove(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_LOGIN_CODE_).append(a.getLoginCode()).toString());
            if (StringUtils.isNotBlank((CharSequence)a.getUserType()) && StringUtils.isNotBlank((CharSequence)a.getRefCode())) {
                CacheUtils.remove(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_USER_TYPE_AND_REF_CODE_).append(a.getUserType()).append(NfsClientV3.float("\u001b")).append(a.getRefCode()).toString());
            }
            CacheUtils.removeCache(new StringBuilder().insert(0, NfsServerV2.float(":L*M\f^,W*`")).append(a.getUserCode()).toString());
        }
    }

    public static LoginInfo getLoginInfo() {
        try {
            Subject a = UserUtils.getSubject();
            LoginInfo a2 = (LoginInfo)a.getPrincipal();
            if (a2 != null) {
                return a2;
            }
        }
        catch (UnavailableSecurityManagerException a) {
        }
        catch (InvalidSessionException a) {
            // empty catch block
        }
        return null;
    }

    public static List<Menu> getMenuList() {
        return UserUtils.getMenuListByParentCode(null);
    }

    public static void clearCache() {
        LoginInfo a = UserUtils.getLoginInfo();
        if (a != null) {
            String a2 = a.getId();
            User a3 = (User)((Object)CacheUtils.get(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_USER_CODE_).append(a2).toString()));
            if (a3 != null) {
                UserUtils.clearCache(a3);
            }
        }
    }

    public static Session getSession() {
        try {
            Subject a = UserUtils.getSubject();
            Session a2 = a.getSession(false);
            if (a2 == null) {
                a2 = a.getSession(true);
            }
            if (a2 != null) {
                return a2;
            }
        }
        catch (UnavailableSecurityManagerException a) {
        }
        catch (InvalidSessionException a) {
            // empty catch block
        }
        return StaticSession.INSTANCE;
    }

    private static /* synthetic */ User returnUser(User user) {
        if (user == null) {
            return null;
        }
        if (!"none".equals(user.getUserType())) {
            UserUtils.loadRefObj(user);
        }
        user.setRoleList(A.float().findListByUserCode(new Role(user)));
        CacheUtils.put(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_USER_CODE_).append(user.getId()).toString(), user);
        CacheUtils.put(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_LOGIN_CODE_).append(user.getLoginCode()).toString(), user.getUserCode());
        if (StringUtils.isNotBlank((CharSequence)user.getUserType()) && StringUtils.isNotBlank((CharSequence)user.getRefCode())) {
            CacheUtils.put(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_USER_TYPE_AND_REF_CODE_).append(user.getUserType()).append(NfsClientV3.float("\u001b")).append(user.getRefCode()).toString(), user.getUserCode());
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User getByTypeAndRef(String userType, String refCode) {
        if (StringUtils.isBlank((CharSequence)userType) || StringUtils.isBlank((CharSequence)refCode)) {
            return null;
        }
        String a = new StringBuilder().insert(0, USER_CACHE_USER_TYPE_AND_REF_CODE_).append(userType).append(NfsServerV2.float("`")).append(refCode).toString();
        String a2 = CacheUtils.get(USER_CACHE, a);
        if (a2 != null) {
            return UserUtils.get(a2);
        }
        userCacheLock.lock();
        try {
            User a3;
            a2 = CacheUtils.get(USER_CACHE, a);
            if (a2 != null) {
                User user = UserUtils.get(a2);
                return user;
            }
            User user = new User();
            void v0 = a3;
            v0.setUserType(userType);
            v0.setRefCode(refCode);
            a3 = A.float().getByUserTypeAndRefCode(a3);
            a3 = UserUtils.returnUser(a3);
            if (a3 != null) {
                User user2 = (User)a3.clone();
                return user2;
            }
        }
        finally {
            userCacheLock.unlock();
        }
        return null;
    }

    public static AuthorizationInfo getAuthInfo() {
        Session a = UserUtils.getSession();
        return (AuthorizationInfo)UserUtils.getCache(new StringBuilder().insert(0, NfsClientV3.float("%\\0A\rG\"F\u001b")).append(a.getId()).toString());
    }

    public static String getUserTypeValue(String userType, String key) {
        if (A.float() == null) {
            throw new ServiceException(NfsServerV2.float("%Z*L&K*\u00116R#\u4e12\u76cbJ<Z=\u0011:L*M\u001bF?Z\u0002^?\u9172\u7f21\u4e32\u6b2c\u7851\u6259\u6c9e\u6746\u5ba5\u4e06\u303d"));
        }
        if ("none".equals(userType)) {
            return null;
        }
        Map a = (Map)A.float().get(userType);
        if (a != null && a.get(key) != null) {
            return (String)a.get(key);
        }
        logger.warn(new StringBuilder().insert(0, NfsClientV3.float("C!L7@0LjP)E\u4e69\u76ad1Z![j\\7L6}=Y!d%Y\u6ce5\u6720\u9109\u7f47\u2058")).append(userType).append(NfsServerV2.float("\u2022\u7567\u6208\u7c34\u57b4\u76cb\u2023")).append(key).append(NfsClientV3.float("\u2059\u5015\u3046")).toString());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User get(String userCode) {
        User a;
        Object a2;
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return null;
        }
        HttpServletRequest a3 = ServletUtils.getRequest();
        if (a3 != null) {
            a2 = (User)a3.getAttribute(NfsServerV2.float("\u0010`:L*M\u0010`") + userCode);
            if (a2 != null) {
                return a2;
            }
        }
        if ((a = (User)((Object)CacheUtils.get(USER_CACHE, a2 = new StringBuilder().insert(0, USER_CACHE_USER_CODE_).append(userCode).toString()))) != null) {
            return (User)a.clone();
        }
        userCacheLock.lock();
        try {
            a = (User)CacheUtils.get(USER_CACHE, a2);
            if (a != null) {
                User user = (User)a.clone();
                return user;
            }
            User a4 = new User(userCode);
            a = A.float().get(a4);
            a = UserUtils.returnUser(a);
            if (a3 != null) {
                a3.setAttribute(new StringBuilder().insert(0, NfsClientV3.float("v\u001b\\7L6v\u001b")).append(userCode).toString(), (Object)a);
            }
            if (a != null) {
                User user = (User)a.clone();
                return user;
            }
            User user = null;
            return user;
        }
        finally {
            userCacheLock.unlock();
        }
    }
}

