/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web;

import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.entity.Config;
import com.jeesite.modules.sys.service.ConfigService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.ProcTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/config"})
@ConditionalOnProperty(name={"web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class ConfigController
extends BaseController {
    @Autowired
    private ConfigService configService;

    @ModelAttribute
    public Config get(String id, boolean isNewRecord) {
        return (Config)this.configService.get(id, isNewRecord);
    }

    @RequiresPermissions(value={"sys:config:view"})
    @RequestMapping(value={"list"})
    public String list(Config config, Model model) {
        return FileSystemUsage.float("\u001e\u001f\u0017\u0005\u001f\u0015\u0000_\u0000\t\u0000_\u0010\u001f\u001d\u0016\u001a\u0017?\u0019\u0000\u0004");
    }

    @RequiresPermissions(value={"sys:config:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated Config config, HttpServletRequest request) {
        Config a = (Config)super.getWebDataBinderSource(request);
        if (a != null && "1".equals(a.getIsSys()) && !config.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", ProcTime.float("\u8dba\u677b\u64fd\u4f64\uff3c\u53d2\u6739\u8dbd\u7e97\u7b99\u7436\u5460\u627d\u80c5\u4fde\u6501\u7ccb\u7ee7\u6540\u6356\uff31"));
        }
        if (!config.getCurrentUser().isSuperAdmin()) {
            Config config2 = config;
            config2.setConfigName(a.getConfigName());
            config2.setConfigKey(a.getConfigKey());
        }
        this.configService.save(config);
        return this.renderResult("true", FileSystemUsage.float("\u4fad\u5b2b\u53b2\u6503\u6260\u52ec\uff71"));
    }

    @RequiresPermissions(value={"sys:config:edit"})
    @RequestMapping(value={"checkConfigKey"})
    @ResponseBody
    public String checkConfigKey(String oldConfigKey, String configKey) {
        Config a = new Config();
        String string = configKey;
        a.setConfigKey(string);
        if (string != null && configKey.equals(oldConfigKey)) {
            return "true";
        }
        if (configKey != null && this.configService.findCount(a) == 0L) {
            return "true";
        }
        return "false";
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:config:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public Page<Config> listData(Config config, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        void response;
        void request;
        void config2;
        config2.setPage(new Page((HttpServletRequest)request, (HttpServletResponse)response));
        return this.configService.findPage((Config)config2);
    }

    @RequiresPermissions(value={"sys:config:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(Config config, HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getParameter(ProcTime.float("YKcAC")))) {
            return this.renderResult("false", FileSystemUsage.float("\u8dfa\u6730\u64bd\u4f2f\uff7c\u001a\u0003 \t\u0000\u972e\u6ca6\u53b2\u6503\uff71"));
        }
        Config a = (Config)super.getWebDataBinderSource(request);
        if (a != null && "1".equals(a.getIsSys()) && !config.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", ProcTime.float("\u8dba\u677b\u64fd\u4f64\uff3c\u53d2\u6739\u8dbd\u7e97\u7b99\u7436\u5460\u627d\u80c5\u4fde\u6501\u7ccb\u7ee7\u6540\u6356\uff31"));
        }
        this.configService.delete(config);
        return this.renderResult("true", FileSystemUsage.float("\u5250\u9617\u53b2\u6503\u6260\u52ec\uff71"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:config:view"})
    @RequestMapping(value={"form"})
    public String form(Config config, Model model) {
        void config2;
        void model2;
        model2.addAttribute(ProcTime.float("[_VVQW"), (Object)config2);
        return FileSystemUsage.float("\u001e\u001f\u0017\u0005\u001f\u0015\u0000_\u0000\t\u0000_\u0010\u001f\u001d\u0016\u001a\u00175\u001f\u0001\u001d");
    }
}

