/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.jni;

import com.jeesite.autoconfigure.sys.FileAutoConfiguration;
import com.jeesite.modules.sys.web.AdviceController;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import org.hyperic.jni.ArchLoaderException;
import org.hyperic.jni.ArchName;
import org.hyperic.jni.ArchNotSupportedException;

public class ArchLoader {
    public static final boolean IS_OSF1;
    private static final String osName;
    public static final boolean IS_DARWIN;
    private String name;
    public static final boolean IS_WIN32;
    public static final boolean IS_AIX;
    public static final boolean IS_FREEBSD;
    private Class loaderClass;
    private File nativeLibrary;
    private String libName;
    private String jarName;
    private boolean loaded;
    private String packageName;
    private String resourcePath;
    private Object loadLock;
    private String version;
    public static final boolean IS_LINUX;
    public static final boolean IS_NETWARE;
    public static final boolean IS_SOLARIS;
    public static final boolean IS_HPUX;

    private /* synthetic */ boolean isJarURL(URL url) {
        String a;
        if (url == null) {
            return false;
        }
        String a2 = url.getFile();
        if (a2.indexOf(a = this.getJarName()) != -1) {
            return true;
        }
        int a3 = a.indexOf(".jar");
        if (a3 != -1) {
            if ((a3 = a2.lastIndexOf(a = new StringBuilder().insert(0, a.substring(0, a3)).append(AdviceController.float("g")).toString())) != -1) {
                a = a2.substring(a3);
                if ((a3 = a.indexOf(".jar")) == -1) {
                    return false;
                }
                String string = a;
                this.version = string.substring(a.indexOf(45) + 1, a3);
                a = string.substring(0, a3 + 4);
                this.setJarName(a);
                return true;
            }
            return false;
        }
        return false;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String value) {
        this.packageName = value;
    }

    public String getName() {
        return this.name;
    }

    protected void systemLoadLibrary(String name) {
        System.loadLibrary(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String path) throws ArchNotSupportedException, ArchLoaderException {
        Object object = this.loadLock;
        synchronized (object) {
            block4: {
                if (!this.loaded) break block4;
                return;
            }
            this.loadLibrary(path);
            this.loaded = true;
            return;
        }
    }

    public void setJarName(String value) {
        this.jarName = value;
    }

    public static String getLibraryExtension() {
        if (IS_WIN32) {
            return FileAutoConfiguration.float("_\r\u001d\u0005");
        }
        if (IS_NETWARE) {
            return AdviceController.float("+$i'");
        }
        if (IS_DARWIN) {
            return FileAutoConfiguration.float("_\r\b\u0005\u0018\u000b");
        }
        if (IS_HPUX) {
            return AdviceController.float("dv&");
        }
        return FileAutoConfiguration.float("G\u0002\u0006");
    }

    protected boolean containsNativeLibrary(File dir, String name) {
        if (name == null) {
            return false;
        }
        File a = new File(dir, name);
        if (a.exists()) {
            this.nativeLibrary = a;
            return true;
        }
        return false;
    }

    protected void systemLoad(String name) {
        System.load(name);
    }

    public String getLibName() {
        return this.libName;
    }

    private /* synthetic */ String findJarPath(String libName, boolean isRequired) throws ArchLoaderException {
        String a;
        URL uRL;
        Object a2;
        URL a3;
        String a4;
        block11: {
            if (this.getJarName() == null) {
                throw new ArchLoaderException(AdviceController.float(" d8K+h/%#vjk?i&"));
            }
            ArchLoader archLoader = this;
            a4 = archLoader.getResourcePath();
            ClassLoader a5 = archLoader.getClassLoader();
            a3 = a5.getResource(a4);
            if (!archLoader.isJarURL(a3)) {
                a3 = null;
            }
            if (a3 == null && a5 instanceof URLClassLoader) {
                int a6;
                a2 = ((URLClassLoader)a5).getURLs();
                int n = a6 = 0;
                while (n < ((URL[])a2).length) {
                    if (this.isJarURL(a2[a6])) {
                        uRL = a3 = a2[a6];
                        break block11;
                    }
                    n = ++a6;
                }
            }
            uRL = a3;
        }
        if (uRL == null) {
            if (isRequired) {
                throw new ArchLoaderException(new StringBuilder().insert(0, FileAutoConfiguration.float("<\u001f\b\u0013\u0005\u0014I\u0005\u0006Q\u000f\u0018\u0007\u0015I")).append(this.getJarName()).toString());
            }
            return null;
        }
        a4 = a3.getFile();
        if (a4.startsWith(AdviceController.float(",l&`p"))) {
            a4 = a4.substring(5);
        }
        a2 = new File(a4);
        String a7 = this.getJarName();
        Object object = a2;
        while (object != null && !((File)a2).getName().startsWith(a7)) {
            object = ((File)a2).getParentFile();
        }
        if (libName == null) {
            libName = a7;
        }
        if (a2 != null && (a2 = ((File)a2).getParentFile()) != null && this.findNativeLibrary(a = URLDecoder.decode(((File)a2).toString()), libName)) {
            return a;
        }
        return null;
    }

    public ArchLoader(Class loaderClass) {
        ArchLoader archLoader = this;
        ArchLoader archLoader2 = this;
        ArchLoader archLoader3 = this;
        ArchLoader archLoader4 = this;
        archLoader4.loadLock = new Object();
        archLoader3.loaded = false;
        archLoader3.libName = null;
        archLoader2.setLoaderClass(loaderClass);
        String a = loaderClass.getName();
        int a2 = a.lastIndexOf(".");
        a = a.substring(0, a2);
        archLoader2.setPackageName(a);
        String string = a;
        a2 = string.lastIndexOf(".");
        archLoader.setName(string.substring(a2 + 1));
        ArchLoader archLoader5 = this;
        archLoader5.setJarName(new StringBuilder().insert(0, archLoader5.getName()).append(".jar").toString());
        archLoader.setResourcePath(archLoader.toResName(a));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadLibrary(String path) throws ArchNotSupportedException, ArchLoaderException {
        try {
            ArchLoader archLoader;
            String a = this.getLibraryName();
            if (path == null) {
                path = System.getProperty(new StringBuilder().insert(0, this.getPackageName()).append(FileAutoConfiguration.float("G\u0001\b\u0005\u0001")).toString());
            }
            if (path != null) {
                if (path.equals(AdviceController.float("g"))) {
                    return;
                }
                ArchLoader archLoader2 = this;
                archLoader = archLoader2;
                archLoader2.findJarPath(null, false);
                this.findNativeLibrary(path, a);
            } else {
                if (this.findJarPath(a, false) == null) {
                    this.findInJavaLibraryPath(a);
                }
                archLoader = this;
            }
            ArchLoader archLoader3 = this;
            if (archLoader.nativeLibrary != null) {
                archLoader3.systemLoad(this.nativeLibrary.toString());
                return;
            }
            archLoader3.systemLoadLibrary(a);
            return;
        }
        catch (RuntimeException a) {
            String a2 = a.getMessage();
            if (a2 == null) {
                a2 = a.getClass().getName();
            }
            String a3 = new StringBuilder().insert(0, FileAutoConfiguration.float("/\u0010\u0000\u001d\f\u0015I\u0005\u0006Q\u0005\u001e\b\u0015I")).append(this.libName).append(AdviceController.float("?j")).append(a2).toString();
            throw new ArchLoaderException(a3);
        }
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getDefaultLibName() throws ArchNotSupportedException {
        return System.getProperty(new StringBuilder().insert(0, this.getPackageName()).append(FileAutoConfiguration.float("_\u0005\u0018\u000b\u001f\b\u001c\f")).toString(), new StringBuilder().insert(0, AdviceController.float("o+s+")).append(this.getArchLibName()).toString());
    }

    public String getVersionedLibraryName() {
        if (this.version == null) {
            return null;
        }
        try {
            this.getLibraryName();
        }
        catch (ArchNotSupportedException a) {
            return null;
        }
        String a = ArchLoader.getLibraryPrefix();
        String a2 = ArchLoader.getLibraryExtension();
        return new StringBuilder().insert(0, a).append(this.libName).append('-').append(this.version).append(a2).toString();
    }

    public void setResourcePath(String value) {
        this.resourcePath = value;
    }

    public void setName(String value) {
        this.name = value;
    }

    protected boolean findInJavaLibraryPath(String libName) {
        String a = System.getProperty(FileAutoConfiguration.float("\u0003\u0010\u001f\u0010G\u001d\u0000\u0013\u001b\u0010\u001b\bG\u0001\b\u0005\u0001"), "");
        StringTokenizer a2 = new StringTokenizer(a, File.pathSeparator);
        while (a2.hasMoreTokens()) {
            a = a2.nextToken();
            if (!this.findNativeLibrary(a, libName)) continue;
            return true;
        }
        return false;
    }

    public static String getLibraryPrefix() {
        if (IS_WIN32 || IS_NETWARE) {
            return "";
        }
        return AdviceController.float("&l(");
    }

    public String findJarPath(String libName) throws ArchLoaderException {
        return this.findJarPath(libName, true);
    }

    public Class getLoaderClass() {
        return this.loaderClass;
    }

    public String getJarName() {
        return this.jarName;
    }

    protected boolean findNativeLibrary(String dir, String name) {
        File a = new File(dir).getAbsoluteFile();
        if (this.containsNativeLibrary(a, name)) {
            return true;
        }
        if (this.containsNativeLibrary(a, this.getVersionedLibraryName())) {
            return true;
        }
        return this.containsNativeLibrary(a, ArchLoader.getLibraryPrefix() + this.getName() + ArchLoader.getLibraryExtension());
    }

    private /* synthetic */ String toResName(String name) {
        int a;
        StringBuffer a2 = new StringBuffer(name);
        int n = a = 0;
        while (n < a2.length()) {
            if (a2.charAt(a) == '.') {
                a2.setCharAt(a, '/');
            }
            n = ++a;
        }
        return a2.toString();
    }

    public String getArchLibName() throws ArchNotSupportedException {
        return new StringBuilder().insert(0, this.getName()).append(FileAutoConfiguration.float("D")).append(ArchName.getName()).toString();
    }

    public ArchLoader() {
        ArchLoader archLoader = this;
        ArchLoader archLoader2 = this;
        archLoader2.loadLock = new Object();
        archLoader.loaded = false;
        archLoader.libName = null;
    }

    public ClassLoader getClassLoader() {
        return this.getLoaderClass().getClassLoader();
    }

    public String getLibraryName() throws ArchNotSupportedException {
        String a = this.getLibName();
        if (a == null) {
            ArchLoader archLoader = this;
            a = archLoader.getDefaultLibName();
            archLoader.setLibName(a);
        }
        String a2 = ArchLoader.getLibraryPrefix();
        String a3 = ArchLoader.getLibraryExtension();
        return new StringBuilder().insert(0, a2).append(a).append(a3).toString();
    }

    public void load() throws ArchNotSupportedException, ArchLoaderException {
        this.load(null);
    }

    public void setLoaderClass(Class value) {
        this.loaderClass = value;
    }

    public void setLibName(String value) {
        this.libName = value;
    }

    public File getNativeLibrary() {
        return this.nativeLibrary;
    }

    static {
        osName = System.getProperty(AdviceController.float("%vdk+h/"));
        IS_WIN32 = osName.startsWith(FileAutoConfiguration.float(">\u0018\u0007\u0015\u0006\u0006\u001a"));
        IS_AIX = osName.equals("AIX");
        IS_HPUX = osName.equals(AdviceController.float("\u0002UgP\u0012"));
        IS_SOLARIS = osName.equals(FileAutoConfiguration.float(":\u0004\u0007>:"));
        IS_LINUX = osName.equals("Linux");
        IS_DARWIN = osName.equals(AdviceController.float("H+fjJ\u0019%\u0012")) || osName.equals(FileAutoConfiguration.float("5\b\u0003\u001e\u0018\u0007"));
        IS_OSF1 = osName.equals(AdviceController.float("J\u0019C{"));
        IS_FREEBSD = osName.equals("FreeBSD");
        IS_NETWARE = osName.equals("NetWare");
    }
}

