/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.FileWatcher;
import org.hyperic.sigar.NfsServerV2;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class Cpu
implements Serializable {
    long total;
    long stolen;
    private static final long serialVersionUID = 8076L;
    long idle;
    long sys;
    long user;
    long softIrq;
    long wait;
    long nice;
    long irq;

    public long getWait() {
        return this.wait;
    }

    public long getSys() {
        return this.sys;
    }

    public long getIdle() {
        return this.idle;
    }

    public long getUser() {
        return this.user;
    }

    public long getNice() {
        return this.nice;
    }

    static Cpu fetch(Sigar sigar) throws SigarException {
        Cpu cpu = new Cpu();
        cpu.gather(sigar);
        return cpu;
    }

    public long getStolen() {
        return this.stolen;
    }

    public long getTotal() {
        return this.total;
    }

    /*
     * WARNING - void declaration
     */
    void copyTo(Cpu cpu) {
        void copy;
        void v0 = copy;
        Cpu cpu2 = this;
        void v2 = copy;
        Cpu cpu3 = this;
        void v4 = copy;
        Cpu cpu4 = this;
        copy.user = cpu4.user;
        v4.sys = cpu4.sys;
        v4.nice = this.nice;
        copy.idle = cpu3.idle;
        v2.wait = cpu3.wait;
        v2.irq = this.irq;
        copy.softIrq = cpu2.softIrq;
        v0.stolen = cpu2.stolen;
        v0.total = this.total;
    }

    public Map toMap() {
        HashMap<String, String> a = new HashMap<String, String>();
        String a2 = String.valueOf(this.user);
        if (!NfsServerV2.float("b\u000e").equals(a2)) {
            a.put(FileWatcher.float("\u0014*$+"), a2);
        }
        String a3 = String.valueOf(this.sys);
        if (!NfsServerV2.float("b\u000e").equals(a3)) {
            a.put(FileWatcher.float("\n8*"), a3);
        }
        String a4 = String.valueOf(this.nice);
        if (!NfsServerV2.float("b\u000e").equals(a4)) {
            a.put(FileWatcher.float("\u000f0\"<"), a4);
        }
        String a5 = String.valueOf(this.idle);
        if (!NfsServerV2.float("b\u000e").equals(a5)) {
            a.put(FileWatcher.float("\b=-<"), a5);
        }
        String a6 = String.valueOf(this.wait);
        if (!NfsServerV2.float("b\u000e").equals(a6)) {
            a.put(FileWatcher.float("\u00168(-"), a6);
        }
        String a7 = String.valueOf(this.irq);
        if (!NfsServerV2.float("b\u000e").equals(a7)) {
            a.put(FileWatcher.float("\u00103("), a7);
        }
        String a8 = String.valueOf(this.softIrq);
        if (!NfsServerV2.float("b\u000e").equals(a8)) {
            a.put(FileWatcher.float("\n.?5\u00103("), a8);
        }
        String a9 = String.valueOf(this.stolen);
        if (!NfsServerV2.float("b\u000e").equals(a9)) {
            a.put(FileWatcher.float("\u0012-.5$7"), a9);
        }
        String a10 = String.valueOf(this.total);
        if (!NfsServerV2.float("b\u000e").equals(a10)) {
            a.put(FileWatcher.float("\r.- 5"), a10);
        }
        return a;
    }

    public long getIrq() {
        return this.irq;
    }

    public long getSoftIrq() {
        return this.softIrq;
    }

    public String toString() {
        return this.toMap().toString();
    }

    public Cpu() {
        Cpu cpu = this;
        Cpu cpu2 = this;
        Cpu cpu3 = this;
        Cpu cpu4 = this;
        this.user = 0L;
        cpu4.sys = 0L;
        cpu4.nice = 0L;
        cpu3.idle = 0L;
        cpu3.wait = 0L;
        cpu2.irq = 0L;
        cpu2.softIrq = 0L;
        cpu.stolen = 0L;
        cpu.total = 0L;
    }

    public native void gather(Sigar var1) throws SigarException;
}

