/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import com.jeesite.autoconfigure.sys.FileAutoConfiguration;
import com.jeesite.common.mybatis.mapper.query.QueryColumn;
import java.io.Serializable;
import org.hyperic.sigar.Cpu;
import org.hyperic.sigar.Sigar;

public class CpuPerc
implements Serializable {
    private double nice;
    private double sys;
    private double irq;
    private double softIrq;
    private double user;
    private static final long serialVersionUID = 1393671L;
    private double idle;
    private double stolen;
    private double wait;
    private double combined;

    public double getIdle() {
        return this.idle;
    }

    static CpuPerc fetch(Sigar sigar, Cpu oldCpu, Cpu curCpu) {
        CpuPerc cpuPerc = new CpuPerc();
        cpuPerc.gather(sigar, oldCpu, curCpu);
        return cpuPerc;
    }

    public double getIrq() {
        return this.irq;
    }

    public double getStolen() {
        return this.stolen;
    }

    public static String format(double val) {
        int a;
        String a2 = String.valueOf(val * 100.0);
        int n = a = a2.indexOf(".") + 1;
        String a3 = new StringBuilder().insert(0, a2.substring(0, a)).append(a2.substring(n, n + 1)).toString();
        return new StringBuilder().insert(0, a3).append(FileAutoConfiguration.float("L")).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CpuPerc calculate(Cpu oldCpu, Cpu curCpu) {
        try (Sigar a = new Sigar();){
            CpuPerc cpuPerc = CpuPerc.fetch(a, oldCpu, curCpu);
            return cpuPerc;
        }
    }

    public String toString() {
        return new StringBuilder().insert(0, QueryColumn.float("\"r4\u0002\u0012V\u0000V\u0004Q[\u0002")).append(CpuPerc.format(this.user)).append(FileAutoConfiguration.float("I\u0004\u001a\u0014\u001b]I")).append(CpuPerc.format(this.sys)).append(QueryColumn.float("\u0002\u0012[\u0012V\u0004OM\u0002")).append(CpuPerc.format(this.nice)).append(FileAutoConfiguration.float("I\u001f\u0000\u0012\f]I")).append(CpuPerc.format(this.wait)).append(QueryColumn.float("\u0002\u0016C\bVM\u0002")).append(CpuPerc.format(this.idle)).append(FileAutoConfiguration.float("I\u0018\r\u001d\f")).toString();
    }

    public double getSys() {
        return this.sys;
    }

    native void gather(Sigar var1, Cpu var2, Cpu var3);

    public double getUser() {
        return this.user;
    }

    CpuPerc() {
    }

    public double getCombined() {
        return this.combined;
    }

    public double getNice() {
        return this.nice;
    }

    public double getSoftIrq() {
        return this.softIrq;
    }

    public double getWait() {
        return this.wait;
    }
}

