/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import com.jeesite.common.j2cache.autoconfigure.J2CacheSpringRedisAutoConfiguration;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.ProcCredName;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ThreadCpu;
import org.hyperic.sigar.jmx.CpuTimerMBean;

public class CpuTimer
implements CpuTimerMBean {
    private long totalTime;
    private long cpuSys;
    private long startTime;
    private long cpuTotal;
    private ThreadCpu cpu;
    private long cpuSampleTime;
    private Sigar sigar;
    private long cpuSampleLast;
    private long cpuUser;
    private static final Map timers = Collections.synchronizedMap(new HashMap());
    private long stopTime;
    private long cpuSampleFirst;

    public void clear() {
        CpuTimer cpuTimer = this;
        CpuTimer cpuTimer2 = this;
        CpuTimer cpuTimer3 = this;
        CpuTimer cpuTimer4 = this;
        this.startTime = -1L;
        cpuTimer4.stopTime = -1L;
        cpuTimer4.totalTime = 0L;
        cpuTimer3.cpuTotal = 0L;
        cpuTimer3.cpuUser = 0L;
        cpuTimer2.cpuSys = 0L;
        cpuTimer2.cpuSampleFirst = 0L;
        cpuTimer.cpuSampleLast = 0L;
        cpuTimer.cpuSampleTime = 0L;
    }

    public static CpuTimer getInstance(String name) {
        CpuTimer a = (CpuTimer)timers.get(name);
        if (a == null) {
            a = new CpuTimer();
            timers.put(name, a);
        }
        return a;
    }

    @Override
    public long getTotalTime() {
        return this.totalTime;
    }

    @Override
    public long getCpuUser() {
        CpuTimer cpuTimer = this;
        return cpuTimer.toMillis(cpuTimer.cpuUser);
    }

    @Override
    public long getCpuSys() {
        CpuTimer cpuTimer = this;
        return cpuTimer.toMillis(cpuTimer.cpuSys);
    }

    @Override
    public long getLastSampleTime() {
        return this.stopTime;
    }

    public CpuTimer(Sigar sigar) {
        CpuTimer cpuTimer = this;
        this.cpu = new ThreadCpu();
        this.clear();
        this.sigar = sigar;
    }

    private /* synthetic */ long toMillis(long ns) {
        return ns / 1000000L;
    }

    public String format(long elap) {
        String a = elap % 1000L + "";
        int a2 = 3 - a.length();
        StringBuffer a3 = new StringBuffer().append(elap / 1000L).append('.');
        int n = a2;
        while (true) {
            --a2;
            if (n <= 0) break;
            n = a2;
            a3.append("0");
        }
        StringBuffer stringBuffer = a3;
        stringBuffer.append(a).append(J2CacheSpringRedisAutoConfiguration.float("cV&F,K'V"));
        return stringBuffer.toString();
    }

    public void start(Sigar sigar) {
        this.startTime = System.currentTimeMillis();
        try {
            this.cpu.gather(sigar, 0L);
        }
        catch (SigarException a) {
            throw new IllegalArgumentException(a.toString());
        }
        this.stamp(this);
    }

    public void start() {
        CpuTimer cpuTimer = this;
        cpuTimer.start(cpuTimer.sigar);
    }

    private /* synthetic */ void stamp(CpuTimer timer) {
        if (this.cpuSampleFirst == 0L) {
            this.cpuSampleFirst = this.toMillis(timer.cpu.total);
            this.cpuSampleTime = timer.startTime;
            return;
        }
        this.cpuSampleLast = this.toMillis(timer.cpu.total);
    }

    public void stop(Sigar sigar) {
        CpuTimer cpuTimer = this;
        ThreadCpu a = cpuTimer.getDiff(sigar);
        cpuTimer.cpuTotal += a.total;
        cpuTimer.cpuUser += a.user;
        cpuTimer.cpuSys += a.sys;
        cpuTimer.stopTime = System.currentTimeMillis();
        double a2 = cpuTimer.stopTime - this.startTime;
        cpuTimer.totalTime = (long)((double)cpuTimer.totalTime + a2);
    }

    @Override
    public long getCpuTotal() {
        CpuTimer cpuTimer = this;
        return cpuTimer.toMillis(cpuTimer.cpuTotal);
    }

    public CpuTimer() {
        this(null);
    }

    public void list(PrintStream out) {
        PrintStream printStream = out;
        CpuTimer cpuTimer = this;
        printStream.println(ProcCredName.float("X\u0018K\u0011\u0004S\u0004S\u0004") + cpuTimer.format(cpuTimer.getTotalTime()));
        CpuTimer cpuTimer2 = this;
        out.println(new StringBuilder().insert(0, J2CacheSpringRedisAutoConfiguration.float("P0@1\u000bm\u000bm\u000b")).append(cpuTimer2.format(cpuTimer2.getCpuUser())).toString());
        CpuTimer cpuTimer3 = this;
        printStream.println(new StringBuilder().insert(0, ProcCredName.float("Y\u0004YS\u0004S\u0004S\u0004")).append(cpuTimer3.format(cpuTimer3.getCpuSys())).toString());
        printStream.println(new StringBuilder().insert(0, J2CacheSpringRedisAutoConfiguration.float("P0D$@m\u000bm\u000b")).append(CpuPerc.format(this.getCpuUsage())).toString());
    }

    @Override
    public double getCpuUsage() {
        if (this.cpuSampleFirst == 0L || this.cpuSampleLast == 0L) {
            return 0.0;
        }
        double a = System.currentTimeMillis() - this.cpuSampleTime;
        if (a == 0.0) {
            return 0.0;
        }
        double a2 = (double)(this.cpuSampleLast - this.cpuSampleFirst) / a;
        this.cpuSampleFirst = 0L;
        this.cpuSampleLast = 0L;
        this.cpuSampleTime = 0L;
        return a2;
    }

    public void stop() {
        CpuTimer cpuTimer = this;
        cpuTimer.stop(cpuTimer.sigar);
    }

    public ThreadCpu getDiff() {
        CpuTimer cpuTimer = this;
        return cpuTimer.getDiff(cpuTimer.sigar);
    }

    public ThreadCpu getDiff(Sigar sigar) {
        CpuTimer cpuTimer = this;
        long a = cpuTimer.cpu.total;
        long a2 = cpuTimer.cpu.user;
        long a3 = cpuTimer.cpu.sys;
        ThreadCpu a4 = new ThreadCpu();
        try {
            this.cpu.gather(sigar, 0L);
        }
        catch (SigarException a5) {
            throw new IllegalArgumentException(a5.toString());
        }
        a4.total = this.cpu.total - a;
        CpuTimer cpuTimer2 = this;
        CpuTimer cpuTimer3 = this;
        a4.user = cpuTimer3.cpu.user - a2;
        a4.sys = cpuTimer3.cpu.sys - a3;
        cpuTimer2.stamp(cpuTimer2);
        return a4;
    }

    public void add(CpuTimer timer) {
        CpuTimer cpuTimer = this;
        cpuTimer.stamp(timer);
        cpuTimer.cpuTotal += timer.cpuTotal;
        cpuTimer.cpuUser += timer.cpuUser;
        cpuTimer.cpuSys += timer.cpuSys;
        cpuTimer.totalTime += timer.totalTime;
    }
}

