/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import com.jeesite.common.mybatis.mapper.provider.InsertSqlProvider;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.hyperic.sigar.A;
import org.hyperic.sigar.DirStat;
import org.hyperic.sigar.FileAttrs;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarFileNotFoundException;
import org.hyperic.sigar.test.GetPass;

public class FileInfo
extends FileAttrs
implements Serializable {
    public static final int TYPE_BLK = 4;
    private boolean dirStatEnabled;
    private transient Sigar sigar;
    public static final int TYPE_CHR = 3;
    public static final int MODE_WREAD = 4;
    private static final long serialVersionUID = 607239L;
    public static final int MODE_GREAD = 64;
    public static final int TYPE_PIPE = 5;
    public static final int TYPE_UNKFILE = 8;
    public static final int MODE_WEXECUTE = 1;
    private DirStat stat;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(InsertSqlProvider.float("S.SCz\u0007>+VYs\u000e"));
    public static final int MODE_UREAD = 1024;
    public static final int TYPE_DIR = 2;
    public static final int MODE_WWRITE = 2;
    String name;
    public static final int MODE_UEXECUTE = 256;
    public static final int TYPE_SOCK = 7;
    private FileInfo oldInfo;
    public static final int TYPE_REG = 1;
    private boolean lstat;
    public static final int MODE_GEXECUTE = 16;
    public static final int MODE_UWRITE = 512;
    public static final int TYPE_LNK = 6;
    public static final int MODE_GWRITE = 32;
    public static final int TYPE_NOFILE = 0;

    /*
     * Enabled aggressive block sorting
     */
    public char getTypeChar() {
        switch (this.type) {
            case 2: {
                return 'd';
            }
            case 3: {
                return 'c';
            }
            case 4: {
                return 'b';
            }
            case 5: {
                return 'p';
            }
            case 6: {
                return 'l';
            }
            case 7: {
                return 's';
            }
        }
        return '-';
    }

    static FileInfo fetchFileInfo(Sigar sigar, String name) throws SigarException {
        return FileInfo.fetchInfo(sigar, name, true);
    }

    public String getName() {
        return this.name;
    }

    public FileInfo getPreviousInfo() {
        return this.oldInfo;
    }

    public void stat() throws SigarException, SigarFileNotFoundException {
        FileInfo fileInfo;
        FileInfo fileInfo2 = this;
        long a = fileInfo2.mtime;
        if (fileInfo2.lstat) {
            FileInfo fileInfo3 = this;
            FileInfo fileInfo4 = this;
            fileInfo = fileInfo4;
            fileInfo3.gatherLink(fileInfo3.sigar, fileInfo4.name);
        } else {
            FileInfo fileInfo5 = this;
            fileInfo = fileInfo5;
            FileInfo fileInfo6 = this;
            fileInfo6.gather(fileInfo5.sigar, fileInfo6.name);
        }
        if (fileInfo.dirStatEnabled && a != this.mtime) {
            FileInfo fileInfo7 = this;
            fileInfo7.stat.gather(fileInfo7.sigar, this.name);
        }
    }

    static FileInfo fetchLinkInfo(Sigar sigar, String name) throws SigarException {
        return FileInfo.fetchInfo(sigar, name, false);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ FileInfo fetchInfo(Sigar sigar, String name, boolean followSymlinks) throws SigarException {
        FileInfo a;
        block3: {
            a = new FileInfo();
            try {
                if (!followSymlinks) break block3;
                a.gather(sigar, name);
                a.lstat = false;
            }
            catch (SigarException sigarException) {
                void a2;
                void v0 = a2;
                v0.setMessage(name + InsertSqlProvider.float("$C") + a2.getMessage());
                throw v0;
            }
        }
        a.gatherLink(sigar, name);
        a.lstat = true;
        FileInfo fileInfo = a;
        fileInfo.sigar = sigar;
        fileInfo.name = name;
        return a;
    }

    public String diff(FileInfo info) {
        FileInfo fileInfo;
        ArrayList<A> a = new ArrayList<A>();
        if (this.getMtime() != info.getMtime()) {
            fileInfo = this;
            FileInfo fileInfo2 = this;
            a.add(new A(fileInfo2, GetPass.float(".\u001b\n\u0002\u0006"), FileInfo.DATE_FORMAT.format(new Date(info.getMtime())), FileInfo.DATE_FORMAT.format(new Date(fileInfo2.getMtime()))));
        } else if (this.getCtime() != info.getCtime()) {
            fileInfo = this;
            FileInfo fileInfo3 = this;
            a.add(new A(fileInfo3, InsertSqlProvider.float(" j\ns\u0006"), FileInfo.DATE_FORMAT.format(new Date(info.getCtime())), FileInfo.DATE_FORMAT.format(new Date(fileInfo3.getCtime()))));
        } else {
            return "";
        }
        if (fileInfo.getPermissions() != info.getPermissions()) {
            FileInfo fileInfo4 = this;
            a.add(new A(fileInfo4, GetPass.float("3\n\u0011\u0002\u0010"), info.getPermissionsString(), fileInfo4.getPermissionsString()));
        }
        if (this.getType() != info.getType()) {
            FileInfo fileInfo5 = this;
            a.add(new A(fileInfo5, "Type", info.getTypeString(), fileInfo5.getTypeString()));
        }
        if (this.getUid() != info.getUid()) {
            a.add(new A(this, InsertSqlProvider.float("6w\u0007"), info.getUid(), this.getUid()));
        }
        if (this.getGid() != info.getGid()) {
            a.add(new A(this, GetPass.float("$\u0006\u0007"), info.getGid(), this.getGid()));
        }
        if (this.getSize() != info.getSize()) {
            a.add(new A(this, InsertSqlProvider.float("M\nd\u0006"), info.getSize(), this.getSize()));
        }
        if (!OperatingSystem.IS_WIN32) {
            if (this.getInode() != info.getInode()) {
                a.add(new A(this, GetPass.float("*\u0001\f\u000b\u0006"), info.getInode(), this.getInode()));
            }
            if (this.getDevice() != info.getDevice()) {
                a.add(new A(this, InsertSqlProvider.float("Z\u0006h\n}\u0006"), info.getDevice(), this.getDevice()));
            }
            if (this.getNlink() != info.getNlink()) {
                a.add(new A(this, GetPass.float("-\u0003\n\u0001\b"), info.getNlink(), this.getNlink()));
            }
        }
        FileInfo fileInfo6 = this;
        StringBuffer a2 = fileInfo6.format(a);
        if (fileInfo6.dirStatEnabled) {
            a2.append(this.diff(info.stat));
        }
        return a2.toString();
    }

    private /* synthetic */ StringBuffer format(ArrayList changes) {
        int a;
        StringBuffer a2 = new StringBuffer();
        if (changes.size() == 0) {
            return a2;
        }
        int a3 = changes.size();
        int n = a = 0;
        while (n < a3) {
            Object e2 = changes.get(a);
            a2.append('{').append(e2).append('}');
            n = ++a;
        }
        return a2;
    }

    public String diff() {
        if (this.oldInfo == null) {
            return "";
        }
        FileInfo fileInfo = this;
        return fileInfo.diff(fileInfo.oldInfo);
    }

    private static native /* synthetic */ String getPermissionsString(long var0);

    public String diff(DirStat stat) {
        DirStat a = this.stat;
        ArrayList<A> a2 = new ArrayList<A>();
        if (a.files != stat.files) {
            a2.add(new A(this, GetPass.float("%\u0006\u000f\n\u0010"), stat.getFiles(), a.getFiles()));
        }
        if (a.subdirs != stat.subdirs) {
            a2.add(new A(this, InsertSqlProvider.float("0k\u0001z\nl\u0010"), stat.getSubdirs(), a.getSubdirs()));
        }
        if (a.symlinks != stat.symlinks) {
            a2.add(new A(this, GetPass.float("<\u001a\u0002\u000f\u0006\r\u0004\u0010"), stat.getSymlinks(), a.getSymlinks()));
        }
        if (a.chrdevs != stat.chrdevs) {
            a2.add(new A(this, InsertSqlProvider.float(" v\u0011z\u0006h\u0010"), stat.getChrdevs(), a.getChrdevs()));
        }
        if (a.blkdevs != stat.blkdevs) {
            a2.add(new A(this, GetPass.float("!\u0003\b\u000b\u0006\u0019\u0010"), stat.getBlkdevs(), a.getBlkdevs()));
        }
        if (a.sockets != stat.sockets) {
            a2.add(new A(this, InsertSqlProvider.float("0q\u0000u\u0006j\u0010"), stat.getSockets(), a.getSockets()));
        }
        if (a.total != stat.total) {
            a2.add(new A(this, GetPass.float("7\u0000\u0017\u000e\u000f"), stat.getTotal(), a.getTotal()));
        }
        return this.format(a2).toString();
    }

    public void enableDirStat(boolean value) {
        this.dirStatEnabled = value;
        if (this.dirStatEnabled) {
            block5: {
                if (this.type != 2) {
                    throw new IllegalArgumentException(new StringBuilder().insert(0, this.name).append(InsertSqlProvider.float("Cw\u0010>\rq\u0017>\u0002>\u0007w\u0011{\u0000j\fl\u001a")).toString());
                }
                if (this.stat != null) break block5;
                this.stat = this.sigar.getDirStat(this.name);
                return;
            }
            try {
                FileInfo fileInfo = this;
                fileInfo.stat.gather(fileInfo.sigar, this.name);
                return;
            }
            catch (SigarException sigarException) {
                // empty catch block
            }
        }
    }

    public String getTypeString() {
        return FileInfo.getTypeString(this.type);
    }

    private static native /* synthetic */ String getTypeString(int var0);

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean changed() throws SigarException, SigarFileNotFoundException {
        return this.modified() || this.ctime != this.oldInfo.ctime;
    }

    public boolean modified() throws SigarException, SigarFileNotFoundException {
        if (this.oldInfo == null) {
            this.oldInfo = new FileInfo();
            if (this.dirStatEnabled) {
                this.oldInfo.stat = new DirStat();
            }
        }
        FileInfo fileInfo = this;
        fileInfo.copyTo(fileInfo.oldInfo);
        if (fileInfo.dirStatEnabled) {
            FileInfo fileInfo2 = this;
            fileInfo2.stat.copyTo(fileInfo2.oldInfo.stat);
        }
        FileInfo fileInfo3 = this;
        fileInfo3.stat();
        return fileInfo3.mtime != this.oldInfo.mtime;
    }

    private static native /* synthetic */ int getMode(long var0);

    public String getPermissionsString() {
        return FileInfo.getPermissionsString(this.permissions);
    }

    native void gatherLink(Sigar var1, String var2) throws SigarException;

    public boolean equals(Object o) {
        return o.equals(this.name);
    }

    public FileInfo() {
        FileInfo fileInfo = this;
        this.dirStatEnabled = false;
        fileInfo.stat = null;
        fileInfo.oldInfo = null;
    }

    public int getMode() {
        return FileInfo.getMode(this.permissions);
    }
}

