/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarFileNotFoundException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class FileWatcher {
    private long lastTime;
    private Set files;
    private Sigar sigar;
    private long interval;

    public void remove(File file) {
        this.remove(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void check() {
        if (this.interval != 0L) {
            long a = System.currentTimeMillis();
            long a2 = a - this.lastTime;
            if (a2 < this.interval) {
                return;
            }
            this.lastTime = a;
        }
        Set set = this.files;
        synchronized (set) {
            Iterator a = this.files.iterator();
            while (a.hasNext()) {
                FileInfo a3 = (FileInfo)a.next();
                try {
                    if (!this.changed(a3)) continue;
                    this.onChange(a3);
                }
                catch (SigarFileNotFoundException a4) {
                    this.onNotFound(a3);
                }
                catch (SigarException a5) {
                    this.onException(a3, a5);
                    continue;
                }
                break;
            }
            return;
        }
    }

    public static String float(Object s) {
        s = (String)s;
        int n = ((String)s).length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = 4 << 4 ^ 1;
        int cfr_ignored_0 = (3 ^ 5) << 4 ^ (2 << 2 ^ 1);
        int n4 = n2;
        int n5 = 5 << 4 ^ (2 << 2 ^ 1);
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(((String)s).charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(((String)s).charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    public long getInterval() {
        return this.interval;
    }

    public abstract void onChange(FileInfo var1);

    public void add(File[] files) throws SigarException {
        int a;
        int n = a = 0;
        while (n < files.length) {
            this.add(files[a++]);
            n = a;
        }
    }

    public FileWatcher(Sigar sigar) {
        FileWatcher fileWatcher = this;
        this.interval = 0L;
        fileWatcher.lastTime = 0L;
        FileWatcher fileWatcher2 = this;
        fileWatcher.files = Collections.synchronizedSet(new HashSet());
        fileWatcher.sigar = sigar;
    }

    protected boolean changed(FileInfo info) throws SigarException, SigarFileNotFoundException {
        return info.changed();
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void clear() {
        this.files.clear();
    }

    public Set getFiles() {
        return this.files;
    }

    public void remove(String file) {
        FileInfo a = new FileInfo();
        a.name = file;
        this.files.remove(a);
    }

    public void onNotFound(FileInfo info) {
    }

    public FileInfo add(File file) throws SigarException {
        return this.add(file.getAbsolutePath());
    }

    public FileInfo add(String file) throws SigarException {
        FileWatcher fileWatcher = this;
        FileInfo a = fileWatcher.sigar.getFileInfo(file);
        fileWatcher.files.add(a);
        return a;
    }

    public void onException(FileInfo info, SigarException e2) {
    }

    public void add(String[] files) throws SigarException {
        int a;
        int n = a = 0;
        while (n < files.length) {
            this.add(files[a++]);
            n = a;
        }
    }
}

