/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import com.jeesite.autoconfigure.core.TransactionAutoConfiguration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hyperic.sigar.FileTail;
import org.hyperic.sigar.FileWatcher;

public class FileWatcherThread
implements Runnable {
    private static FileWatcherThread instance = null;
    private long interval;
    private Set watchers;
    private Thread thread;
    private boolean shouldDie;
    public static final int DEFAULT_INTERVAL = 300000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void check() {
        Set set = this.watchers;
        synchronized (set) {
            Iterator a = this.watchers.iterator();
            while (a.hasNext()) {
                FileWatcher a2 = (FileWatcher)a.next();
                try {
                    a2.check();
                }
                catch (Exception a3) {
                    FileTail.error(new StringBuilder().insert(0, TransactionAutoConfiguration.float("&g\u0016q\u0003l\u0010}\u0016mSl\u000bj\u0016y\u0007`\u001cgI)")).append(a3.getMessage()).toString(), a3);
                    continue;
                }
                break;
            }
            return;
        }
    }

    public synchronized void doStop() {
        if (this.thread == null) {
            return;
        }
        FileWatcherThread fileWatcherThread = this;
        fileWatcherThread.die();
        fileWatcherThread.thread.interrupt();
        this.thread = null;
    }

    public void add(FileWatcher watcher) {
        this.watchers.add(watcher);
    }

    public FileWatcherThread() {
        FileWatcherThread fileWatcherThread = this;
        fileWatcherThread.thread = null;
        fileWatcherThread.shouldDie = false;
        this.interval = 300000L;
        FileWatcherThread fileWatcherThread2 = this;
        fileWatcherThread2.watchers = Collections.synchronizedSet(new HashSet());
    }

    public void die() {
        this.shouldDie = true;
    }

    public static synchronized FileWatcherThread getInstance() {
        if (instance == null) {
            instance = new FileWatcherThread();
        }
        return instance;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public long getInterval() {
        return this.interval;
    }

    @Override
    public void run() {
        FileWatcherThread fileWatcherThread = this;
        while (!fileWatcherThread.shouldDie) {
            this.check();
            try {
                Thread.sleep(this.interval);
                fileWatcherThread = this;
            }
            catch (InterruptedException interruptedException) {
                fileWatcherThread = this;
            }
        }
    }

    public void remove(FileWatcher watcher) {
        this.watchers.remove(watcher);
    }

    public synchronized void doStart() {
        if (this.thread != null) {
            return;
        }
        FileWatcherThread fileWatcherThread = this;
        this.thread = new Thread((Runnable)this, TransactionAutoConfiguration.float("O\u001ae\u0016^\u0012}\u0010a\u0016{'a\u0001l\u0012m"));
        fileWatcherThread.thread.setDaemon(true);
        fileWatcherThread.thread.start();
    }
}

