/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.util.Arrays;
import java.util.Collection;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.NetFlags;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.EventLogTail;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;

public class Ifconfig
extends SigarCommandBase {
    @Override
    protected boolean validateArgs(String[] args) {
        return args.length <= 1;
    }

    @Override
    public String getUsageShort() {
        return EventLogTail.float("&Q\u001cC\u0007F\u0003\u0014\u0001Z\u001cQ\u001aR\tW\r\u0014\u0001Z\u000e[\u001aY\t@\u0001[\u0006");
    }

    @Override
    public Collection getCompletions() {
        String[] a;
        try {
            a = this.proxy.getNetInterfaceList();
        }
        catch (SigarException a2) {
            return super.getCompletions();
        }
        return Arrays.asList(a);
    }

    public Ifconfig() {
    }

    public void output(String name) throws SigarException {
        Ifconfig ifconfig;
        NetInterfaceConfig a = this.sigar.getNetInterfaceConfig(name);
        long a2 = a.getFlags();
        String a3 = "";
        if (!"00:00:00:00:00:00".equals(a.getHwaddr())) {
            a3 = new StringBuilder().insert(0, Mem.float("]\u0000*)\u0019,\u000fh")).append(a.getHwaddr()).toString();
        }
        if (!a.getName().equals(a.getDescription())) {
            this.println(a.getDescription());
        }
        this.println(new StringBuilder().insert(0, a.getName()).append(EventLogTail.float("=$]\u0006_HQ\u0006W\tDR")).append(a.getType()).append(a3).toString());
        String a4 = "";
        if ((a2 & 0x10L) > 0L) {
            a4 = new StringBuilder().insert(0, Mem.float("]h-e\te-r")).append(a.getDestination()).toString();
        }
        String a5 = "";
        if ((a2 & 2L) > 0L) {
            a5 = new StringBuilder().insert(0, EventLogTail.float("\u0014Hv\u000bU\u001b@R")).append(a.getBroadcast()).toString();
        }
        Ifconfig ifconfig2 = this;
        ifconfig2.println(new StringBuilder().insert(0, Mem.float("A\u0014&\u0018<])\u0019,\u000fr")).append(a.getAddress()).append(a4).append(a5).append(EventLogTail.float("H\u0014%U\u001b_R")).append(a.getNetmask()).toString());
        Ifconfig ifconfig3 = this;
        ifconfig2.println(Mem.float("A") + NetFlags.getIfFlagsString(a2) + EventLogTail.float("Hy<aR") + a.getMtu() + Mem.float("h]\u0005\u0018<\u000f!\u001er") + a.getMetric());
        try {
            Ifconfig ifconfig4 = this;
            NetInterfaceStat a6 = ifconfig4.sigar.getNetInterfaceStat(name);
            ifconfig4.println(new StringBuilder().insert(0, EventLogTail.float("=:lHD\tW\u0003Q\u001cGR")).append(a6.getRxPackets()).append(Mem.float("]-\u000f:\u0012:\u000er")).append(a6.getRxErrors()).append(EventLogTail.float("HP\u001a[\u0018D\rPR")).append(a6.getRxDropped()).append(Mem.float("]'\u000b-\u000f:\b&\u000er")).append(a6.getRxOverruns()).append(EventLogTail.float("HR\u001aU\u0005QR")).append(a6.getRxFrame()).toString());
            ifconfig4.println(new StringBuilder().insert(0, Mem.float("t\u001c%h\r)\u001e#\u0018<\u000er")).append(a6.getTxPackets()).append(EventLogTail.float("\u0014\rF\u001a[\u001aGR")).append(a6.getTxErrors()).append(Mem.float("h\u0019:\u00128\r-\u0019r")).append(a6.getTxDropped()).append(EventLogTail.float("\u0014\u0007B\rF\u001aA\u0006GR")).append(a6.getTxOverruns()).append(Mem.float("h\u001e)\u000f:\u0014-\u000fr")).append(a6.getTxCarrier()).toString());
            ifconfig4.println(new StringBuilder().insert(0, EventLogTail.float("=\u000b[\u0004X\u0001G\u0001[\u0006GR")).append(a6.getTxCollisions()).toString());
            NetInterfaceStat netInterfaceStat = a6;
            long a7 = netInterfaceStat.getRxBytes();
            long a8 = netInterfaceStat.getTxBytes();
            ifconfig4.println(new StringBuilder().insert(0, Mem.float("t\u001a%h\u001f1\t-\u000er")).append(a7).append(EventLogTail.float("\u0014@")).append(Sigar.formatSize(a7)).append(Mem.float("Th]\u001c%h\u001f1\t-\u000er")).append(a8).append(EventLogTail.float("\u0014@")).append(Sigar.formatSize(a8)).append(Mem.float("a")).toString());
            ifconfig = this;
        }
        catch (SigarException a6) {
            ifconfig = this;
        }
        ifconfig.println("");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void output(String[] args) throws SigarException {
        int a;
        String[] a2 = args.length == 1 ? args : this.proxy.getNetInterfaceList();
        int n = a = 0;
        while (n < a2.length) {
            try {
                this.output(a2[a]);
            }
            catch (SigarException sigarException) {
                void a3;
                this.println(a2[a] + EventLogTail.float("a") + a3.getMessage());
            }
            n = ++a;
        }
    }

    @Override
    public String getSyntaxArgs() {
        return Mem.float("\u0013\u0014&\t-\u000f.\u001c+\u0018\u0015");
    }

    public static void main(String[] args) throws Exception {
        new Ifconfig().processCommand(args);
    }

    public Ifconfig(Shell shell) {
        super(shell);
    }
}

