/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.util.ArrayList;
import org.hyperic.sigar.DiskUsage;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemMap;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ThreadCpu;
import org.hyperic.sigar.cmd.EventLogTail;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.shell.FileCompleter;
import org.hyperic.sigar.shell.ShellBase;
import org.hyperic.sigar.util.GetlineCompleter;

public class Iostat
extends SigarCommandBase {
    private GetlineCompleter completer;
    private static final String OUTPUT_FORMAT = "%-15s %-15s %10s %10s %7s %7s %5s %5s";
    private static final String[] HEADER;

    @Override
    public GetlineCompleter getCompleter() {
        return this.completer;
    }

    @Override
    public String getUsageShort() {
        return EventLogTail.float("f\rD\u0007F\u001c\u0014\u000e]\u0004Q\u001bM\u001b@\rYHP\u0001G\u0003\u0014\u0001\u001b\u0007");
    }

    public void outputDisk(String name) throws SigarException {
        Iostat iostat;
        DiskUsage diskUsage;
        DiskUsage diskUsage2;
        Iostat iostat2 = this;
        DiskUsage a = iostat2.sigar.getDiskUsage(name);
        ArrayList<String> a2 = new ArrayList<String>();
        iostat2.printHeader();
        a2.add(name);
        a2.add(ThreadCpu.float("Y"));
        a2.add(String.valueOf(a.getReads()));
        a2.add(String.valueOf(a.getWrites()));
        if (a.getReadBytes() == -1L) {
            diskUsage2 = a;
            a2.add(EventLogTail.float("E"));
            a2.add(ThreadCpu.float("Y"));
        } else {
            a2.add(Sigar.formatSize(a.getReadBytes()));
            a2.add(Sigar.formatSize(a.getWriteBytes()));
            diskUsage2 = a;
        }
        if (diskUsage2.getQueue() == -1.0) {
            diskUsage = a;
            a2.add(EventLogTail.float("E"));
        } else {
            a2.add(this.svctm(a.getQueue()));
            diskUsage = a;
        }
        ArrayList<String> arrayList = a2;
        if (diskUsage.getServiceTime() == -1.0) {
            arrayList.add(ThreadCpu.float("Y"));
            iostat = this;
        } else {
            arrayList.add(this.svctm(a.getServiceTime()));
            iostat = this;
        }
        iostat.printf(a2);
    }

    public void output(FileSystem fs) throws SigarException {
        Iostat iostat;
        FileSystemUsage fileSystemUsage;
        FileSystemUsage fileSystemUsage2;
        FileSystemUsage a = this.sigar.getFileSystemUsage(fs.getDirName());
        ArrayList<String> a2 = new ArrayList<String>();
        a2.add(fs.getDevName());
        a2.add(fs.getDirName());
        a2.add(String.valueOf(a.getDiskReads()));
        a2.add(String.valueOf(a.getDiskWrites()));
        if (a.getDiskReadBytes() == -1L) {
            fileSystemUsage2 = a;
            a2.add(EventLogTail.float("E"));
            a2.add(ThreadCpu.float("Y"));
        } else {
            a2.add(Sigar.formatSize(a.getDiskReadBytes()));
            a2.add(Sigar.formatSize(a.getDiskWriteBytes()));
            fileSystemUsage2 = a;
        }
        if (fileSystemUsage2.getDiskQueue() == -1.0) {
            fileSystemUsage = a;
            a2.add(EventLogTail.float("E"));
        } else {
            a2.add(this.svctm(a.getDiskQueue()));
            fileSystemUsage = a;
        }
        ArrayList<String> arrayList = a2;
        if (fileSystemUsage.getDiskServiceTime() == -1.0) {
            arrayList.add(ThreadCpu.float("Y"));
            iostat = this;
        } else {
            arrayList.add(this.svctm(a.getDiskServiceTime()));
            iostat = this;
        }
        iostat.printf(a2);
    }

    /*
     * WARNING - void declaration
     */
    public Iostat(Shell shell) {
        void shell2;
        Iostat iostat = this;
        super((Shell)shell2);
        iostat.setOutputFormat(OUTPUT_FORMAT);
        Iostat iostat2 = this;
        iostat.completer = new FileCompleter((ShellBase)shell2);
    }

    public Iostat() {
        Iostat iostat = this;
        iostat.setOutputFormat(OUTPUT_FORMAT);
    }

    @Override
    protected boolean validateArgs(String[] args) {
        return args.length <= 1;
    }

    static {
        String[] stringArray = new String[8];
        stringArray[0] = EventLogTail.float("r\u0001X\rG\u0011G\u001cQ\u0005");
        stringArray[1] = ThreadCpu.float("d\u001b\\\u001a]\u0011MTF\u001a");
        stringArray[2] = EventLogTail.float(":Q\tP\u001b");
        stringArray[3] = ThreadCpu.float("~\u0006@\u0000L\u0007");
        stringArray[4] = EventLogTail.float(":\u0019\nM\u001cQ\u001b");
        stringArray[5] = ThreadCpu.float("#\u0004\u0016P\u0000L\u0007");
        stringArray[6] = EventLogTail.float("9A\rA\r");
        stringArray[7] = ThreadCpu.float("'_\u0017]\u0019");
        HEADER = stringArray;
    }

    public void printHeader() {
        this.printf(HEADER);
    }

    public void outputFileSystem(String arg) throws SigarException {
        String a;
        FileSystemMap a2 = this.proxy.getFileSystemMap();
        FileSystem a3 = a2.getMountPoint(a = FileCompleter.expand(arg));
        if (a3 != null) {
            Iostat iostat = this;
            iostat.printHeader();
            iostat.output(a3);
            return;
        }
        throw new SigarException(new StringBuilder().insert(0, arg).append(EventLogTail.float("\u0014&[HG\u001dW\u0000\u0014\u000e]\u0004QH[\u001a\u0014\f]\u001aQ\u000b@\u0007F\u0011")).toString());
    }

    private /* synthetic */ String svctm(double val) {
        Object[] objectArray = new Object[1];
        objectArray[0] = new Double(val);
        return this.sprintf(ThreadCpu.float("Q\u001aZ\u001b\u0012"), objectArray);
    }

    @Override
    public String getSyntaxArgs() {
        return EventLogTail.float("o\u000e]\u0004Q\u001bM\u001b@\rY5");
    }

    @Override
    public void output(String[] args) throws SigarException {
        int a;
        if (args.length == 1) {
            String a2 = args[0];
            if (a2.indexOf(47) != -1 || a2.indexOf(92) != -1) {
                this.outputFileSystem(a2);
                return;
            }
            this.outputDisk(a2);
            return;
        }
        Iostat iostat = this;
        FileSystem[] a3 = iostat.proxy.getFileSystemList();
        iostat.printHeader();
        int n = a = 0;
        while (n < a3.length) {
            if (a3[a].getType() == 2) {
                this.output(a3[a]);
            }
            n = ++a;
        }
    }

    public static void main(String[] args) throws Exception {
        new Iostat().processCommand(args);
    }
}

