/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import com.jeesite.autoconfigure.core.TransactionAutoConfiguration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.hyperic.sigar.NetConnection;
import org.hyperic.sigar.NetFlags;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.Tcp;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.cmd.Watch;

public class Netstat
extends SigarCommandBase {
    private static boolean isStat;
    private static boolean isNumeric;
    private static boolean wantPid;
    private static final int RADDR_LEN = 35;
    private static final String[] HEADER;
    private static final int LADDR_LEN = 20;

    public Netstat(Shell shell) {
        super(shell);
    }

    public static void main(String[] args) throws Exception {
        new Netstat().processCommand(args);
    }

    private /* synthetic */ void outputTcpStats() throws SigarException {
        Netstat netstat = this;
        Tcp a = netstat.sigar.getTcp();
        String a2 = TransactionAutoConfiguration.float("S)S)");
        netstat.println(Watch.float("hIhI") + a.getActiveOpens() + TransactionAutoConfiguration.float("Sh\u0010}\u001a\u007f\u0016)\u0010f\u001dg\u0016j\u0007`\u001cg\u0000)\u001cy\u0016g\u001ag\u0014z"));
        this.println(new StringBuilder().insert(0, Watch.float("hIhI")).append(a.getPassiveOpens()).append(TransactionAutoConfiguration.float("Sy\u0012z\u0000`\u0005lSj\u001cg\u001dl\u0010}\u001af\u001d)\u001cy\u0016g\u001ag\u0014z")).toString());
        netstat.println(new StringBuilder().insert(0, Watch.float("hIhI")).append(a.getAttemptFails()).append(TransactionAutoConfiguration.float(")\u0015h\u001ae\u0016mSj\u001cg\u001dl\u0010}\u001af\u001d)\u0012}\u0007l\u001ey\u0007z")).toString());
        netstat.println(new StringBuilder().insert(0, Watch.float("hIhI")).append(a.getEstabResets()).append(TransactionAutoConfiguration.float(")\u0010f\u001dg\u0016j\u0007`\u001cgS{\u0016z\u0016}\u0000)\u0001l\u0010l\u001a\u007f\u0016m")).toString());
        netstat.println(new StringBuilder().insert(0, Watch.float("hIhI")).append(a.getCurrEstab()).append(TransactionAutoConfiguration.float("Sj\u001cg\u001dl\u0010}\u001af\u001dzSl\u0000}\u0012k\u001f`\u0000a\u0016m")).toString());
        netstat.println(new StringBuilder().insert(0, Watch.float("hIhI")).append(a.getInSegs()).append(TransactionAutoConfiguration.float("Sz\u0016n\u001el\u001d}\u0000)\u0001l\u0010l\u001a\u007f\u0016m")).toString());
        netstat.println(new StringBuilder().insert(0, Watch.float("hIhI")).append(a.getOutSegs()).append(TransactionAutoConfiguration.float("Sz\u0016n\u001el\u001d}\u0000)\u0000l\u001dmSf\u0006}")).toString());
        netstat.println(new StringBuilder().insert(0, Watch.float("hIhI")).append(a.getRetransSegs()).append(TransactionAutoConfiguration.float("Sz\u0016n\u001el\u001d}\u0000)\u0001l\u0007{\u0012g\u0000d\u001a}\u0016m")).toString());
        netstat.println(new StringBuilder().insert(0, Watch.float("hIhI")).append(a.getInErrs()).append(TransactionAutoConfiguration.float(")\u0011h\u0017)\u0000l\u0014d\u0016g\u0007zS{\u0016j\u0016`\u0005l\u0017'")).toString());
        netstat.println(new StringBuilder().insert(0, Watch.float("hIhI")).append(a.getOutRsts()).append(TransactionAutoConfiguration.float("S{\u0016z\u0016}\u0000)\u0000l\u001d}")).toString());
    }

    private /* synthetic */ String formatPort(int proto, long port) {
        String a;
        if (port == 0L) {
            return Watch.float("C");
        }
        if (!isNumeric && (a = this.sigar.getNetServicesName(proto, port)) != null) {
            return a;
        }
        return String.valueOf(port);
    }

    @Override
    protected boolean validateArgs(String[] args) {
        return true;
    }

    private /* synthetic */ String formatAddress(int proto, String ip, long portnum, int max) {
        String a;
        int n;
        String a2 = this.formatPort(proto, portnum);
        if (NetFlags.isAnyAddress(ip)) {
            String string = TransactionAutoConfiguration.float("#");
            n = max;
        } else if (isNumeric) {
            a = ip;
            n = max;
        } else {
            try {
                a = InetAddress.getByName(ip).getHostName();
                n = max;
            }
            catch (UnknownHostException a3) {
                a = ip;
                n = max;
            }
        }
        max = n - (a2.length() + 1);
        if (a.length() > max) {
            a = a.substring(0, max);
        }
        return new StringBuilder().insert(0, a).append(Watch.float("S")).append(a2).toString();
    }

    @Override
    public void output(String[] args) throws SigarException {
        int a;
        int a2 = 241;
        if (args.length > 0) {
            a2 = Netstat.getFlags(args, a2);
            if (isStat) {
                this.outputStats(a2);
                return;
            }
        }
        Netstat netstat = this;
        NetConnection[] a3 = netstat.sigar.getNetConnectionList(a2);
        netstat.printf(HEADER);
        int n = a = 0;
        while (n < a3.length) {
            String a4;
            NetConnection a5 = a3[a];
            String a6 = a5.getTypeString();
            String a7 = a5.getType() == 32 ? "" : a5.getStateString();
            ArrayList<String> a8 = new ArrayList<String>();
            a8.add(a6);
            a8.add(this.formatAddress(a5.getType(), a5.getLocalAddress(), a5.getLocalPort(), 20));
            a8.add(this.formatAddress(a5.getType(), a5.getRemoteAddress(), a5.getRemotePort(), 35));
            a8.add(a7);
            Object var9_9 = null;
            if (wantPid && a5.getState() == 10) {
                try {
                    long a9 = this.sigar.getProcPort(a5.getType(), a5.getLocalPort());
                    if (a9 != 0L) {
                        String a10 = this.sigar.getProcState(a9).getName();
                        a4 = a9 + TransactionAutoConfiguration.float("&") + a10;
                    }
                }
                catch (SigarException a9) {
                    // empty catch block
                }
            }
            if (a4 == null) {
                a4 = "";
            }
            a8.add(a4);
            this.printf(a8);
            n = ++a;
        }
    }

    @Override
    public String getUsageShort() {
        return Watch.float("-!\u001a8\u0005)\u0010h\u0007-\u001d?\u0006:\u0002h\n'\u0007&\f+\u001d!\u0006&\u001a");
    }

    public Netstat() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getFlags(String[] args, int flags) {
        int a;
        int a2 = 0;
        isNumeric = false;
        wantPid = false;
        isStat = false;
        int n = a = 0;
        while (true) {
            if (n >= args.length) {
                if (a2 != 0) {
                    flags &= 0xFFFFFF0F;
                    flags |= a2;
                }
                return flags;
            }
            String a3 = args[a];
            int a4 = 0;
            block13: while (true) {
                int n2 = a4;
                block14: while (n2 < a3.length()) {
                    char c = a3.charAt(a4);
                    ++a4;
                    switch (c) {
                        case '-': {
                            continue block13;
                        }
                        case 'l': {
                            flags &= 0xFFFFFFFE;
                            flags |= 2;
                            n2 = a4;
                            continue block14;
                        }
                        case 'a': {
                            flags |= 3;
                            n2 = a4;
                            continue block14;
                        }
                        case 'n': {
                            isNumeric = true;
                            n2 = a4;
                            continue block14;
                        }
                        case 'p': {
                            wantPid = true;
                            n2 = a4;
                            continue block14;
                        }
                        case 's': {
                            isStat = true;
                            n2 = a4;
                            continue block14;
                        }
                        case 't': {
                            a2 |= 0x10;
                            n2 = a4;
                            continue block14;
                        }
                        case 'u': {
                            a2 |= 0x20;
                            n2 = a4;
                            continue block14;
                        }
                        case 'w': {
                            a2 |= 0x40;
                            n2 = a4;
                            continue block14;
                        }
                        case 'x': {
                            a2 |= 0x80;
                            n2 = a4;
                            continue block14;
                        }
                    }
                    System.err.println(TransactionAutoConfiguration.float("\u0006g\u0018g\u001c~\u001d)\u001cy\u0007`\u001cg"));
                    n2 = a4;
                }
                break;
            }
            n = ++a;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void outputStats(int flags) throws SigarException {
        if ((flags & 0x10) != 0) {
            this.println(Watch.float("\u001c\n8S"));
            try {
                this.outputTcpStats();
                return;
            }
            catch (SigarException sigarException) {
                void a;
                this.println(TransactionAutoConfiguration.float("S)S)") + a);
            }
        }
    }

    static {
        String[] stringArray = new String[5];
        stringArray[0] = Watch.float("9:\u0006<\u0006");
        stringArray[1] = TransactionAutoConfiguration.float("E\u001cj\u0012eSH\u0017m\u0001l\u0000z");
        stringArray[2] = Watch.float("/'\u001b-\u0000/\u0007h(,\r:\f;\u001a");
        stringArray[3] = TransactionAutoConfiguration.float("Z\u0007h\u0007l");
        stringArray[4] = "";
        HEADER = stringArray;
    }
}

