/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import com.jeesite.autoconfigure.core.CacheAutoConfiguration;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarLoader;
import org.hyperic.sigar.SigarPermissionDeniedException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.SudoFileInputStream;
import org.hyperic.sigar.cmd.CpuInfo;
import org.hyperic.sigar.cmd.Df;
import org.hyperic.sigar.cmd.Du;
import org.hyperic.sigar.cmd.FileVersionInfo;
import org.hyperic.sigar.cmd.Free;
import org.hyperic.sigar.cmd.Ifconfig;
import org.hyperic.sigar.cmd.Iostat;
import org.hyperic.sigar.cmd.Kill;
import org.hyperic.sigar.cmd.Ls;
import org.hyperic.sigar.cmd.MultiPs;
import org.hyperic.sigar.cmd.NetInfo;
import org.hyperic.sigar.cmd.Netstat;
import org.hyperic.sigar.cmd.Nfsstat;
import org.hyperic.sigar.cmd.Pidof;
import org.hyperic.sigar.cmd.ProcFileInfo;
import org.hyperic.sigar.cmd.ProcInfo;
import org.hyperic.sigar.cmd.ProcModuleInfo;
import org.hyperic.sigar.cmd.Ps;
import org.hyperic.sigar.cmd.Route;
import org.hyperic.sigar.cmd.ShowArgs;
import org.hyperic.sigar.cmd.ShowEnv;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.cmd.SysInfo;
import org.hyperic.sigar.cmd.Time;
import org.hyperic.sigar.cmd.Ulimit;
import org.hyperic.sigar.cmd.Uptime;
import org.hyperic.sigar.cmd.Version;
import org.hyperic.sigar.cmd.Who;
import org.hyperic.sigar.cmd.Win32Service;
import org.hyperic.sigar.ptql.ProcessFinder;
import org.hyperic.sigar.shell.ShellBase;
import org.hyperic.sigar.shell.ShellCommandExecException;
import org.hyperic.sigar.shell.ShellCommandHandler;
import org.hyperic.sigar.shell.ShellCommandInitException;
import org.hyperic.sigar.shell.ShellCommandUsageException;
import org.hyperic.sigar.util.Getline;

public class Shell
extends ShellBase {
    private Sigar sigar;
    private SigarProxy proxy;
    private boolean isInteractive;
    private long[] foundPids;
    public static final String RCFILE_NAME = ".sigar_shellrc";
    private static final String CLEAR_SCREEN = "\u001b[2J";

    public void registerCommands() throws ShellCommandInitException {
        Shell shell = this;
        Shell shell2 = this;
        Shell shell3 = this;
        Shell shell4 = this;
        Shell shell5 = this;
        Shell shell6 = this;
        Shell shell7 = this;
        Shell shell8 = this;
        Shell shell9 = this;
        Shell shell10 = this;
        Shell shell11 = this;
        Shell shell12 = this;
        Shell shell13 = this;
        shell13.registerCommandHandler(SudoFileInputStream.float(")x"), new Df(this));
        shell13.registerCommandHandler(CacheAutoConfiguration.float("YV"), new Du(this));
        shell12.registerCommandHandler(SudoFileInputStream.float("!m"), new Ls(this));
        shell12.registerCommandHandler(CacheAutoConfiguration.float("TLNW\\W"), new Iostat(this));
        shell11.registerCommandHandler(SudoFileInputStream.float("+l({"), new Free(this));
        shell11.registerCommandHandler(CacheAutoConfiguration.float("S\\QZP"), new ShowArgs(this));
        shell10.registerCommandHandler(SudoFileInputStream.float("={#h"), new ShowEnv(this));
        shell10.registerCommandHandler(CacheAutoConfiguration.float("S[JQF"), new ProcFileInfo(this));
        shell9.registerCommandHandler(SudoFileInputStream.float("=s\"z8r(m"), new ProcModuleInfo(this));
        shell9.registerCommandHandler(CacheAutoConfiguration.float("STM[L"), new ProcInfo(this));
        shell8.registerCommandHandler(SudoFileInputStream.float("}=k$p+q"), new CpuInfo(this));
        shell8.registerCommandHandler(CacheAutoConfiguration.float("TE^LSETD"), new Ifconfig(this));
        shell7.registerCommandHandler(SudoFileInputStream.float("8n9w {"), new Uptime(this));
        shell7.registerCommandHandler(CacheAutoConfiguration.float("MP"), new Ps(this));
        shell6.registerCommandHandler(SudoFileInputStream.float("n$z\"x"), new Pidof(this));
        shell6.registerCommandHandler(CacheAutoConfiguration.float("VJQO"), new Kill(this));
        shell5.registerCommandHandler(SudoFileInputStream.float("p(j>j,j"), new Netstat(this));
        shell5.registerCommandHandler(CacheAutoConfiguration.float("MXWTM[L"), new NetInfo(this));
        shell4.registerCommandHandler(SudoFileInputStream.float("p+m>j,j"), new Nfsstat(this));
        shell4.registerCommandHandler(CacheAutoConfiguration.float("QRVIF"), new Route(this));
        shell3.registerCommandHandler(SudoFileInputStream.float("h(l>w\"p"), new Version(this));
        shell3.registerCommandHandler(CacheAutoConfiguration.float("NMP"), new MultiPs(this));
        shell2.registerCommandHandler(SudoFileInputStream.float("m4m$p+q"), new SysInfo(this));
        shell2.registerCommandHandler(CacheAutoConfiguration.float("IJPF"), new Time(this));
        shell.registerCommandHandler(SudoFileInputStream.float("8r$s$j"), new Ulimit(this));
        shell.registerCommandHandler(CacheAutoConfiguration.float("TUL"), new Who(this));
        if (SigarLoader.IS_WIN32) {
            Shell shell14 = this;
            shell14.registerCommandHandler(SudoFileInputStream.float("m(l;w.{"), new Win32Service(this));
            shell14.registerCommandHandler(CacheAutoConfiguration.float("[UXQNJRM"), new FileVersionInfo(this));
        }
        try {
            this.registerCommandHandler(SudoFileInputStream.float("9{>j"), "org.hyperic.sigar.test.SigarTestRunner");
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public void processCommand(ShellCommandHandler handler, String[] args) throws ShellCommandUsageException, ShellCommandExecException {
        try {
            super.processCommand(handler, args);
            if (handler instanceof SigarCommandBase) {
                ((SigarCommandBase)handler).flush();
            }
            return;
        }
        finally {
            SigarProxyCache.clear(this.proxy);
        }
    }

    public Sigar getSigar() {
        return this.sigar;
    }

    public long[] findPids(String query) throws SigarException {
        String[] stringArray = new String[1];
        stringArray[0] = query;
        return this.findPids(stringArray);
    }

    @Override
    public void shutdown() {
        Shell shell;
        this.sigar.close();
        try {
            Class.forName("org.hyperic.sigar.test.SigarTestCase").getMethod(CacheAutoConfiguration.float("^ORPXpTD\\Q"), new Class[0]).invoke(null, new Object[0]);
            shell = this;
        }
        catch (ClassNotFoundException classNotFoundException) {
            shell = this;
        }
        catch (Exception a) {
            shell = this;
            a.printStackTrace();
        }
        catch (NoClassDefFoundError a) {
            shell = this;
        }
        super.shutdown();
    }

    public String getUserDeniedMessage(long pid) {
        return SigarPermissionDeniedException.getUserDeniedMessage(this.proxy, pid);
    }

    public void setInteractive(boolean value) {
        this.isInteractive = value;
    }

    public SigarProxy getSigarProxy() {
        return this.proxy;
    }

    public static void clearScreen() {
        System.out.print(CLEAR_SCREEN);
    }

    public long[] findPids(String[] args) throws SigarException {
        if (args.length == 1 && args[0].equals(SudoFileInputStream.float("3"))) {
            return this.foundPids;
        }
        Shell shell = this;
        shell.foundPids = Shell.getPids(shell.proxy, args);
        return shell.foundPids;
    }

    public void readCommandFile(String dir) {
        try {
            File a = new File(dir, RCFILE_NAME);
            Shell shell = this;
            shell.readRCFile(a, false);
            if (shell.isInteractive && Getline.isTTY()) {
                this.out.println(new StringBuilder().insert(0, CacheAutoConfiguration.float("qL\\GXG\u001dQ^\u0003[JQF\u0007\u0003")).append(a).toString());
                return;
            }
        }
        catch (IOException a) {
            // empty catch block
        }
    }

    public boolean isInteractive() {
        return this.isInteractive;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long[] getPids(SigarProxy sigar, String[] args) throws SigarException {
        int a;
        switch (args.length) {
            case 0: {
                long[] lArray = new long[1];
                lArray[0] = sigar.getPid();
                long[] a2 = lArray;
                return lArray;
            }
            case 1: {
                if (args[0].indexOf(SudoFileInputStream.float("#")) > 0) {
                    return ProcessFinder.find(sigar, args[0]);
                }
                if (args[0].equals(CacheAutoConfiguration.float("\u0019\u0007"))) {
                    long[] lArray = new long[1];
                    lArray[0] = sigar.getPid();
                    long[] a3 = lArray;
                    return lArray;
                }
                long[] lArray = new long[1];
                lArray[0] = Long.parseLong(args[0]);
                long[] a4 = lArray;
                return lArray;
            }
        }
        long[] a5 = new long[args.length];
        int n = a = 0;
        while (n < args.length) {
            int n2 = a++;
            a5[n2] = Long.parseLong(args[n2]);
            n = a;
        }
        return a5;
    }

    private /* synthetic */ void registerCommandHandler(String name, String className) throws Exception {
        Class[] classArray = new Class[1];
        classArray[0] = this.getClass();
        Constructor<?> a = Class.forName(className).getConstructor(classArray);
        Object[] objectArray = new Object[1];
        objectArray[0] = this;
        this.registerCommandHandler(name, (ShellCommandHandler)a.newInstance(objectArray));
    }

    public static void main(String[] args) {
        Shell a = new Shell();
        try {
            Shell shell;
            if (args.length == 0) {
                a.isInteractive = true;
            }
            Shell shell2 = a;
            Shell shell3 = a;
            Shell shell4 = a;
            shell4.init("sigar", System.out, System.err);
            shell4.registerCommands();
            shell3.readCommandFile(System.getProperty(SudoFileInputStream.float("k>{?0%q {")));
            shell2.readCommandFile(".");
            shell3.readCommandFile(SigarLoader.getLocation());
            if (shell2.isInteractive) {
                Shell shell5 = a;
                shell = shell5;
                shell5.initHistory();
                Getline.setCompleter(shell5);
                shell5.run();
            } else {
                a.handleCommand(null, args);
                shell = a;
            }
            shell.shutdown();
            return;
        }
        catch (Exception a2) {
            System.err.println(new StringBuilder().insert(0, CacheAutoConfiguration.float("hMX[MF^WXG\u001dFE@XSIJRM\u0007\u0003")).append(a2).toString());
            return;
        }
        finally {
            a.shutdown();
        }
    }

    public Shell() {
        Shell shell = this;
        this.sigar = new Sigar();
        this.proxy = SigarProxyCache.newInstance(this.sigar);
        shell.foundPids = new long[0];
        shell.isInteractive = false;
    }
}

