/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.util;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.hyperic.sigar.pager.PageList;
import org.hyperic.sigar.util.GetlineCompleter;

public class Getline {
    private String prompt;
    private BufferedReader in;
    private static final boolean isatty = Getline.isatty();
    private static boolean useNative = !"false".equals(System.getProperty(PageList.float("\u007f\rk\u0005~Jk\u0001x\be\niJb\u0005x\rz\u0001"))) && isatty;

    public String getLine(String prompt, boolean addToHistory) throws IOException, EOFException {
        if (useNative) {
            String a = this.getline(prompt);
            if (addToHistory) {
                this.addToHistory(a);
            }
            return a;
        }
        if (this.in == null) {
            Getline getline = this;
            getline.in = new BufferedReader(new InputStreamReader(System.in));
        }
        System.out.print(prompt);
        return this.in.readLine();
    }

    public static boolean isTTY() {
        return isatty;
    }

    public static native void setCompleter(GetlineCompleter var0);

    public String getLine(String prompt) throws IOException, EOFException {
        return this.getLine(prompt, true);
    }

    private native /* synthetic */ void histinit(String var1);

    private native /* synthetic */ String getline(String var1) throws IOException, EOFException;

    public native void reset();

    public Getline() {
        Getline getline = this;
        getline.in = null;
        getline.prompt = "> ";
    }

    public native void redraw();

    public String getLine() throws IOException, EOFException {
        Getline getline = this;
        return getline.getLine(getline.prompt, true);
    }

    private native /* synthetic */ void histadd(String var1);

    public void addToHistory(String line) {
        if (line == null || line.length() == 0) {
            return;
        }
        if (useNative) {
            this.histadd(line);
        }
    }

    public Getline(String string) {
        Getline getline = this;
        this.in = null;
        getline.prompt = "> ";
        getline.prompt = string;
    }

    /*
     * WARNING - void declaration
     */
    public void initHistoryFile(File file) throws IOException {
        if (useNative) {
            void file2;
            this.histinit(file2.getCanonicalPath());
        }
    }

    private static native /* synthetic */ boolean isatty();
}

