/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.vmware;

import org.hyperic.sigar.DirUsage;
import org.hyperic.sigar.pager.PageFetcher;
import org.hyperic.sigar.vmware.ConnectParams;
import org.hyperic.sigar.vmware.VMwareException;
import org.hyperic.sigar.vmware.VMwareObject;

public class VM
extends VMwareObject {
    public static final String ESX = "ESX";
    public static final int PRODINFO_BUILD = 3;
    public static final int EXECUTION_STATE_OFF = 2;
    public static final int PRODUCT_SERVER = 4;
    public static final int POWEROP_MODE_TRYSOFT = 3;
    public static final String[] EXECUTION_STATES;
    public static final int PRODINFO_PRODUCT = 1;
    public static final int EXECUTION_STATE_STUCK = 4;
    public static final String[] PRODUCTS;
    public static final int PRODUCT_UNKNOWN = 5;
    private static final int POWEROP_MODE_DEFAULT = 3;
    public static final int PERM_WRITE = 2;
    public static final int PLATFORM_WINDOWS = 1;
    public static final int PRODINFO_VERSION_MINOR = 5;
    public static final int EXECUTION_STATE_SUSPENDED = 3;
    public static final int PLATFORM_LINUX = 2;
    public static final int PRODUCT_ESX = 3;
    public static final int PERM_EXECUTE = 1;
    public static final String[] PLATFORMS;
    public static final int POWEROP_MODE_SOFT = 2;
    public static final int PRODUCT_WS = 1;
    public static final int EXECUTION_STATE_UNKNOWN = 5;
    public static final int PERM_READ = 4;
    public static final String GSX = "GSX";
    public static final int PRODINFO_VERSION_REVISION = 6;
    public static final int PLATFORM_UNKNOWN = 4;
    public static final int PLATFORM_VMNIX = 3;
    public static final int PRODUCT_GSX = 2;
    public static final int POWEROP_MODE_HARD = 1;
    public static final int EXECUTION_STATE_ON = 1;
    public static final int PRODINFO_PLATFORM = 2;
    public static final int PRODINFO_VERSION_MAJOR = 4;
    public static final String SERVER = "Server";

    private /* synthetic */ boolean checkPermission(int perm) {
        block3: {
            try {
                if ((this.getPermissions() & perm) == 0) break block3;
                return true;
            }
            catch (VMwareException a) {
                return false;
            }
        }
        return false;
    }

    public boolean canExecute() {
        return this.checkPermission(1);
    }

    public void start() throws VMwareException {
        this.start(3);
    }

    private native /* synthetic */ void connect(ConnectParams var1, String var2, int var3) throws VMwareException;

    public boolean isGSX() {
        block3: {
            try {
                if (this.getProductInfo(1) != 2) break block3;
                return true;
            }
            catch (VMwareException a) {
                return false;
            }
        }
        return false;
    }

    private native /* synthetic */ void createNamedSnapshot(String var1, String var2, boolean var3, boolean var4) throws VMwareException;

    public boolean canWrite() {
        return this.checkPermission(2);
    }

    private /* synthetic */ String getConfigEx(String key) {
        try {
            return this.getConfig(key);
        }
        catch (VMwareException a) {
            return null;
        }
    }

    public native String getRunAsUser() throws VMwareException;

    @Override
    native void destroy();

    public void stop() throws VMwareException {
        this.stop(3);
    }

    public void connect(ConnectParams params, String config) throws VMwareException {
        this.connect(params, config, 0);
    }

    private native /* synthetic */ void createDefaultSnapshot() throws VMwareException;

    public native void setGuestInfo(String var1, String var2) throws VMwareException;

    public boolean isSuspended() {
        return this.isState(3);
    }

    public void suspend() throws VMwareException {
        this.suspend(3);
    }

    public native void disconnect();

    public boolean isOn() {
        return this.isState(1);
    }

    public native void start(int var1) throws VMwareException;

    public native int getUptime() throws VMwareException;

    private /* synthetic */ boolean isState(int state) {
        block3: {
            try {
                if (this.getExecutionState() != state) break block3;
                return true;
            }
            catch (VMwareException a) {
                return false;
            }
        }
        return false;
    }

    private native /* synthetic */ void create();

    public native int getRemoteConnections() throws VMwareException;

    public void resume() throws VMwareException {
        this.resume(3);
    }

    public native int getHeartbeat() throws VMwareException;

    public String getFullVersion() throws VMwareException {
        return new StringBuilder().insert(0, this.getVersion()).append(".").append(this.getProductInfo(6)).append(".").append(this.getProductInfo(3)).toString();
    }

    public String getDisplayName() {
        return this.getConfigEx(PageFetcher.float("\t\\\u001eE\u0001T\u0014{\fX\b"));
    }

    public native int getToolsLastActive() throws VMwareException;

    public VM() {
        VM vM = this;
        vM.create();
    }

    public String getVersion() throws VMwareException {
        return this.getProductInfo(4) + "." + this.getProductInfo(5);
    }

    public native String getResource(String var1) throws VMwareException;

    public native String getGuestInfo(String var1) throws VMwareException;

    public native long getPid() throws VMwareException;

    public native boolean hasSnapshot() throws VMwareException;

    public native int getId() throws VMwareException;

    public String getProductName() {
        try {
            int a = this.getProductInfo(1);
            return new StringBuilder().insert(0, PRODUCTS[a]).append(DirUsage.float("6")).append(this.getVersion()).toString();
        }
        catch (VMwareException a) {
            return null;
        }
    }

    public void reset() throws VMwareException {
        this.reset(3);
    }

    public String getProductPlatform() {
        try {
            int a = this.getProductInfo(2);
            return PLATFORMS[a];
        }
        catch (VMwareException a) {
            return null;
        }
    }

    static {
        String[] stringArray = new String[6];
        stringArray[0] = PageFetcher.float("${;t!|)");
        stringArray[1] = DirUsage.float("EX");
        stringArray[2] = PageFetcher.float("\"s+");
        stringArray[3] = DirUsage.float("E_EZSDROR");
        stringArray[4] = PageFetcher.float(">a8v&");
        stringArray[5] = DirUsage.float("CD]DY]X");
        EXECUTION_STATES = stringArray;
        String[] stringArray2 = new String[6];
        stringArray2[0] = PageFetcher.float("${;t!|)");
        stringArray2[1] = DirUsage.float("Aedae~w~\u007fex");
        stringArray2[2] = GSX;
        stringArray2[3] = ESX;
        stringArray2[4] = SERVER;
        stringArray2[5] = PageFetcher.float("8{&{\"b#");
        PRODUCTS = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = DirUsage.float("_D@KZCR");
        stringArray3[1] = PageFetcher.float(":\\\u0003Q\u0002B\u001e");
        stringArray3[2] = "Linux";
        stringArray3[3] = DirUsage.float("@gXcn");
        stringArray3[4] = PageFetcher.float("8{&{\"b#");
        PLATFORMS = stringArray3;
    }

    public native void reset(int var1) throws VMwareException;

    public boolean isESX() {
        block3: {
            try {
                if (this.getProductInfo(1) != 3) break block3;
                return true;
            }
            catch (VMwareException a) {
                return false;
            }
        }
        return false;
    }

    public boolean canRead() {
        return this.checkPermission(4);
    }

    public void resume(int mode) throws VMwareException {
        int a = this.getExecutionState();
        if (a != 3) {
            throw new VMwareException(new StringBuilder().insert(0, DirUsage.float("@G6ybkbo6ce*xeb*e\u007fezsdror06")).append(EXECUTION_STATES[a]).toString());
        }
        this.start(mode);
    }

    public String getMemSize() {
        return this.getConfigEx(PageFetcher.float("\u0000P\u0000F\u0004O\b"));
    }

    public native void suspend(int var1) throws VMwareException;

    public String getGuestOS() {
        return this.getConfigEx(DirUsage.float("q\u007fsybEE"));
    }

    public void connect(ConnectParams params, String config, boolean mks) throws VMwareException {
        this.connect(params, config, mks ? 1 : 0);
    }

    public native void deviceConnect(String var1) throws VMwareException;

    public boolean isStuck() {
        return this.isState(4);
    }

    public String getPermissionsString() {
        char[] cArray = new char[3];
        cArray[0] = 45;
        cArray[1] = 45;
        cArray[2] = 45;
        char[] a = cArray;
        try {
            int a2 = this.getPermissions();
            if ((a2 & 4) != 0) {
                a[0] = 114;
            }
            if ((a2 & 2) != 0) {
                a[1] = 119;
            }
            if ((a2 & 1) != 0) {
                a[2] = 120;
            }
        }
        catch (VMwareException a2) {
            // empty catch block
        }
        return new String(a);
    }

    public native void saveScreenshot(String var1) throws VMwareException;

    public native boolean isConnected();

    public native void revertToSnapshot() throws VMwareException;

    public native String getConfig(String var1) throws VMwareException;

    public native int getProductInfo(int var1) throws VMwareException;

    public native void deviceDisconnect(String var1) throws VMwareException;

    public native int getPermissions() throws VMwareException;

    public boolean isOff() {
        return this.isState(2);
    }

    public native void removeAllSnapshots() throws VMwareException;

    public native void stop(int var1) throws VMwareException;

    public native boolean deviceIsConnected(String var1) throws VMwareException;

    public void createSnapshot(String name, String description, boolean quiesce, boolean memory) throws VMwareException {
        if (this.isESX()) {
            this.createNamedSnapshot(name, description, quiesce, memory);
            return;
        }
        this.createDefaultSnapshot();
    }

    public native int getExecutionState() throws VMwareException;
}

