/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.vmware;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.hyperic.jni.ArchName;
import org.hyperic.sigar.SigarLoader;
import org.hyperic.sigar.SudoFileInputStream;
import org.hyperic.sigar.vmware.VMwareObject;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Win32Exception;

public class VMControlLibrary {
    private static final boolean IS64 = ArchName.is64();
    private static final String VMCONTROL;
    private static final String VMCONTROL_OBJ;
    private static final String GCC;
    public static final String PROP_VMCONTROL_SHLIB = "vmcontrol.shlib";
    private static boolean isDebug;
    private static final String VMCONTROL_SO;
    public static final String REGISTRY_ROOT = "SOFTWARE\\VMware, Inc.";
    private static final String VMCONTROL_DLL;
    private static final String TAR;
    private static final String VMCONTROL_TAR;
    private static final String VMWARE_LIB;
    private static final String LIBCRYPTO;
    private static final String LIBSSL;

    private static /* synthetic */ String getProperty(String key, String defval) {
        return System.getProperty(new StringBuilder().insert(0, SudoFileInputStream.float(";s.q#j?q!0")).append(key).toString(), defval);
    }

    private static /* synthetic */ File getLib(String name) {
        File a = new File(VMWARE_LIB, new StringBuilder().insert(0, SudoFileInputStream.float("!w/1")).append(name).toString());
        if (a.isDirectory()) {
            a = new File(a, name);
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ void linkWin32() {
        ArrayList<String> arrayList;
        ArrayList<String> a;
        block22: {
            block21: {
                a = new ArrayList<String>();
                RegistryKey a2 = null;
                try {
                    a2 = RegistryKey.LocalMachine.openSubKey(REGISTRY_ROOT);
                    String[] a3 = a2.getSubKeyNames();
                    for (int a4 = 0; a4 < a3.length; ++a4) {
                        RegistryKey registryKey;
                        String a5;
                        RegistryKey a6;
                        String a7;
                        block20: {
                            block19: {
                                a7 = a3[a4];
                                if (!a7.startsWith(SudoFileInputStream.float("H\u0000i,l(>"))) continue;
                                a6 = null;
                                a6 = a2.openSubKey(a7);
                                a5 = a6.getStringValue(SudoFileInputStream.float("W#m9\u007f!r\u001d\u007f9v"));
                                if (a5 != null) break block19;
                                if (a6 == null) continue;
                                a6.close();
                                continue;
                            }
                            a5 = a5.trim();
                            if (a5.length() != 0) break block20;
                            if (a6 == null) continue;
                            a6.close();
                            continue;
                        }
                        try {
                            File a8 = new File(new StringBuilder().insert(0, a5).append(VMCONTROL_DLL).toString());
                            if (a8.exists()) {
                                if (a7.endsWith(SudoFileInputStream.float(">\u001e{?h(l"))) {
                                    registryKey = a6;
                                    a.add(0, a8.getPath());
                                    continue;
                                }
                                if (a7.endsWith(SudoFileInputStream.float("m_\u001dW"))) {
                                    a.add(a8.getPath());
                                }
                            }
                            registryKey = a6;
                            continue;
                        }
                        catch (Win32Exception win32Exception) {
                            continue;
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        finally {
                            if (registryKey != null) {
                                a6.close();
                            }
                        }
                    }
                    if (a2 == null) break block21;
                    arrayList = a;
                    a2.close();
                    break block22;
                }
                catch (Win32Exception win32Exception) {
                    if (a2 == null) break block21;
                    arrayList = a;
                    a2.close();
                    break block22;
                }
                catch (Throwable throwable) {
                    if (a2 != null) {
                        a2.close();
                    }
                    throw throwable;
                }
            }
            arrayList = a;
        }
        if (arrayList.size() != 0) {
            VMControlLibrary.setSharedLibrary((String)a.get(0));
        }
    }

    public static void main(String[] args) throws Exception {
        isDebug = true;
        if (args.length == 0) {
            VMControlLibrary.link();
        } else {
            VMControlLibrary.link(args[0]);
        }
        String a = VMControlLibrary.getSharedLibrary();
        if (a == null) {
            System.out.println(SudoFileInputStream.float("\u0003qmr$|?\u007f?gmx\"k#z"));
            return;
        }
        System.out.println(new StringBuilder().insert(0, SudoFileInputStream.float(";s.q#j?q!0>v!w/#")).append(a).append(SudoFileInputStream.float(">er\"\u007f){)#")).append(VMControlLibrary.isLoaded()).append(SudoFileInputStream.float("7")).toString());
    }

    static {
        VMWARE_LIB = VMControlLibrary.getProperty(SudoFileInputStream.float("!w/0;s:\u007f?{"), VMControlLibrary.getVMwareLib().getPath());
        VMCONTROL_TAR = VMControlLibrary.getProperty(SudoFileInputStream.float("}\"p9l\"rcj,l"), new StringBuilder().insert(0, VMWARE_LIB).append(SudoFileInputStream.float("1={?rb}\"p9l\"rcj,l")).toString());
        VMCONTROL = new StringBuilder().insert(0, SudoFileInputStream.float("h }\"p9l\"r")).append(IS64 ? SudoFileInputStream.float("{*") : "").toString();
        VMCONTROL_DLL = new StringBuilder().insert(0, VMCONTROL).append(SudoFileInputStream.float("r$|cz!r")).toString();
        VMCONTROL_SO = new StringBuilder().insert(0, VMCONTROL).append(SudoFileInputStream.float("0>q")).toString();
        VMCONTROL_OBJ = VMControlLibrary.getProperty(SudoFileInputStream.float("h }\"p9l\"rcq"), new StringBuilder().insert(0, SudoFileInputStream.float("}\"p9l\"r`q#r41")).append(VMCONTROL).append(SudoFileInputStream.float("cq")).toString());
        GCC = VMControlLibrary.getProperty(SudoFileInputStream.float("|$pcy.}"), SudoFileInputStream.float("bk>lb|$pby.}"));
        TAR = VMControlLibrary.getProperty(SudoFileInputStream.float("|$pcj,l"), SudoFileInputStream.float("b|$pbj,l"));
        LIBSSL = VMControlLibrary.getProperty(SudoFileInputStream.float("!w/m>r"), SudoFileInputStream.float("r$|>m!0>qc.c'c)"));
        LIBCRYPTO = VMControlLibrary.getProperty(SudoFileInputStream.float("r$|.l4n9q"), SudoFileInputStream.float("!w/}?g=j\"0>qc.c'c)"));
        isDebug = false;
    }

    public static void link(String name) throws IOException {
        String[] stringArray;
        String[] a;
        if (SigarLoader.IS_WIN32) {
            VMControlLibrary.linkWin32();
            return;
        }
        File a2 = new File(name).getAbsoluteFile();
        if (a2.isDirectory()) {
            a2 = new File(a2, VMCONTROL_SO);
        }
        if (a2.exists()) {
            VMControlLibrary.setSharedLibrary(a2.getPath());
            return;
        }
        if (!new File(VMCONTROL_TAR).exists()) {
            return;
        }
        File a3 = a2.getParentFile();
        if (!a3.isDirectory() || !a3.canWrite()) {
            throw new IOException(new StringBuilder().insert(0, SudoFileInputStream.float("],p#q9>:l$j(>9qw>")).append(a3).toString());
        }
        File a4 = new File(a3, VMCONTROL_OBJ);
        if (!a4.exists()) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = TAR;
            stringArray2[1] = SudoFileInputStream.float("35x");
            stringArray2[2] = VMCONTROL_TAR;
            stringArray2[3] = SudoFileInputStream.float("`]");
            stringArray2[4] = a3.toString();
            stringArray2[5] = VMCONTROL_OBJ;
            a = stringArray2;
            VMControlLibrary.exec(stringArray2);
        }
        a = new ArrayList();
        a.add(GCC);
        a.add(SudoFileInputStream.float("3>v,l(z"));
        a.add(SudoFileInputStream.float("`q"));
        a.add(a2.getPath());
        a.add(a4.getPath());
        if (IS64) {
            a.add(SudoFileInputStream.float("`r.l4n9q"));
            stringArray = a;
            a.add(SudoFileInputStream.float("3!m>r"));
        } else {
            File a5 = VMControlLibrary.getLib(VMControlLibrary.LIBSSL);
            File a6 = VMControlLibrary.getLib(VMControlLibrary.LIBCRYPTO);
            if (!a5.exists()) {
                throw new FileNotFoundException(a5.toString());
            }
            if (!new File(a5.getParent(), SudoFileInputStream.float("r$|.0>qc(")).exists()) {
                String a7 = SudoFileInputStream.float("`I!2`l=\u007f9v");
                File file = a5;
                a.add(SudoFileInputStream.float("`I!2`l=\u007f9v"));
                a.add(file.getParent());
                if (!file.getParent().equals(a6.getParent())) {
                    a.add(SudoFileInputStream.float("`I!2`l=\u007f9v"));
                    a.add(a6.getParent());
                }
            }
            stringArray = a;
            a.add(a5.getPath());
            a.add(a6.getPath());
        }
        VMControlLibrary.exec(stringArray.toArray(new String[0]));
        VMControlLibrary.setSharedLibrary(a2.getPath());
    }

    private static /* synthetic */ File getVMwareLib() {
        File a;
        int a2;
        String[] stringArray = new String[2];
        stringArray[0] = SudoFileInputStream.float("18m?1!w/1;s:\u007f?{");
        stringArray[1] = SudoFileInputStream.float("18m?1!q.\u007f!1!w/1;s:\u007f?{");
        String[] a3 = stringArray;
        int n = a2 = 0;
        while (n < a3.length) {
            a = new File(a3[a2]);
            if (a.exists()) {
                return a;
            }
            n = ++a2;
        }
        int n2 = a2 = 0;
        while (n2 < a3.length) {
            a = new File(new StringBuilder().insert(0, a3[a2]).append(SudoFileInputStream.float("`\u007f=w")).toString());
            if (a.exists()) {
                return a;
            }
            n2 = ++a2;
        }
        return new File(a3[0]);
    }

    public static void link() throws IOException {
        VMControlLibrary.link(VMCONTROL_SO);
    }

    public static String getSharedLibrary() {
        return System.getProperty(PROP_VMCONTROL_SHLIB);
    }

    private static /* synthetic */ void exec(String[] args) throws IOException {
        Process a = Runtime.getRuntime().exec(args);
        try {
            int a2 = a.waitFor();
            if (a2 != 0) {
                String a3 = new StringBuilder().insert(0, SudoFileInputStream.float("{5{.6")).append(VMControlLibrary.toString(args)).append(SudoFileInputStream.float("d>+\u007f$r(zw>")).append(a2).toString();
                throw new IOException(a3);
            }
        }
        catch (InterruptedException a2) {
            // empty catch block
        }
        if (isDebug) {
            System.out.println(new StringBuilder().insert(0, SudoFileInputStream.float("{5{.6")).append(VMControlLibrary.toString(args)).append(SudoFileInputStream.float("d>\u0002U")).toString());
        }
    }

    public static boolean isLoaded() {
        return VMwareObject.LOADED;
    }

    private static /* synthetic */ String toString(String[] args) {
        int a;
        StringBuffer a2 = new StringBuffer();
        int n = a = 0;
        while (n < args.length) {
            if (a2.length() != 0) {
                a2.append(' ');
            }
            StringBuffer stringBuffer = a2.append(SudoFileInputStream.float("9")).append(args[a]);
            stringBuffer.append(SudoFileInputStream.float("9"));
            n = ++a;
        }
        return a2.toString();
    }

    public static void setSharedLibrary(String lib) {
        System.setProperty(PROP_VMCONTROL_SHLIB, lib);
    }
}

