/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32;

import com.jeesite.modules.sys.utils.CorpUtils;
import java.util.List;
import java.util.Vector;
import org.hyperic.sigar.cmd.Watch;
import org.hyperic.sigar.win32.Win32;
import org.hyperic.sigar.win32.Win32Exception;

public class RegistryKey
extends Win32 {
    private static final int HKEY_LOCAL_MACHINE = -2147483646;
    private String subkey;
    public static final RegistryKey ClassesRoot = new RegistryKey(Integer.MIN_VALUE);
    private static final int HKEY_PERFORMANCE_DATA = -2147483644;
    private static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    private long m_hkey;
    public static final RegistryKey LocalMachine;
    private static final int HKEY_CURRENT_CONFIG = -2147483643;
    private static final int HKEY_DYN_DATA = -2147483642;
    private static final int HKEY_CURRENT_USER = -2147483647;
    private static final int HKEY_USERS = -2147483645;
    public static final RegistryKey CurrentUser;

    private /* synthetic */ RegistryKey() {
    }

    public void setIntValue(String name, int value) throws Win32Exception {
        if (RegistryKey.RegSetIntValue(this.m_hkey, name, value) != 0) {
            throw new Win32Exception(CorpUtils.float("8p\u000fm\u000f\"\u000eg\tv\u0014l\u001a\"\u0014l\t\"\u000bc\u0011w\u0018"));
        }
    }

    private static native /* synthetic */ int RegLoadKey(long var0, String var2, String var3);

    private static native /* synthetic */ int RegCloseKey(long var0);

    public int getIntValue(String name, int defaultValue) {
        try {
            int a = this.getIntValue(name);
            return a;
        }
        catch (Win32Exception a) {
            int a2 = defaultValue;
            return a2;
        }
    }

    public String[] getValueNames() {
        String a;
        Vector<String> a2 = new Vector<String>();
        int a3 = 0;
        RegistryKey registryKey = this;
        while ((a = RegistryKey.RegEnumValueName(registryKey.m_hkey, a3)) != null) {
            registryKey = this;
            ++a3;
            a2.add(a);
        }
        Vector<String> vector = a2;
        return vector.toArray(new String[vector.size()]);
    }

    public int getIntValue(String name) throws Win32Exception {
        int a = 0;
        try {
            a = RegistryKey.RegQueryIntValue(this.m_hkey, name);
            return a;
        }
        catch (Throwable a2) {
            throw new Win32Exception(Watch.float(",:\u001b'\u001bh\u000e-\u001d<\u0000&\u000eh\u0000&\u001dh\u001f)\u0005=\f"));
        }
    }

    private static native /* synthetic */ int RegDeleteValue(long var0, String var2);

    private static native /* synthetic */ String RegEnumKey(long var0, int var2);

    private static native /* synthetic */ int RegSetStringValue(long var0, String var2, String var3);

    public RegistryKey openSubKey(String subkey) throws Win32Exception {
        long a = RegistryKey.RegOpenKey(this.m_hkey, subkey);
        if (a == 0L) {
            throw new Win32Exception(CorpUtils.float("G\u000fp\u0012p]m\rg\u0013k\u0013e]q\b`\u0016g\u0004"));
        }
        new RegistryKey(a).subkey = subkey;
        return new RegistryKey(a);
    }

    public void deleteSubKey(String subkey) {
        RegistryKey.RegDeleteKey(this.m_hkey, subkey);
    }

    private static native /* synthetic */ int RegDeleteKey(long var0, String var2);

    public synchronized void close() {
        if (this.m_hkey != 0L) {
            RegistryKey.RegCloseKey(this.m_hkey);
            this.m_hkey = 0L;
        }
    }

    static {
        CurrentUser = new RegistryKey(-2147483647L);
        LocalMachine = new RegistryKey(-2147483646L);
    }

    private /* synthetic */ RegistryKey(long l2) {
        this.m_hkey = l2;
    }

    public RegistryKey createSubKey(String subkey, int value) throws Win32Exception {
        RegistryKey a = null;
        long a2 = RegistryKey.RegCreateKey(this.m_hkey, subkey);
        if (a2 != 0L) {
            a = new RegistryKey(a2);
            if (a != null) {
                RegistryKey registryKey = a;
                registryKey.setIntValue(null, value);
                return registryKey;
            }
        } else {
            throw new Win32Exception(Watch.float(",:\u001b'\u001bh\n:\f)\u001d!\u0007/I;\u001c*\u0002-\u0010"));
        }
        return a;
    }

    public void flush() {
        RegistryKey.RegFlushKey(this.m_hkey);
    }

    private static native /* synthetic */ long RegCreateKey(long var0, String var2);

    private static native /* synthetic */ long RegOpenKey(long var0, String var2);

    private static native /* synthetic */ byte[] RegQueryBufferValue(long var0, String var2);

    public String[] getSubKeyNames() {
        String a;
        Vector<String> a2 = new Vector<String>();
        int a3 = 0;
        RegistryKey registryKey = this;
        while ((a = RegistryKey.RegEnumKey(registryKey.m_hkey, a3)) != null) {
            registryKey = this;
            ++a3;
            a2.add(a);
        }
        Vector<String> vector = a2;
        return vector.toArray(new String[vector.size()]);
    }

    public String getSubKeyName() {
        return this.subkey;
    }

    public void deleteValue(String name) {
        RegistryKey.RegDeleteValue(this.m_hkey, name);
    }

    public RegistryKey createSubKey(String subkey) {
        return new RegistryKey(RegistryKey.RegCreateKey(this.m_hkey, subkey));
    }

    private static native /* synthetic */ int RegQueryIntValue(long var0, String var2);

    private static native /* synthetic */ int RegSetIntValue(long var0, String var2, int var3);

    private static native /* synthetic */ int RegFlushKey(long var0);

    public String getStringValue(String name) throws Win32Exception {
        String a = RegistryKey.RegQueryStringValue(this.m_hkey, name);
        if (a == null) {
            throw new Win32Exception(CorpUtils.float("G\u000fp\u0012p]e\u0018v\tk\u0013e]q\tp\u0014l\u001a\"\u000bc\u0011w\u0018"));
        }
        return a;
    }

    private static native /* synthetic */ String RegQueryStringValue(long var0, String var2);

    private static native /* synthetic */ String RegEnumValueName(long var0, int var2);

    protected void finalize() {
        this.close();
    }

    public RegistryKey createSubKey(String subkey, String value) throws Win32Exception {
        RegistryKey a = null;
        long a2 = RegistryKey.RegCreateKey(this.m_hkey, subkey);
        if (a2 != 0L) {
            a = new RegistryKey(a2);
            if (a != null) {
                RegistryKey registryKey = a;
                registryKey.setStringValue(null, value);
                return registryKey;
            }
        } else {
            throw new Win32Exception(Watch.float(",:\u001b'\u001bh\n:\f)\u001d!\u0007/I;\u001c*\u0002-\u0010"));
        }
        return a;
    }

    public void getMultiStringValue(String name, List values) throws Win32Exception {
        RegistryKey.RegQueryMultiStringValue(this.m_hkey, name, values);
    }

    public void deleteSubKeyTree(String subkey) {
    }

    private static native /* synthetic */ void RegQueryMultiStringValue(long var0, String var2, List var3);

    public String getStringValue(String name, String defaultValue) {
        try {
            String a = this.getStringValue(name);
            return a;
        }
        catch (Win32Exception a) {
            String a2 = defaultValue;
            return a2;
        }
    }

    public void setStringValue(String name, String value) throws Win32Exception {
        if (RegistryKey.RegSetStringValue(this.m_hkey, name, value) != 0) {
            throw new Win32Exception(CorpUtils.float("G\u000fp\u0012p]q\u0018v\tk\u0013e]q\tp\u0014l\u001a\"\u000bc\u0011w\u0018"));
        }
    }
}

