/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32;

import com.jeesite.common.j2cache.cache.support.redis.ConfigureNotifyKeyspaceEventsAction;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.win32.ServiceConfig;
import org.hyperic.sigar.win32.Win32;
import org.hyperic.sigar.win32.Win32Exception;
import org.hyperic.sigar.win32.h;

public class Service
extends Win32 {
    private static final int SC_MANAGER_QUERY_LOCK_STATUS = 16;
    private static final int CONTROL_STOP = 1;
    private static final int CONTROL_PAUSE = 2;
    private static final int CONTROL_START = 0;
    private long manager = Service.OpenSCManager("", 983103);
    private static final int SERVICE_START = 16;
    public static final int SERVICE_PAUSE_PENDING = 6;
    private long service;
    private static final String[] STATUS;
    public static final int SERVICE_CONTINUE_PENDING = 5;
    private static final int SC_MANAGER_CONNECT = 1;
    private static final int SERVICE_ENUMERATE_DEPENDENTS = 8;
    private static final int SC_MANAGER_MODIFY_BOOT_CONFIG = 32;
    public static final int SERVICE_STOPPED = 1;
    private static final int SERVICE_CHANGE_CONFIG = 2;
    public static final int SERVICE_STOP_PENDING = 3;
    public static final int SERVICE_PAUSED = 7;
    private static final int SERVICE_QUERY_STATUS = 4;
    private static final int SERVICE_QUERY_CONFIG = 1;
    private static final int STANDARD_RIGHTS_REQUIRED = 983040;
    private static final int SC_MANAGER_ENUMERATE_SERVICE = 4;
    private static final int SERVICE_PAUSE_CONTINUE = 64;
    private static final int SERVICE_INTERROGATE = 128;
    private static final int SC_MANAGER_ALL_ACCESS = 983103;
    public static final int SERVICE_START_PENDING = 2;
    private static final int SERVICE_ALL_ACCESS = 983551;
    private String name;
    private static final int SERVICE_USER_DEFINED_CONTROL = 256;
    public static final int SERVICE_RUNNING = 4;
    private static final int CONTROL_RESUME = 3;
    private static final int SC_MANAGER_CREATE_SERVICE = 2;
    private static final int SERVICE_STOP = 32;
    private static final int SC_MANAGER_LOCK = 8;

    public int getStatus() {
        return Service.QueryServiceStatus(this.service);
    }

    private static native /* synthetic */ void DeleteService(long var0) throws Win32Exception;

    private static native /* synthetic */ boolean QueryServiceConfig(long var0, ServiceConfig var2) throws Win32Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static List getServiceConfigs(Sigar sigar, String exe) throws Win32Exception {
        void a;
        int a2;
        ArrayList arrayList = new ArrayList();
        List a3 = Service.getServiceNames(sigar, FileSystem.float("&v\u0007e\u001cp\u0010=0k\u0010=<v\u0004.") + exe);
        int n = a2 = 0;
        while (n < a3.size()) {
            try (Service a4 = null;){
                a4 = new Service((String)a3.get(a2));
                ServiceConfig a5 = a4.getConfig();
                a.add(a5);
            }
            n = ++a2;
        }
        return a;
    }

    public ServiceConfig getConfig() throws Win32Exception {
        ServiceConfig a;
        ServiceConfig serviceConfig = a = new ServiceConfig();
        Service.QueryServiceConfig(this.service, serviceConfig);
        a.setName(this.name);
        return serviceConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int a;
        List a2;
        if (args.length == 0) {
            a2 = Service.getServiceNames();
        } else {
            if (args.length == 2 && args[0].equals(ConfigureNotifyKeyspaceEventsAction.float("l~.m&f$"))) {
                long a3 = 5000L;
                Service a4 = new Service(args[1]);
                if (a4.getStatus() == 4) {
                    System.out.println(FileSystem.float("@\u0001|\u0005c\u001c}\u00123\u0006v\u0007e\u001cp\u0010=[="));
                    a4.stop(a3);
                } else {
                    System.out.println(ConfigureNotifyKeyspaceEventsAction.float("\u0012~ x5c/may$x7c\"oo$o"));
                    a4.start(a3);
                }
                System.out.println(a4.getStatusString());
                return;
            }
            if (args.length == 1 && args[0].startsWith(FileSystem.float("&v\u0007e\u001cp\u0010="))) {
                try (Sigar a5 = new Sigar();){
                    a2 = Service.getServiceNames(a5, args[0]);
                }
            }
            if (args.length == 1 && args[0].endsWith(".exe")) {
                int a6;
                List a7;
                try (Sigar a8 = new Sigar();){
                    a7 = Service.getServiceConfigs(args[0]);
                }
                int n = a6 = 0;
                while (n < a7.size()) {
                    ServiceConfig a9 = (ServiceConfig)a7.get(a6);
                    a9.list(System.out);
                    System.out.println("");
                    n = ++a6;
                }
                return;
            }
            a2 = Arrays.asList(args);
        }
        int n = a = 0;
        while (n < a2.size()) {
            String a10 = (String)a2.get(a);
            Service a11 = new Service(a10);
            a11.list(System.out);
            System.out.println("");
            n = ++a;
        }
    }

    public void list(PrintStream out) throws Win32Exception {
        this.getConfig().list(out);
        out.println(ConfigureNotifyKeyspaceEventsAction.float("2~ ~4yo$o$o$o$\u001a") + this.getStatusString() + FileSystem.float("N"));
    }

    public String getStatusString() {
        return STATUS[this.getStatus()];
    }

    static {
        String[] stringArray = new String[8];
        stringArray[0] = ConfigureNotifyKeyspaceEventsAction.float("\u0014d*d.}/");
        stringArray[1] = FileSystem.float("@\u0001|\u0005c\u0010w");
        stringArray[2] = ConfigureNotifyKeyspaceEventsAction.float("\u0012~ x5*\u0011o/n(d&");
        stringArray[3] = FileSystem.float("&g\u001acUC\u0010}\u0011z\u001bt");
        stringArray[4] = ConfigureNotifyKeyspaceEventsAction.float("\u0013\u007f/d(d&");
        stringArray[5] = FileSystem.float("6|\u001bg\u001c}\u0000vUC\u0010}\u0011z\u001bt");
        stringArray[6] = ConfigureNotifyKeyspaceEventsAction.float("\u0011k4y$*\u0011o/n(d&");
        stringArray[7] = FileSystem.float("%r\u0000`\u0010w");
        STATUS = stringArray;
    }

    public void start() throws Win32Exception {
        this.control(0);
    }

    public void setDescription(String description) {
        Service.ChangeServiceDescription(this.service, description);
    }

    private static native /* synthetic */ boolean CloseServiceHandle(long var0);

    public void stop(long timeout) throws Win32Exception {
        this.stop();
        if (!new h(this, timeout, 1, 3).float()) {
            throw new Win32Exception(ConfigureNotifyKeyspaceEventsAction.float("L c-o%*5eay5e1*2o3|(i$"));
        }
    }

    public static List getServiceNames() throws Win32Exception {
        return Service.getServiceNames(null, null);
    }

    public static Service create(ServiceConfig config) throws Win32Exception {
        if (config.getName() == null) {
            throw new IllegalArgumentException(FileSystem.float("}\u0014~\u0010.\u001bf\u0019\u007f"));
        }
        if (config.getPath() == null) {
            throw new IllegalArgumentException(ConfigureNotifyKeyspaceEventsAction.float("1k5b|d4f-"));
        }
        Service a = new Service();
        a.service = Service.CreateService(a.manager, config.getName(), config.getDisplayName(), config.getType(), config.getStartType(), config.getErrorControl(), config.getPath(), config.getDependencies(), config.getStartName(), config.getPassword());
        if (config.getDescription() != null) {
            a.setDescription(config.getDescription());
        }
        return a;
    }

    private static native /* synthetic */ int QueryServiceStatus(long var0);

    private /* synthetic */ Service() throws Win32Exception {
    }

    public void stop() throws Win32Exception {
        this.control(1);
    }

    private static native /* synthetic */ long OpenService(long var0, String var2, int var3) throws Win32Exception;

    public void resume() throws Win32Exception {
        this.control(3);
    }

    public void pause(long timeout) throws Win32Exception {
        this.pause();
        if (!new h(this, timeout, 7, 6).float()) {
            throw new Win32Exception(FileSystem.float("U\u0014z\u0019v\u00113\u0001|Uc\u0014f\u0006vU`\u0010a\u0003z\u0016v"));
        }
    }

    public synchronized void close() {
        if (this.service != 0L) {
            Service.CloseServiceHandle(this.service);
            this.service = 0L;
        }
        if (this.manager != 0L) {
            Service.CloseServiceHandle(this.manager);
            this.manager = 0L;
        }
    }

    public static native List getServiceNames(Sigar var0, String var1) throws Win32Exception;

    public static List getServiceConfigs(String exe) throws Win32Exception {
        try (Sigar a = new Sigar();){
            List list = Service.getServiceConfigs(a, exe);
            return list;
        }
    }

    private static native /* synthetic */ boolean ChangeServiceDescription(long var0, String var2);

    private static native /* synthetic */ long OpenSCManager(String var0, int var1) throws Win32Exception;

    private /* synthetic */ void control(int ctl) throws Win32Exception {
        Service.ControlService(this.service, ctl);
    }

    public void start(long timeout) throws Win32Exception {
        this.start();
        if (!new h(this, timeout, 4, 2).float()) {
            throw new Win32Exception(ConfigureNotifyKeyspaceEventsAction.float("\u0007k(f$na~.*2~ x5*2o3|(i$"));
        }
    }

    protected void finalize() {
        this.close();
    }

    private static native /* synthetic */ void ControlService(long var0, int var2) throws Win32Exception;

    private static native /* synthetic */ long CreateService(long var0, String var2, String var3, int var4, int var5, int var6, String var7, String[] var8, String var9, String var10) throws Win32Exception;

    public void delete() throws Win32Exception {
        Service.DeleteService(this.service);
    }

    public void pause() throws Win32Exception {
        this.control(2);
    }

    /*
     * WARNING - void declaration
     */
    public Service(String string) throws Win32Exception {
        this();
        void serviceName;
        this.service = Service.OpenService(this.manager, (String)serviceName, 983551);
        this.name = string;
    }

    public int status() {
        return this.getStatus();
    }

    public void stopAndWait(long timeout) throws Win32Exception {
        this.stop(timeout);
    }
}

