/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.xa.DruidXADataSource;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.datasource.DataSourceHolder;
import com.jeesite.common.datasource.t.F;
import com.jeesite.common.lang.StringUtils;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.hyperic.sigar.ProcTime;
import org.hyperic.sigar.cmd.EventLogTail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.jta.atomikos.AtomikosDataSourceBean;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class RoutingDataSource
extends AbstractRoutingDataSource {
    private Object defaultTargetDataSource;
    private static final Logger logger = LoggerFactory.getLogger(RoutingDataSource.class);
    private Map<Object, Object> targetDataSources;

    public void setTargetDataSources(Map<Object, Object> targetDataSources) {
        this.targetDataSources = targetDataSources;
        super.setTargetDataSources(this.targetDataSources);
    }

    protected Object determineCurrentLookupKey() {
        return DataSourceHolder.getDataSourceName();
    }

    public void initJeeSiteTargetDataSource() {
        Object a;
        try {
            a = RoutingDataSource.createDataSource("default");
            this.setDefaultTargetDataSource(a);
        }
        catch (SQLException a2) {
            logger.error(EventLogTail.break("\\_|E5EtCrTa\u0011qPaP5BzDgRp\u0011pCg^g\u000b5UpWtDyE"), (Throwable)a2);
        }
        a = Global.getProperty(ProcTime.break("\u001ev\u0016qZv\u0015f\u0015A\u001bg\u0006q\u0011\\\u0015\u007f\u0011a"));
        if (StringUtils.isNotBlank((CharSequence)a)) {
            int n;
            String[] stringArray = StringUtils.split((String)a, (String)EventLogTail.break("\u001d"));
            int n2 = stringArray.length;
            int n3 = n = 0;
            while (n3 < n2) {
                String a3 = stringArray[n];
                try {
                    a3 = StringUtils.trim((String)a3);
                    DataSource a4 = RoutingDataSource.createDataSource(a3);
                    this.addTargetDataSource(a3, a4);
                }
                catch (SQLException a5) {
                    logger.error(new StringBuilder().insert(0, ProcTime.break("[\u001a{\u00002\u0000s\u0006u\u0011fTv\u0015f\u00152\u0007}\u0001`\u0017wTw\u0006`\u001b`N2")).append(a3).toString(), (Throwable)a5);
                }
                n3 = ++n;
            }
        }
    }

    public DataSource getTargetDataSource(String dataSourceName) {
        if (StringUtils.isBlank((CharSequence)dataSourceName) || "default".equals(dataSourceName)) {
            return (DataSource)this.defaultTargetDataSource;
        }
        Object a = this.targetDataSources.get(dataSourceName);
        if (a == null) {
            return (DataSource)this.defaultTargetDataSource;
        }
        return (DataSource)a;
    }

    public void setDefaultTargetDataSource(Object defaultTargetDataSource) {
        if (defaultTargetDataSource == null) {
            logger.warn(EventLogTail.break("bpE5UpWtDyE5EtCrTa\u0011qPaP5BzDgRp\u0011|B5_`]y\u001f"));
            return;
        }
        this.defaultTargetDataSource = defaultTargetDataSource;
        super.setDefaultTargetDataSource(this.defaultTargetDataSource);
        logger.debug(ProcTime.break("A\u0011fTv\u0011t\u0015g\u0018fTf\u0015`\u0013w\u00002\u0010s\u0000sTa\u001bg\u0006q\u00112\u0007g\u0017q\u0011a\u0007<"));
    }

    public static DataSource createDataSource(String dataSourceName, boolean isJta) throws SQLException {
        DruidXADataSource druidXADataSource;
        String a;
        if (StringUtils.isBlank((CharSequence)dataSourceName)) {
            dataSourceName = "default";
        }
        String a2 = EventLogTail.break("\u007fUwR");
        if (!"default".equals(dataSourceName)) {
            a2 = new StringBuilder().insert(0, a2).append(".").append(dataSourceName).toString();
        }
        if (StringUtils.isBlank((CharSequence)(a = Global.getProperty(new StringBuilder().insert(0, a2).append(ProcTime.break("<\u0000k\u0004w")).toString()))) && !EventLogTail.break("\u007fUwR").equals(a2)) {
            a2 = ProcTime.break("\u001ev\u0016q");
            a = Global.getProperty(new StringBuilder().insert(0, a2).append(EventLogTail.break("\u001faHeT")).toString());
        }
        if (StringUtils.isBlank((CharSequence)a)) {
            return null;
        }
        DruidXADataSource a3 = null;
        (isJta ? (a3 = new DruidXADataSource()) : (a3 = new DruidDataSource())).setName(dataSourceName);
        DruidXADataSource druidXADataSource2 = a3;
        druidXADataSource2.setDriverClassName(Global.getProperty(a2 + ProcTime.break("<\u0010`\u001dd\u0011`")));
        a3.setUrl(Global.getProperty(new StringBuilder().insert(0, a2).append(EventLogTail.break(";Dg]")).toString()));
        druidXADataSource2.setUsername(Global.getProperty(new StringBuilder().insert(0, a2).append(ProcTime.break("<\u0001a\u0011`\u001as\u0019w")).toString()));
        druidXADataSource2.setPassword(Global.getProperty(new StringBuilder().insert(0, a2).append(EventLogTail.break("\u001fePfBb^gU")).toString()));
        CharSequence[] charSequenceArray = new CharSequence[3];
        charSequenceArray[0] = a3.getDriverClassName();
        charSequenceArray[1] = a3.getUrl();
        charSequenceArray[2] = a3.getUsername();
        if (StringUtils.isAnyBlank((CharSequence[])charSequenceArray)) {
            a3.close();
            return null;
        }
        String a4 = Global.getProperty(new StringBuilder().insert(0, a2).append(ProcTime.break("Zf\u0011a\u0000A\u0005~")).toString());
        DruidXADataSource druidXADataSource3 = a3;
        if (StringUtils.isNotBlank((CharSequence)a4)) {
            druidXADataSource3.setTestWhileIdle(true);
            DruidXADataSource druidXADataSource4 = a3;
            druidXADataSource = druidXADataSource4;
            druidXADataSource4.setValidationQuery(a4);
        } else {
            druidXADataSource3.setTestWhileIdle(false);
            logger.warn(new StringBuilder().insert(0, EventLogTail.break("\u5f62\u5258\u0011")).append(a2).append(ProcTime.break("<\u0000w\u0007f'c\u00182\u675e\u8bac\u7f1a\uff1e\u7c8f\u7ecd\u5c72\u4e1f\u4f6e\u8fc9\u8838\u7a68\u9586\u8fcc\u63d1\u68d2\u6791\u3010")).toString());
            druidXADataSource = a3;
        }
        druidXADataSource.setInitialSize(Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(EventLogTail.break(";Az^y\u001f|_|E")).toString(), "1").intValue());
        DruidXADataSource druidXADataSource5 = a3;
        druidXADataSource5.setMinIdle(Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(ProcTime.break("<\u0004}\u001b~Z\u007f\u001d|=v\u0018w")).toString(), "3").intValue());
        druidXADataSource5.setMaxActive(Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(EventLogTail.break("\u001fe^z];\\tITRaXcT")).toString(), ProcTime.break("F\"")).intValue());
        druidXADataSource5.setMaxWait((long)Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(EventLogTail.break("\u001fe^z];\\tIBP|E")).toString(), ProcTime.break("$D\"D\"")).intValue());
        druidXADataSource5.setTestOnBorrow(Global.getPropertyToBoolean(new StringBuilder().insert(0, a2).append(EventLogTail.break(";Az^y\u001faTfEZ_W^gCzF")).toString(), "false").booleanValue());
        druidXADataSource5.setTestOnReturn(Global.getPropertyToBoolean(new StringBuilder().insert(0, a2).append(ProcTime.break("Zb\u001b}\u0018<\u0000w\u0007f;|&w\u0000g\u0006|")).toString(), "false").booleanValue());
        druidXADataSource5.setTimeBetweenEvictionRunsMillis((long)Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(EventLogTail.break("\u001fe^z];E|\\pspEbTp_PG|RaXz_GD{BXXy]|B")).toString(), ProcTime.break("$D\"D\"")).intValue());
        druidXADataSource5.setMinEvictableIdleTimeMillis((long)Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(EventLogTail.break(";Az^y\u001fxX{tcXvEtSyT\\UyTAXxTXXy]|B")).toString(), ProcTime.break("#F\"D\"D\"")).intValue());
        druidXADataSource5.setMaxEvictableIdleTimeMillis((long)Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(EventLogTail.break(";Az^y\u001fxPmtcXvEtSyT\\UyTAXxTXXy]|B")).toString(), ProcTime.break("#L\"D\"D\"")).intValue());
        druidXADataSource5.setRemoveAbandoned(Global.getPropertyToBoolean(new StringBuilder().insert(0, a2).append(EventLogTail.break("\u001fe^z];Cp\\zGppwP{Uz_pU")).toString(), "true").booleanValue());
        druidXADataSource5.setRemoveAbandonedTimeout(Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(ProcTime.break("Zb\u001b}\u0018<\u0006w\u0019}\u0002w5p\u0015|\u0010}\u001aw\u0010F\u001d\u007f\u0011}\u0001f")).toString(), EventLogTail.break("'\u0000%\u0001")).intValue());
        if (ProcTime.break("\u001b`\u0015q\u0018w").equals(a)) {
            DruidXADataSource druidXADataSource6 = a3;
            druidXADataSource6.setPoolPreparedStatements(true);
            druidXADataSource6.setMaxPoolPreparedStatementPerConnectionSize(druidXADataSource6.getMaxActive());
        }
        DruidXADataSource druidXADataSource7 = a3;
        druidXADataSource7.setFilters(EventLogTail.break("fEtE"));
        druidXADataSource7.getProxyFilters().add(new F(a2));
        a3.init();
        if (druidXADataSource7 instanceof XADataSource) {
            AtomikosDataSourceBean a5 = new AtomikosDataSourceBean();
            a5.setXaDataSource((XADataSource)a3);
            AtomikosDataSourceBean atomikosDataSourceBean = a5;
            a5.setUniqueResourceName(a3.getName());
            atomikosDataSourceBean.setMinPoolSize(0);
            atomikosDataSourceBean.setMaxPoolSize(a3.getMaxActive());
            return atomikosDataSourceBean;
        }
        return a3;
    }

    public RoutingDataSource() throws SQLException {
        RoutingDataSource routingDataSource = this;
        routingDataSource.setTargetDataSources(MapUtils.newConcurrentMap());
    }

    public static DataSource createDataSource(String dataSourceName) throws SQLException {
        boolean a = Global.getPropertyToBoolean(ProcTime.break("\u001ev\u0016qZx\u0000sZw\u001as\u0016~\u0011v"), "false");
        return RoutingDataSource.createDataSource(dataSourceName, a);
    }

    public void addTargetDataSource(String dataSourceName, DataSource dataSource) {
        if (dataSource == null) {
            logger.warn(new StringBuilder().insert(0, EventLogTail.break("TUq\u0011aPgVpE5UtEt\u0011f^`CvT5Xf\u0011{Dy]/\u0011")).append(dataSourceName).toString());
            return;
        }
        this.targetDataSources.put(dataSourceName, dataSource);
        logger.debug(new StringBuilder().insert(0, ProcTime.break("5v\u00102\u0000s\u0006u\u0011fTv\u0015f\u00152\u0007}\u0001`\u0017wTa\u0001q\u0017w\u0007aN2")).append(dataSourceName).toString());
    }

    public void removeTargetDataSource(String dataSourceName) {
        this.targetDataSources.remove(dataSourceName);
        logger.debug(new StringBuilder().insert(0, EventLogTail.break("cp\\zGp\u0011aPgVpE5UtEt\u0011f^`CvT/\u0011")).append(dataSourceName).toString());
    }
}

