/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.session;

import com.jeesite.common.collect.MapUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.mgt.ValidatingSession;

public class StaticSession
implements ValidatingSession,
Serializable {
    private Serializable id = "1";
    public static final StaticSession INSTANCE = new StaticSession();
    private Map<Object, Object> attributes;
    private Date startTimestamp;
    private static final long serialVersionUID = 1L;

    public long getTimeout() throws InvalidSessionException {
        return Long.MAX_VALUE;
    }

    public Date getLastAccessTime() {
        return new Date();
    }

    public void touch() throws InvalidSessionException {
    }

    public void setAttribute(Object key, Object value) throws InvalidSessionException {
        this.attributes.put(key, value);
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public void validate() throws InvalidSessionException {
    }

    public void setTimeout(long maxIdleTimeInMillis) throws InvalidSessionException {
    }

    public boolean isValid() {
        return true;
    }

    public StaticSession() {
        StaticSession staticSession = this;
        this.startTimestamp = new Date();
        staticSession.attributes = MapUtils.newHashMap();
    }

    public String getHost() {
        return null;
    }

    public void stop() throws InvalidSessionException {
    }

    public Object getAttribute(Object key) throws InvalidSessionException {
        return this.attributes.get(key);
    }

    public Collection<Object> getAttributeKeys() throws InvalidSessionException {
        return this.attributes.keySet();
    }

    public Serializable getId() {
        return this.id;
    }

    public Object removeAttribute(Object key) throws InvalidSessionException {
        return this.attributes.remove(key);
    }
}

