/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.gen.service;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.datasource.DataSourceHolder;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.mapper.MapperHelper;
import com.jeesite.common.service.CrudService;
import com.jeesite.modules.gen.dao.GenDataDictDao;
import com.jeesite.modules.gen.dao.GenTableColumnDao;
import com.jeesite.modules.gen.dao.GenTableDao;
import com.jeesite.modules.gen.entity.GenTable;
import com.jeesite.modules.gen.entity.GenTableColumn;
import com.jeesite.modules.gen.entity.config.GenConfig;
import com.jeesite.modules.gen.entity.config.GenTemplate;
import com.jeesite.modules.gen.utils.GenUtils;
import com.jeesite.modules.job.t.F;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hyperic.sigar.Who;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
@ConditionalOnProperty(name={"gen.enabled"}, havingValue="true", matchIfMissing=true)
public class GenTableService
extends CrudService<GenTableDao, GenTable> {
    @Autowired
    private GenDataDictDao genDataDictDao;
    @Autowired
    private GenTableColumnDao genTableColumnDao;

    public List<GenTable> findListFromDb(GenTable genTable) {
        GenTableService genTableService;
        String a = genTable.getDataSourceName();
        if (StringUtils.isNotBlank((CharSequence)a)) {
            try {
                DataSourceHolder.setDataSourceName(a);
                genTableService = this;
            }
            catch (Exception a2) {
                return ListUtils.newArrayList();
            }
        } else {
            genTableService = this;
        }
        List<GenTable> a3 = genTableService.genDataDictDao.findTableList(genTable);
        if (StringUtils.isNotBlank((CharSequence)a)) {
            DataSourceHolder.clearDataSourceName();
        }
        return a3;
    }

    @Override
    @Transactional(readOnly=false)
    public void save(GenTable genTable) {
        GenTable genTable2 = genTable;
        super.save(genTable2);
        for (GenTableColumn a : genTable2.getColumnList()) {
            a.setGenTable(genTable);
            if (StringUtils.isBlank((CharSequence)a.getId())) {
                this.genTableColumnDao.insert(a);
                continue;
            }
            if ("1".equals(a.getStatus())) {
                this.genTableColumnDao.delete(a);
                continue;
            }
            this.genTableColumnDao.update(a);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String generateCode(GenTable genTable) {
        Iterator<GenTemplate> iterator;
        Object a;
        Iterator<GenTable> a2;
        StringBuilder a3 = new StringBuilder();
        GenConfig genConfig = GenUtils.getConfig();
        List<GenTemplate> a4 = GenUtils.getTemplateList(genConfig, genTable.getTplCategory(), false);
        List<GenTemplate> a5 = GenUtils.getTemplateList(genConfig, genTable.getTplCategory(), true);
        if (a5.size() > 0) {
            GenTable genTable2 = new GenTable();
            GenTable genTable3 = genTable;
            ((DataEntity)((Object)a2)).setStatus("0");
            ((GenTable)((Object)a2)).setParentTableName(genTable3.getTableName());
            genTable3.setChildList(((GenTableDao)this.dao).findList(a2));
        }
        if (a5.size() > 0 && genTable.getChildList().size() > 0) {
            a2 = genTable.getChildList().iterator();
            while (a2.hasNext()) {
                GenTable object2;
                GenTable genTable4 = object2 = a2.next();
                genTable4.setParent(genTable);
                genTable4.setColumnList(this.genTableColumnDao.findList(new GenTableColumn(object2)));
                a = GenUtils.getDataModel(genTable4);
                Iterator<GenTemplate> iterator2 = a5.iterator();
                while (iterator2.hasNext()) {
                    void a7;
                    Iterator<GenTemplate> iterator3;
                    GenTemplate genTemplate = iterator3.next();
                    iterator2 = iterator3;
                    a3.append(GenUtils.generateToFile((GenTemplate)a7, (Map<String, Object>)a, object2));
                }
            }
        }
        Map<String, Object> a6 = GenUtils.getDataModel(genTable);
        Iterator<GenTemplate> iterator4 = iterator = a4.iterator();
        while (iterator4.hasNext()) {
            a = iterator.next();
            iterator4 = iterator;
            a3.append(GenUtils.generateToFile((GenTemplate)a, a6, genTable));
        }
        return a3.toString();
    }

    /*
     * Unable to fully structure code
     */
    public GenTable getFromDb(GenTable genTable) {
        block18: {
            block19: {
                block20: {
                    if (!StringUtils.isNotBlank((CharSequence)genTable.getTableName())) break block18;
                    a = genTable.getDataSourceName();
                    if (StringUtils.isNotBlank((CharSequence)a)) {
                        try {
                            DataSourceHolder.setDataSourceName(a);
                            v0 = this;
                        }
                        catch (Exception a) {
                            return genTable;
                        }
                    } else {
                        v0 = this;
                    }
                    a = v0.genDataDictDao.findTableList(genTable);
                    if (a.size() <= 0) break block19;
                    if (!genTable.getIsNewRecord()) break block20;
                    genTable = a.get(0);
                    if (StringUtils.isNotBlank((CharSequence)a)) {
                        genTable.setDataSourceName(a);
                    }
                    if (StringUtils.isBlank((CharSequence)genTable.getComments())) {
                        v1 = genTable;
                        v1.setComments(v1.getTableName());
                    }
                    v2 = genTable;
                    v2.setFunctionName(v2.getComments());
                    v2.setFunctionNameSimple(v2.getComments());
                    v3 = genTable;
                    if (StringUtils.startsWith((CharSequence)v2.getTableName(), (CharSequence)Global.getTablePrefix())) {
                        a = StringUtils.substringAfter((String)v3.getTableName(), (String)Global.getTablePrefix());
                        v4 = genTable;
                        v5 = v4;
                        v4.setClassName(StringUtils.capCamelCase((String)a));
                    } else {
                        v3.setClassName(StringUtils.capCamelCase((String)genTable.getTableName()));
                        v5 = genTable;
                    }
                    if (StringUtils.startsWith((CharSequence)v5.getClassName(), (CharSequence)Who.break("<4\u001c"))) {
                        v6 = genTable;
                        v6.setClassName(StringUtils.substringAfter((String)v6.getClassName(), (String)F.break((Object)"?0\u001f")));
                    }
                    if (!StringUtils.isBlank((CharSequence)genTable.getPackageName())) ** GOTO lbl43
                    a = Global.getConfig(Who.break("*\n#A)\n+\u000e8\u00039?,\f&\u000e*\n\u0003\u000e \n"));
                    v7 = genTable;
                    if (StringUtils.isNotBlank((CharSequence)a)) {
                        v7.setPackageName((String)a);
                        v8 = genTable;
                    } else {
                        v7.setPackageName(F.break((Object)"\u000f&\u0001g\u0006,\t:\u0005=\tg\u0001&\b<\u0000,\u001f"));
lbl43:
                        // 2 sources

                        v8 = genTable;
                    }
                    if (StringUtils.isBlank((CharSequence)v8.getModuleName())) {
                        a = genTable.getTableName();
                        if (StringUtils.startsWith((CharSequence)a, (CharSequence)Global.getTablePrefix())) {
                            a = StringUtils.substringAfter((String)a, (String)Global.getTablePrefix());
                        }
                        genTable.setModuleName(StringUtils.substringBefore((String)a, (String)Who.break("0")));
                    }
                }
                a = this.genDataDictDao.findTableColumnList(genTable);
                var5_6 = a.iterator();
                while (var5_6.hasNext()) {
                    a = var5_6.next();
                    a = false;
                    for (GenTableColumn a : genTable.getColumnList()) {
                        if (!a.getColumnName().equals(a.getColumnName())) continue;
                        a = true;
                    }
                    if (a) continue;
                    genTable.getColumnList().add(a);
                }
                for (GenTableColumn a : genTable.getColumnList()) {
                    a = false;
                    var8_9 = a.iterator();
                    while (var8_9.hasNext()) {
                        a = var8_9.next();
                        if (!a.getColumnName().equals(a.getColumnName())) continue;
                        a = true;
                    }
                    if (a) continue;
                    a.setStatus("1");
                }
                v9 = genTable;
                v9.setPkList(this.genDataDictDao.findTablePK(v9));
                GenUtils.initColumnField(genTable);
            }
            if (StringUtils.isNotBlank((CharSequence)a)) {
                DataSourceHolder.clearDataSourceName();
            }
        }
        return genTable;
    }

    @Override
    public Page<GenTable> findPage(GenTable genTable) {
        String a = new StringBuilder().insert(0, F.break((Object)"a?\f \f/\u001dL*\u0003<\u0002=DxEi*\u001b#\u0004L")).append(MapperHelper.getTableName(genTable)).append(Who.break("m8\u0005*\u001f*m\u001f,\u001d(\u0001909\u000e/\u0003(0#\u000e \np\u000ec\u001b,\r!\n\u0012\u0001,\u0002(Fm.\u001eOo\f%\u0006!\u000b\u0003\u001a M")).toString();
        GenTable genTable2 = genTable;
        genTable2.getSqlMap().add(F.break((Object)"\t1\u0018\n\u0003%\u0019$\u0002"), a);
        return super.findPage(genTable2);
    }

    /*
     * WARNING - void declaration
     */
    public List<GenTable> findGenBaseDirList(GenTable genTable) {
        void genTable2;
        genTable2.setPage(new Page(1, 20, -1L));
        return ((GenTableDao)this.dao).findGenBaseDirList((GenTable)genTable2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional(readOnly=false)
    public void delete(GenTable genTable) {
        void a;
        GenTable genTable2 = genTable;
        super.delete(genTable2);
        if (StringUtils.isBlank((CharSequence)genTable2.getTableName())) {
            return;
        }
        GenTableColumn genTableColumn = new GenTableColumn();
        a.setGenTable(new GenTable(genTable.getTableName()));
        this.genTableColumnDao.deleteByEntity(a);
    }

    @Override
    public GenTable get(String tableName) {
        GenTable a = (GenTable)((Object)super.get(tableName));
        if (a != null) {
            GenTableColumn a2 = new GenTableColumn(a);
            a.setColumnList(this.genTableColumnDao.findList(a2));
        }
        return a;
    }

    public boolean checkTableName(String tableName) {
        if (StringUtils.isBlank((CharSequence)tableName)) {
            return true;
        }
        return ((GenTableDao)this.dao).get(new GenTable(tableName)) == null;
    }
}

