/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.job.web;

import com.jeesite.common.codec.EncodeUtils;
import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.mapper.provider.InsertSqlProvider;
import com.jeesite.common.web.BaseController;
import com.jeesite.common.web.q.C;
import com.jeesite.modules.job.entity.JobEntity;
import com.jeesite.modules.job.service.JobService;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.validation.ValidationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.hyperic.sigar.win32.EventLogRecord;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/job"})
@ConditionalOnProperty(name={"job.enabled", "web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class JobController
extends BaseController {
    @Autowired
    private JobService jobService;

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"form"})
    public String form(@ModelAttribute(value="job") JobEntity job, Model model) {
        if (job.getMisfireInstruction() == null) {
            job.setMisfireInstruction(2);
        }
        if (StringUtils.isBlank((CharSequence)job.getConcurrent())) {
            job.setConcurrent("0");
        }
        model.addAttribute("job", (Object)job);
        return InsertSqlProvider.break("`\u0005i\u001fa\u000f~Eg\u0005oEg\u0005o,b\u0018`");
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(JobEntity job) {
        if (!ObjectUtils.toBoolean(C.break().get(EventLogRecord.break("u3Y2q"))).booleanValue()) {
            return this.renderResult("false", InsertSqlProvider.break("\u5f5e\u5227\u7245\u6746\u6727\u5f6a\u6533\u6b0e\u5292\u8097\uff0c"));
        }
        this.jobService.delete(job);
        return this.renderResult("true", EventLogRecord.break("\u5233\u9639\u6203\u52c2\uff12"));
    }

    @ModelAttribute(value="job")
    public JobEntity get(String jobName, String jobGroup, boolean isNewRecord) {
        JobEntity a = null;
        CharSequence[] charSequenceArray = new CharSequence[2];
        charSequenceArray[0] = jobName;
        charSequenceArray[1] = jobGroup;
        if (StringUtils.isNoneBlank((CharSequence[])charSequenceArray)) {
            a = this.jobService.get(new JobEntity(jobName, jobGroup));
            if (isNewRecord && a != null) {
                throw new ValidationException(InsertSqlProvider.break("\u5400\u799a\u53c7\u7eae\u5400\u5d98\u7ec2\u5b32\u5725"));
            }
        }
        if (a == null) {
            a = new JobEntity();
        }
        return a;
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"resume"})
    @ResponseBody
    public String resume(JobEntity job) {
        if (!ObjectUtils.toBoolean(C.break().get(EventLogRecord.break("u3Y2q"))).booleanValue()) {
            return this.renderResult("false", InsertSqlProvider.break("\u5f5e\u5227\u7245\u6746\u6727\u5f6a\u6533\u6b0e\u5292\u8097\uff0c"));
        }
        this.jobService.resume(job);
        return this.renderResult("true", EventLogRecord.break("\u6071\u5950\u8fc3\u8811\u6203\u52c2\uff12"));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"checkCron"})
    @ResponseBody
    public String checkCron(String cron, @RequestParam(defaultValue="10") Integer num) {
        StringBuilder a = new StringBuilder();
        try {
            void a2;
            CronExpression a3 = new CronExpression(cron);
            if (num <= 0) {
                a.append(EventLogRecord.break("\u001ea2}\u8835\u8fad\u5f52\u6b70\u7833\u3011"));
                return this.renderResult("true", a.toString());
            }
            a.append(InsertSqlProvider.break("1\u001a3\u676a\u8fdc") + num + EventLogRecord.break("\u6b7c\u8fc3\u8811\u65e5\u95a9\uff09a<--"));
            Date a4 = new Date();
            boolean bl = false;
            void v0 = a2;
            while (v0 <= num) {
                if ((a4 = a3.getTimeAfter(a4)) == null) {
                    return this.renderResult("true", a.toString());
                }
                a.append(new StringBuilder().insert(0, DateUtils.formatDateTime((Date)a4)).append(InsertSqlProvider.break("1Eo\u00183")).toString());
                v0 = ++a2;
            }
            return this.renderResult("true", a.toString());
        }
        catch (ParseException a5) {
            return this.renderResult("false", new StringBuilder().insert(0, InsertSqlProvider.break(")\u007f\u0005c\u8802\u8fb3\u5f65\u9514\u8b85\uff17")).append(a5.getMessage()).toString());
        }
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated JobEntity job) {
        if (!ObjectUtils.toBoolean(C.break().get(EventLogRecord.break("u3Y2q"))).booleanValue()) {
            return this.renderResult("false", InsertSqlProvider.break("\u5f5e\u5227\u7245\u6746\u6727\u5f6a\u6533\u6b0e\u5292\u8097\uff0c"));
        }
        JobEntity jobEntity = job;
        jobEntity.setInvokeTarget(EncodeUtils.decodeBase64String((String)jobEntity.getInvokeTarget()));
        JobController jobController = this;
        jobController.jobService.save(job);
        return jobController.renderResult("true", EventLogRecord.break("\u4fce\u5b05\u6203\u52c2\uff12"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"runOnce"})
    @ResponseBody
    public String runOnce(JobEntity job) {
        if (!ObjectUtils.toBoolean(C.break().get(InsertSqlProvider.break("k\u0004G\u0005o"))).booleanValue()) {
            return this.renderResult("false", EventLogRecord.break("\u5f40\u5210\u725b\u6771\u6739\u5f5d\u652d\u6b39\u528c\u80a0\uff12"));
        }
        this.jobService.runOnce(job);
        return this.renderResult("true", InsertSqlProvider.break("\u8fdd\u8826\u4e0d\u6b4b\u621d\u52f5\uff0c"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"pause"})
    @ResponseBody
    public String pause(JobEntity job) {
        if (!ObjectUtils.toBoolean(C.break().get(EventLogRecord.break("u3Y2q"))).booleanValue()) {
            return this.renderResult("false", InsertSqlProvider.break("\u5f5e\u5227\u7245\u6746\u6727\u5f6a\u6533\u6b0e\u5292\u8097\uff0c"));
        }
        this.jobService.pause(job);
        return this.renderResult("true", EventLogRecord.break("\u6691\u5001\u8fc3\u8811\u6203\u52c2\uff12"));
    }

    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public List<JobEntity> listData(JobEntity job, String orderBy) {
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            orderBy = InsertSqlProvider.break("g\u0005o$l\u0007h");
        }
        List a = this.jobService.findList(job);
        a = ListUtils.listOrderBy(a, (String)orderBy);
        return a;
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"startAll"})
    @ResponseBody
    public String startAll() {
        if (!ObjectUtils.toBoolean(C.break().get(EventLogRecord.break("u3Y2q"))).booleanValue()) {
            return this.renderResult("false", InsertSqlProvider.break("\u5f5e\u5227\u7245\u6746\u6727\u5f6a\u6533\u6b0e\u5292\u8097\uff0c"));
        }
        if (!this.jobService.startAll()) {
            return this.renderResult("false", EventLogRecord.break("\u5472\u52bb\u5bc7\u65e5\u5635\u5922\u8d78\uff12"));
        }
        return this.renderResult("true", InsertSqlProvider.break("\u5445\u52a5\u5bf0\u65fb\u5602\u621d\u52f5\uff0c"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"stopAll"})
    @ResponseBody
    public String stopAll() {
        if (!ObjectUtils.toBoolean(C.break().get(EventLogRecord.break("u3Y2q"))).booleanValue()) {
            return this.renderResult("false", InsertSqlProvider.break("\u5f5e\u5227\u7245\u6746\u6727\u5f6a\u6533\u6b0e\u5292\u8097\uff0c"));
        }
        if (!this.jobService.stopAll()) {
            return this.renderResult("false", EventLogRecord.break("\u5001\u6b71\u5bc7\u65e5\u5635\u5922\u8d78\uff12"));
        }
        return this.renderResult("true", InsertSqlProvider.break("\u5036\u6b6f\u5bf0\u65fb\u5602\u621d\u52f5\uff0c"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"list"})
    public String list(JobEntity job, Model model) {
        void a;
        Boolean bl = this.jobService.isRunning();
        model.addAttribute(EventLogRecord.break("z.A(}3z3t"), (Object)a);
        return InsertSqlProvider.break("`\u0005i\u001fa\u000f~Eg\u0005oEg\u0005o&d\u0019y");
    }
}

