/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web;

import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.entity.Module;
import com.jeesite.modules.sys.service.ModuleService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.hyperic.sigar.FileWatcher;
import org.hyperic.sigar.NetInterfaceStat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/module"})
@ConditionalOnProperty(name={"web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class ModuleController
extends BaseController {
    @Autowired
    private ModuleService moduleService;

    @RequiresPermissions(value={"sys:module:edit"})
    @RequestMapping(value={"disable"})
    @ResponseBody
    public String disable(Module module) {
        if (!module.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", FileWatcher.break("\u8db1\u6728\u64f6\u4f37\uff37\u5381\u6732\u8dee\u7e9c\u7bca\u743d\u5433\u6276\u8096\u4fd5\u6552\u6b5f\u651b\u6355\uff6a"));
        }
        if ("core".equals(module.getModuleCode())) {
            return this.renderResult("false", NetInterfaceStat.break("\u6844\u5f8f\u6a5d\u571b\uff70\u4e41\u513d\u8bf4\u79fd\u7564\uff7d"));
        }
        module.setStatus("2");
        ModuleController moduleController = this;
        moduleController.moduleService.updateStatus(module);
        return moduleController.renderResult("true", new StringBuilder().insert(0, FileWatcher.break("\u5067\u7543\u6a1a\u573c")).append(module.getModuleName()).append(NetInterfaceStat.break("\u625c\u52e3")).toString());
    }

    @RequiresPermissions(value={"sys:module:edit"})
    @RequestMapping(value={"checkModuleCode"})
    @ResponseBody
    public String checkModuleCode(String oldCode, String moduleCode) {
        Module a = new Module();
        String string = moduleCode;
        a.setModuleCode(string);
        if (string != null && moduleCode.equals(oldCode)) {
            return "true";
        }
        if (moduleCode != null && this.moduleService.get(a) == null) {
            return "true";
        }
        return "false";
    }

    @RequiresPermissions(value={"sys:module:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated Module module) {
        if (!module.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", FileWatcher.break("\u8db1\u6728\u64f6\u4f37\uff37\u5381\u6732\u8dee\u7e9c\u7bca\u743d\u5433\u6276\u8096\u4fd5\u6552\u6b5f\u651b\u6355\uff6a"));
        }
        this.moduleService.save(module);
        return this.renderResult("true", NetInterfaceStat.break("\u4fa1\u5b14\u6a5d\u571b\u626c\u52d3\uff7d"));
    }

    @RequiresPermissions(value={"sys:module:view"})
    @RequestMapping(value={"form"})
    public String form(Module module, Model model) {
        if (StringUtils.isBlank((CharSequence)module.getMainClassName())) {
            module.setMainClassName(FileWatcher.break("\bT\u0006\u0015\u0001^\u000eH\u0002O\u000e\u0015\u0006T\u000fN\u0007^\u0018\u0015\u0018B\u0018\u0015\u001c^\t\u0015'T\fR\u0005x\u0004U\u001fI\u0004W\u0007^\u0019"));
        }
        model.addAttribute(NetInterfaceStat.break("!\u0013(\t \u0019"), (Object)module);
        return FileWatcher.break("V\u0004_\u001eW\u000eHDH\u0012HDV\u0004_\u001eW\u000e}\u0004I\u0006");
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:module:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public Page<Module> listData(Module module, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        void response;
        void request;
        void module2;
        module2.setPage(new Page((HttpServletRequest)request, (HttpServletResponse)response));
        return this.moduleService.findPage((Module)module2);
    }

    @RequiresPermissions(value={"sys:module:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(Module module) {
        if (!module.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", NetInterfaceStat.break("\u8dc6\u673f\u6481\u4f20\uff40\u5396\u6745\u8df9\u7eeb\u7bdd\u744a\u5424\u6201\u8081\u4fa2\u6545\u6b28\u650c\u6322\uff7d"));
        }
        if ("core".equals(module.getModuleCode())) {
            return this.renderResult("false", FileWatcher.break("\u6853\u5ff8\u6a4a\u576c\uff67\u4e36\u512a\u8b83\u79ea\u7513\uff6a"));
        }
        this.moduleService.delete(module);
        return this.renderResult("true", NetInterfaceStat.break("\u525c\u9628\u6a5d\u571b\u626c\u52d3\uff7d"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:module:view"})
    @RequestMapping(value={"list"})
    public String list(Module module, Model model) {
        void module2;
        module2.setStatus("");
        return FileWatcher.break("V\u0004_\u001eW\u000eHDH\u0012HDV\u0004_\u001eW\u000ew\u0002H\u001f");
    }

    @ModelAttribute
    public Module get(String moduleCode, boolean isNewRecord) {
        return (Module)this.moduleService.get(moduleCode, isNewRecord);
    }

    @RequiresPermissions(value={"sys:module:edit"})
    @RequestMapping(value={"enable"})
    @ResponseBody
    public String enable(Module module) {
        if (!module.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", NetInterfaceStat.break("\u8dc6\u673f\u6481\u4f20\uff40\u5396\u6745\u8df9\u7eeb\u7bdd\u744a\u5424\u6201\u8081\u4fa2\u6545\u6b28\u650c\u6322\uff7d"));
        }
        module.setStatus("0");
        ModuleController moduleController = this;
        moduleController.moduleService.updateStatus(module);
        return moduleController.renderResult("true", new StringBuilder().insert(0, FileWatcher.break("\u5414\u7543\u6a1a\u573c")).append(module.getModuleName()).append(NetInterfaceStat.break("\u625c\u52e3")).toString());
    }
}

