/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.jni;

import com.jeesite.modules.sys.utils.ConfigUtils;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import org.hyperic.jni.ArchLoaderException;
import org.hyperic.jni.ArchName;
import org.hyperic.jni.ArchNotSupportedException;
import org.hyperic.sigar.Tcp;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ArchLoader {
    public static final boolean IS_SOLARIS;
    private boolean loaded;
    public static final boolean IS_WIN32;
    private String jarName;
    private String packageName;
    private String name;
    public static final boolean IS_OSF1;
    private static final String osName;
    public static final boolean IS_NETWARE;
    private Object loadLock;
    private String resourcePath;
    public static final boolean IS_DARWIN;
    public static final boolean IS_HPUX;
    private Class loaderClass;
    public static final boolean IS_AIX;
    private String libName;
    public static final boolean IS_FREEBSD;
    private File nativeLibrary;
    public static final boolean IS_LINUX;
    private String version;

    public ArchLoader() {
        ArchLoader archLoader = this;
        ArchLoader archLoader2 = this;
        archLoader2.loadLock = new Object();
        archLoader.loaded = false;
        archLoader.libName = null;
    }

    public String getJarName() {
        return this.jarName;
    }

    public static String getLibraryExtension() {
        if (IS_WIN32) {
            return ConfigUtils.break("X\u0019\u001a\u0011");
        }
        if (IS_NETWARE) {
            return Tcp.break("Ar\u0003q");
        }
        if (IS_DARWIN) {
            return ConfigUtils.break("X\u0019\u000f\u0011\u001f\u001f");
        }
        if (IS_HPUX) {
            return Tcp.break("2\u001cp");
        }
        return ConfigUtils.break("S\u0005\u0012");
    }

    public String getVersionedLibraryName() {
        if (this.version == null) {
            return null;
        }
        try {
            this.getLibraryName();
        }
        catch (ArchNotSupportedException a) {
            return null;
        }
        String a = ArchLoader.getLibraryPrefix();
        String a2 = ArchLoader.getLibraryExtension();
        return new StringBuilder().insert(0, a).append(this.libName).append('-').append(this.version).append(a2).toString();
    }

    public String findJarPath(String libName) throws ArchLoaderException {
        return this.break(libName, true);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String path) throws ArchNotSupportedException, ArchLoaderException {
        Object object = this.loadLock;
        synchronized (object) {
            block4: {
                if (!this.loaded) break block4;
                return;
            }
            this.loadLibrary(path);
            this.loaded = true;
            return;
        }
    }

    public String getLibName() {
        return this.libName;
    }

    static {
        osName = System.getProperty(Tcp.break("s\u001c2\u0001}\u0002y"));
        IS_WIN32 = osName.startsWith(ConfigUtils.break("*\u001f\u0013\u0012\u0012\u0001\u000e"));
        IS_AIX = osName.equals("AIX");
        IS_HPUX = osName.equals(Tcp.break("T?1:D"));
        IS_SOLARIS = osName.equals(ConfigUtils.break(".\u0003\u00139."));
        IS_LINUX = osName.equals("Linux");
        IS_DARWIN = osName.equals(Tcp.break("\"}\f< OOD")) || osName.equals(ConfigUtils.break("2\u001c\u0004\n\u001f\u0013"));
        IS_OSF1 = osName.equals(Tcp.break(" O)-"));
        IS_FREEBSD = osName.equals("FreeBSD");
        IS_NETWARE = osName.equals("NetWare");
    }

    public void setJarName(String value) {
        this.jarName = value;
    }

    private /* synthetic */ String break(String a, boolean a2) throws ArchLoaderException {
        URL uRL;
        Object object;
        URL uRL2;
        String string;
        ArchLoader a3;
        block11: {
            if (a3.getJarName() == null) {
                throw new ArchLoaderException(ConfigUtils.break("\u0017\u0017\u000f8\u001c\u001b\u0018V\u0014\u0005]\u0018\b\u001a\u0011"));
            }
            ArchLoader archLoader = a3;
            string = archLoader.getResourcePath();
            ClassLoader classLoader = archLoader.getClassLoader();
            uRL2 = classLoader.getResource(string);
            if (!archLoader.break(uRL2)) {
                uRL2 = null;
            }
            if (uRL2 == null && classLoader instanceof URLClassLoader) {
                int n;
                object = ((URLClassLoader)classLoader).getURLs();
                int n2 = n = 0;
                while (n2 < ((URL[])object).length) {
                    if (a3.break(object[n])) {
                        uRL = uRL2 = object[n];
                        break block11;
                    }
                    n2 = ++n;
                }
            }
            uRL = uRL2;
        }
        if (uRL == null) {
            if (a2) {
                throw new ArchLoaderException(new StringBuilder().insert(0, Tcp.break("I\u0001}\rp\n<\u001bsOz\u0006r\u000b<")).append(a3.getJarName()).toString());
            }
            return null;
        }
        string = uRL2.getFile();
        if (string.startsWith(ConfigUtils.break("\u001b\u001f\u0011\u0013G"))) {
            string = string.substring(5);
        }
        object = new File(string);
        String string2 = a3.getJarName();
        Object object2 = object;
        while (object2 != null && !((File)object).getName().startsWith(string2)) {
            object2 = ((File)object).getParentFile();
        }
        if (a == null) {
            a = string2;
        }
        if (object != null && (object = ((File)object).getParentFile()) != null && a3.findNativeLibrary(a2 = URLDecoder.decode(((File)object).toString()), a)) {
            return a2;
        }
        return null;
    }

    protected boolean containsNativeLibrary(File dir, String name) {
        if (name == null) {
            return false;
        }
        File a = new File(dir, name);
        if (a.exists()) {
            this.nativeLibrary = a;
            return true;
        }
        return false;
    }

    public void load() throws ArchNotSupportedException, ArchLoaderException {
        this.load(null);
    }

    public void setLibName(String value) {
        this.libName = value;
    }

    public ClassLoader getClassLoader() {
        return this.getLoaderClass().getClassLoader();
    }

    private /* synthetic */ boolean break(URL a) {
        ArchLoader a2;
        String string;
        if (a == null) {
            return false;
        }
        if (((String)(a = ((URL)a).getFile())).indexOf(string = a2.getJarName()) != -1) {
            return true;
        }
        int n = string.indexOf(".jar");
        if (n != -1) {
            if ((n = ((String)a).lastIndexOf(string = new StringBuilder().insert(0, string.substring(0, n)).append(Tcp.break("1")).toString())) != -1) {
                string = ((String)a).substring(n);
                if ((n = string.indexOf(".jar")) == -1) {
                    return false;
                }
                String string2 = string;
                a2.version = string2.substring(string.indexOf(45) + 1, n);
                string = string2.substring(0, n + 4);
                a2.setJarName(string);
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean findNativeLibrary(String dir, String name) {
        File a = new File(dir).getAbsoluteFile();
        if (this.containsNativeLibrary(a, name)) {
            return true;
        }
        if (this.containsNativeLibrary(a, this.getVersionedLibraryName())) {
            return true;
        }
        return this.containsNativeLibrary(a, ArchLoader.getLibraryPrefix() + this.getName() + ArchLoader.getLibraryExtension());
    }

    protected void systemLoadLibrary(String name) {
        System.loadLibrary(name);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String value) {
        this.packageName = value;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getLibraryName() throws ArchNotSupportedException {
        String a = this.getLibName();
        if (a == null) {
            ArchLoader archLoader = this;
            a = archLoader.getDefaultLibName();
            archLoader.setLibName(a);
        }
        String a2 = ArchLoader.getLibraryPrefix();
        String a3 = ArchLoader.getLibraryExtension();
        return new StringBuilder().insert(0, a2).append(a).append(a3).toString();
    }

    public String getDefaultLibName() throws ArchNotSupportedException {
        return System.getProperty(new StringBuilder().insert(0, this.getPackageName()).append(ConfigUtils.break("X\u0011\u001f\u001f\u0018\u001c\u001b\u0018")).toString(), new StringBuilder().insert(0, Tcp.break("\u0005}\u0019}")).append(this.getArchLibName()).toString());
    }

    public ArchLoader(Class loaderClass) {
        ArchLoader archLoader = this;
        ArchLoader archLoader2 = this;
        ArchLoader archLoader3 = this;
        ArchLoader archLoader4 = this;
        archLoader4.loadLock = new Object();
        archLoader3.loaded = false;
        archLoader3.libName = null;
        archLoader2.setLoaderClass(loaderClass);
        String a = loaderClass.getName();
        int a2 = a.lastIndexOf(".");
        a = a.substring(0, a2);
        archLoader2.setPackageName(a);
        String string = a;
        a2 = string.lastIndexOf(".");
        archLoader.setName(string.substring(a2 + 1));
        ArchLoader archLoader5 = this;
        archLoader5.setJarName(new StringBuilder().insert(0, archLoader5.getName()).append(".jar").toString());
        archLoader.setResourcePath(archLoader.break(a));
    }

    public Class getLoaderClass() {
        return this.loaderClass;
    }

    public static String getLibraryPrefix() {
        if (IS_WIN32 || IS_NETWARE) {
            return "";
        }
        return ConfigUtils.break("\u0011\u001f\u001f");
    }

    private /* synthetic */ String break(String a) {
        int n;
        a = new StringBuffer((String)a);
        int n2 = n = 0;
        while (n2 < ((StringBuffer)a).length()) {
            if (((StringBuffer)a).charAt(n) == '.') {
                ((StringBuffer)a).setCharAt(n, '/');
            }
            n2 = ++n;
        }
        return ((StringBuffer)a).toString();
    }

    protected void systemLoad(String name) {
        System.load(name);
    }

    protected boolean findInJavaLibraryPath(String libName) {
        String a = System.getProperty(Tcp.break("v\u000ej\u000e2\u0003u\rn\u000en\u00162\u001f}\u001bt"), "");
        StringTokenizer a2 = new StringTokenizer(a, File.pathSeparator);
        while (a2.hasMoreTokens()) {
            a = a2.nextToken();
            if (!this.findNativeLibrary(a, libName)) continue;
            return true;
        }
        return false;
    }

    public String getArchLibName() throws ArchNotSupportedException {
        return new StringBuilder().insert(0, this.getName()).append(ConfigUtils.break("P")).append(ArchName.getName()).toString();
    }

    public void setLoaderClass(Class value) {
        this.loaderClass = value;
    }

    public void setResourcePath(String value) {
        this.resourcePath = value;
    }

    public File getNativeLibrary() {
        return this.nativeLibrary;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadLibrary(String path) throws ArchNotSupportedException, ArchLoaderException {
        try {
            ArchLoader archLoader;
            String a = this.getLibraryName();
            if (path == null) {
                path = System.getProperty(new StringBuilder().insert(0, this.getPackageName()).append(Tcp.break("2\u001f}\u001bt")).toString());
            }
            if (path != null) {
                if (path.equals(ConfigUtils.break("P"))) {
                    return;
                }
                ArchLoader archLoader2 = this;
                archLoader = archLoader2;
                archLoader2.break(null, false);
                this.findNativeLibrary(path, a);
            } else {
                if (this.break(a, false) == null) {
                    this.findInJavaLibraryPath(a);
                }
                archLoader = this;
            }
            ArchLoader archLoader3 = this;
            if (archLoader.nativeLibrary != null) {
                archLoader3.systemLoad(this.nativeLibrary.toString());
                return;
            }
            archLoader3.systemLoadLibrary(a);
            return;
        }
        catch (RuntimeException a) {
            String a2 = a.getMessage();
            if (a2 == null) {
                a2 = a.getClass().getName();
            }
            String a3 = new StringBuilder().insert(0, Tcp.break("Z\u000eu\u0003y\u000b<\u001bsOp\u0000}\u000b<")).append(this.libName).append(ConfigUtils.break("L]")).append(a2).toString();
            throw new ArchLoaderException(a3);
        }
    }
}

