/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.DirUsage;
import org.hyperic.sigar.NfsServerV2;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ThreadCpu;
import org.hyperic.sigar.jmx.CpuTimerMBean;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CpuTimer
implements CpuTimerMBean {
    private static final Map timers = Collections.synchronizedMap(new HashMap());
    private long totalTime;
    private long cpuSampleTime;
    private long stopTime;
    private long startTime;
    private long cpuSampleFirst;
    private Sigar sigar;
    private long cpuSys;
    private long cpuSampleLast;
    private long cpuUser;
    private ThreadCpu cpu;
    private long cpuTotal;

    public String format(long elap) {
        String a = elap % 1000L + "";
        int a2 = 3 - a.length();
        StringBuffer a3 = new StringBuffer().append(elap / 1000L).append('.');
        int n = a2;
        while (true) {
            --a2;
            if (n <= 0) break;
            n = a2;
            a3.append("0");
        }
        StringBuffer stringBuffer = a3;
        stringBuffer.append(a).append(NfsServerV2.break("p\u001b5\u000b?\u00064\u001b"));
        return stringBuffer.toString();
    }

    @Override
    public long getTotalTime() {
        return this.totalTime;
    }

    public ThreadCpu getDiff() {
        CpuTimer cpuTimer = this;
        return cpuTimer.getDiff(cpuTimer.sigar);
    }

    @Override
    public long getLastSampleTime() {
        return this.stopTime;
    }

    public void list(PrintStream out) {
        PrintStream printStream = out;
        CpuTimer cpuTimer = this;
        printStream.println(DirUsage.break("2\u0010!\u0019n[n[n") + cpuTimer.format(cpuTimer.getTotalTime()));
        CpuTimer cpuTimer2 = this;
        out.println(new StringBuilder().insert(0, NfsServerV2.break("\u001d#\r\"F~F~F")).append(cpuTimer2.format(cpuTimer2.getCpuUser())).toString());
        CpuTimer cpuTimer3 = this;
        printStream.println(new StringBuilder().insert(0, DirUsage.break("3\f3[n[n[n")).append(cpuTimer3.format(cpuTimer3.getCpuSys())).toString());
        printStream.println(new StringBuilder().insert(0, NfsServerV2.break("\u001d#\t7\r~F~F")).append(CpuPerc.format(this.getCpuUsage())).toString());
    }

    public ThreadCpu getDiff(Sigar sigar) {
        CpuTimer cpuTimer = this;
        long a = cpuTimer.cpu.total;
        long a2 = cpuTimer.cpu.user;
        long a3 = cpuTimer.cpu.sys;
        ThreadCpu a4 = new ThreadCpu();
        try {
            this.cpu.gather(sigar, 0L);
        }
        catch (SigarException a5) {
            throw new IllegalArgumentException(a5.toString());
        }
        a4.total = this.cpu.total - a;
        CpuTimer cpuTimer2 = this;
        CpuTimer cpuTimer3 = this;
        a4.user = cpuTimer3.cpu.user - a2;
        a4.sys = cpuTimer3.cpu.sys - a3;
        cpuTimer2.break(cpuTimer2);
        return a4;
    }

    public void clear() {
        CpuTimer cpuTimer = this;
        CpuTimer cpuTimer2 = this;
        CpuTimer cpuTimer3 = this;
        CpuTimer cpuTimer4 = this;
        this.startTime = -1L;
        cpuTimer4.stopTime = -1L;
        cpuTimer4.totalTime = 0L;
        cpuTimer3.cpuTotal = 0L;
        cpuTimer3.cpuUser = 0L;
        cpuTimer2.cpuSys = 0L;
        cpuTimer2.cpuSampleFirst = 0L;
        cpuTimer.cpuSampleLast = 0L;
        cpuTimer.cpuSampleTime = 0L;
    }

    public void stop(Sigar sigar) {
        CpuTimer cpuTimer = this;
        ThreadCpu a = cpuTimer.getDiff(sigar);
        cpuTimer.cpuTotal += a.total;
        cpuTimer.cpuUser += a.user;
        cpuTimer.cpuSys += a.sys;
        cpuTimer.stopTime = System.currentTimeMillis();
        double a2 = cpuTimer.stopTime - this.startTime;
        cpuTimer.totalTime = (long)((double)cpuTimer.totalTime + a2);
    }

    public CpuTimer(Sigar sigar) {
        CpuTimer cpuTimer = this;
        this.cpu = new ThreadCpu();
        this.clear();
        this.sigar = sigar;
    }

    public void start() {
        CpuTimer cpuTimer = this;
        cpuTimer.start(cpuTimer.sigar);
    }

    public void add(CpuTimer timer) {
        CpuTimer cpuTimer = this;
        cpuTimer.break(timer);
        cpuTimer.cpuTotal += timer.cpuTotal;
        cpuTimer.cpuUser += timer.cpuUser;
        cpuTimer.cpuSys += timer.cpuSys;
        cpuTimer.totalTime += timer.totalTime;
    }

    @Override
    public long getCpuTotal() {
        CpuTimer cpuTimer = this;
        return cpuTimer.break(cpuTimer.cpuTotal);
    }

    public CpuTimer() {
        this(null);
    }

    @Override
    public long getCpuSys() {
        CpuTimer cpuTimer = this;
        return cpuTimer.break(cpuTimer.cpuSys);
    }

    public void start(Sigar sigar) {
        this.startTime = System.currentTimeMillis();
        try {
            this.cpu.gather(sigar, 0L);
        }
        catch (SigarException a) {
            throw new IllegalArgumentException(a.toString());
        }
        this.break(this);
    }

    private /* synthetic */ void break(CpuTimer a) {
        CpuTimer a2;
        if (a2.cpuSampleFirst == 0L) {
            a2.cpuSampleFirst = a2.break(a.cpu.total);
            a2.cpuSampleTime = a.startTime;
            return;
        }
        a2.cpuSampleLast = a2.break(a.cpu.total);
    }

    public static CpuTimer getInstance(String name) {
        CpuTimer a = (CpuTimer)timers.get(name);
        if (a == null) {
            a = new CpuTimer();
            timers.put(name, a);
        }
        return a;
    }

    private /* synthetic */ long break(long a) {
        return a / 1000000L;
    }

    public void stop() {
        CpuTimer cpuTimer = this;
        cpuTimer.stop(cpuTimer.sigar);
    }

    @Override
    public long getCpuUser() {
        CpuTimer cpuTimer = this;
        return cpuTimer.break(cpuTimer.cpuUser);
    }

    @Override
    public double getCpuUsage() {
        if (this.cpuSampleFirst == 0L || this.cpuSampleLast == 0L) {
            return 0.0;
        }
        double a = System.currentTimeMillis() - this.cpuSampleTime;
        if (a == 0.0) {
            return 0.0;
        }
        double a2 = (double)(this.cpuSampleLast - this.cpuSampleFirst) / a;
        this.cpuSampleFirst = 0L;
        this.cpuSampleLast = 0L;
        this.cpuSampleTime = 0L;
        return a2;
    }
}

