/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.hyperic.sigar.C;
import org.hyperic.sigar.DirStat;
import org.hyperic.sigar.FileAttrs;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.NfsClientV3;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarFileNotFoundException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileInfo
extends FileAttrs
implements Serializable {
    public static final int TYPE_CHR = 3;
    private boolean lstat;
    public static final int MODE_UWRITE = 512;
    public static final int MODE_WREAD = 4;
    public static final int TYPE_SOCK = 7;
    private transient Sigar sigar;
    public static final int MODE_WWRITE = 2;
    public static final int TYPE_UNKFILE = 8;
    public static final int MODE_UREAD = 1024;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(Mem.break("\u0006:\u0006W/\u0013k?\u0003M&\u001a"));
    private DirStat stat;
    public static final int MODE_WEXECUTE = 1;
    public static final int TYPE_DIR = 2;
    private boolean dirStatEnabled;
    public static final int MODE_UEXECUTE = 256;
    public static final int TYPE_BLK = 4;
    private static final long serialVersionUID = 607239L;
    public static final int MODE_GEXECUTE = 16;
    private FileInfo oldInfo;
    public static final int TYPE_LNK = 6;
    String name;
    public static final int TYPE_REG = 1;
    public static final int MODE_GREAD = 64;
    public static final int TYPE_PIPE = 5;
    public static final int TYPE_NOFILE = 0;
    public static final int MODE_GWRITE = 32;

    public String diff(DirStat stat) {
        DirStat a = this.stat;
        ArrayList<C> a2 = new ArrayList<C>();
        if (a.files != stat.files) {
            a2.add(new C(this, NfsClientV3.break("2\b\u0018\u0004\u0007"), stat.getFiles(), a.getFiles()));
        }
        if (a.subdirs != stat.subdirs) {
            a2.add(new C(this, Mem.break("$>\u0015/\u001e9\u0004"), stat.getSubdirs(), a.getSubdirs()));
        }
        if (a.symlinks != stat.symlinks) {
            a2.add(new C(this, NfsClientV3.break("2\r\f\u0018\b\u001a\n\u0007"), stat.getSymlinks(), a.getSymlinks()));
        }
        if (a.chrdevs != stat.chrdevs) {
            a2.add(new C(this, Mem.break("4#\u0005/\u0012=\u0004"), stat.getChrdevs(), a.getChrdevs()));
        }
        if (a.blkdevs != stat.blkdevs) {
            a2.add(new C(this, NfsClientV3.break("6\r\u001f\u0005\u0011\u0017\u0007"), stat.getBlkdevs(), a.getBlkdevs()));
        }
        if (a.sockets != stat.sockets) {
            a2.add(new C(this, Mem.break("$$\u0014 \u0012?\u0004"), stat.getSockets(), a.getSockets()));
        }
        if (a.total != stat.total) {
            a2.add(new C(this, NfsClientV3.break(" \u000e\u0000\u0000\u0018"), stat.getTotal(), a.getTotal()));
        }
        return this.break(a2).toString();
    }

    private static native /* synthetic */ String getTypeString(int var0);

    static FileInfo else(Sigar a, String a2) throws SigarException {
        return FileInfo.break(a, a2, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public char getTypeChar() {
        switch (this.type) {
            case 2: {
                return 'd';
            }
            case 3: {
                return 'c';
            }
            case 4: {
                return 'b';
            }
            case 5: {
                return 'p';
            }
            case 6: {
                return 'l';
            }
            case 7: {
                return 's';
            }
        }
        return '-';
    }

    private /* synthetic */ StringBuffer break(ArrayList a) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (a.size() == 0) {
            return stringBuffer;
        }
        int n2 = a.size();
        int n3 = n = 0;
        while (n3 < n2) {
            Object e2 = a.get(n);
            stringBuffer.append('{').append(e2).append('}');
            n3 = ++n;
        }
        return stringBuffer;
    }

    static FileInfo break(Sigar a, String a2) throws SigarException {
        return FileInfo.break(a, a2, false);
    }

    public int getMode() {
        return FileInfo.getMode(this.permissions);
    }

    public String getName() {
        return this.name;
    }

    public FileInfo() {
        FileInfo fileInfo = this;
        this.dirStatEnabled = false;
        fileInfo.stat = null;
        fileInfo.oldInfo = null;
    }

    native void gatherLink(Sigar var1, String var2) throws SigarException;

    public String diff(FileInfo info) {
        FileInfo fileInfo;
        ArrayList<C> a = new ArrayList<C>();
        if (this.getMtime() != info.getMtime()) {
            fileInfo = this;
            FileInfo fileInfo2 = this;
            a.add(new C(fileInfo2, Mem.break(":?\u001e&\u0012"), FileInfo.DATE_FORMAT.format(new Date(info.getMtime())), FileInfo.DATE_FORMAT.format(new Date(fileInfo2.getMtime()))));
        } else if (this.getCtime() != info.getCtime()) {
            fileInfo = this;
            FileInfo fileInfo3 = this;
            a.add(new C(fileInfo3, NfsClientV3.break("7\u0015\u001d\f\u0011"), FileInfo.DATE_FORMAT.format(new Date(info.getCtime())), FileInfo.DATE_FORMAT.format(new Date(fileInfo3.getCtime()))));
        } else {
            return "";
        }
        if (fileInfo.getPermissions() != info.getPermissions()) {
            FileInfo fileInfo4 = this;
            a.add(new C(fileInfo4, Mem.break("'.\u0005&\u0004"), info.getPermissionsString(), fileInfo4.getPermissionsString()));
        }
        if (this.getType() != info.getType()) {
            FileInfo fileInfo5 = this;
            a.add(new C(fileInfo5, "Type", info.getTypeString(), fileInfo5.getTypeString()));
        }
        if (this.getUid() != info.getUid()) {
            a.add(new C(this, NfsClientV3.break("!\b\u0010"), info.getUid(), this.getUid()));
        }
        if (this.getGid() != info.getGid()) {
            a.add(new C(this, Mem.break("0\"\u0013"), info.getGid(), this.getGid()));
        }
        if (this.getSize() != info.getSize()) {
            a.add(new C(this, NfsClientV3.break("2\u001d\u001b\u0011"), info.getSize(), this.getSize()));
        }
        if (!OperatingSystem.IS_WIN32) {
            if (this.getInode() != info.getInode()) {
                a.add(new C(this, Mem.break(">%\u0018/\u0012"), info.getInode(), this.getInode()));
            }
            if (this.getDevice() != info.getDevice()) {
                a.add(new C(this, NfsClientV3.break("%\u0011\u0017\u001d\u0002\u0011"), info.getDevice(), this.getDevice()));
            }
            if (this.getNlink() != info.getNlink()) {
                a.add(new C(this, Mem.break("9'\u001e%\u001c"), info.getNlink(), this.getNlink()));
            }
        }
        FileInfo fileInfo6 = this;
        StringBuffer a2 = fileInfo6.break(a);
        if (fileInfo6.dirStatEnabled) {
            a2.append(this.diff(info.stat));
        }
        return a2.toString();
    }

    public FileInfo getPreviousInfo() {
        return this.oldInfo;
    }

    public String getTypeString() {
        return FileInfo.getTypeString(this.type);
    }

    public boolean equals(Object o) {
        return o.equals(this.name);
    }

    public String getPermissionsString() {
        return FileInfo.getPermissionsString(this.permissions);
    }

    private static /* synthetic */ FileInfo break(Sigar a, String a2, boolean a32) throws SigarException {
        FileInfo fileInfo;
        block3: {
            fileInfo = new FileInfo();
            try {
                if (!a32) break block3;
                fileInfo.gather(a, a2);
                fileInfo.lstat = false;
            }
            catch (SigarException a32) {
                SigarException sigarException = a32;
                sigarException.break(a2 + NfsClientV3.break("[T") + a32.getMessage());
                throw sigarException;
            }
        }
        fileInfo.gatherLink(a, a2);
        fileInfo.lstat = true;
        FileInfo fileInfo2 = fileInfo;
        fileInfo2.sigar = a;
        fileInfo2.name = a2;
        return fileInfo;
    }

    private static native /* synthetic */ int getMode(long var0);

    public void enableDirStat(boolean value) {
        this.dirStatEnabled = value;
        if (this.dirStatEnabled) {
            block5: {
                if (this.type != 2) {
                    throw new IllegalArgumentException(new StringBuilder().insert(0, this.name).append(NfsClientV3.break("T\b\u0007A\u001a\u000e\u0000A\u0015A\u0010\b\u0006\u0004\u0017\u0015\u001b\u0013\r")).toString());
                }
                if (this.stat != null) break block5;
                this.stat = this.sigar.getDirStat(this.name);
                return;
            }
            try {
                FileInfo fileInfo = this;
                fileInfo.stat.gather(fileInfo.sigar, this.name);
                return;
            }
            catch (SigarException sigarException) {
                // empty catch block
            }
        }
    }

    public boolean changed() throws SigarException, SigarFileNotFoundException {
        return this.modified() || this.ctime != this.oldInfo.ctime;
    }

    public void stat() throws SigarException, SigarFileNotFoundException {
        FileInfo fileInfo;
        FileInfo fileInfo2 = this;
        long a = fileInfo2.mtime;
        if (fileInfo2.lstat) {
            FileInfo fileInfo3 = this;
            FileInfo fileInfo4 = this;
            fileInfo = fileInfo4;
            fileInfo3.gatherLink(fileInfo3.sigar, fileInfo4.name);
        } else {
            FileInfo fileInfo5 = this;
            fileInfo = fileInfo5;
            FileInfo fileInfo6 = this;
            fileInfo6.gather(fileInfo5.sigar, fileInfo6.name);
        }
        if (fileInfo.dirStatEnabled && a != this.mtime) {
            FileInfo fileInfo7 = this;
            fileInfo7.stat.gather(fileInfo7.sigar, this.name);
        }
    }

    private static native /* synthetic */ String getPermissionsString(long var0);

    public String diff() {
        if (this.oldInfo == null) {
            return "";
        }
        FileInfo fileInfo = this;
        return fileInfo.diff(fileInfo.oldInfo);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean modified() throws SigarException, SigarFileNotFoundException {
        if (this.oldInfo == null) {
            this.oldInfo = new FileInfo();
            if (this.dirStatEnabled) {
                this.oldInfo.stat = new DirStat();
            }
        }
        FileInfo fileInfo = this;
        fileInfo.break(fileInfo.oldInfo);
        if (fileInfo.dirStatEnabled) {
            FileInfo fileInfo2 = this;
            fileInfo2.stat.break(fileInfo2.oldInfo.stat);
        }
        FileInfo fileInfo3 = this;
        fileInfo3.stat();
        return fileInfo3.mtime != this.oldInfo.mtime;
    }
}

