/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import org.hyperic.jni.ArchLoader;
import org.hyperic.jni.ArchLoaderException;
import org.hyperic.jni.ArchName;
import org.hyperic.jni.ArchNotSupportedException;
import org.hyperic.sigar.FileWatcher;
import org.hyperic.sigar.Sigar;

public class SigarLoader
extends ArchLoader {
    private static String nativeName;
    public static final String PROP_SIGAR_JAR_NAME = "sigar.jar.name";
    private static String location;

    @Override
    public String getDefaultLibName() throws ArchNotSupportedException {
        return this.getArchLibName();
    }

    @Override
    public String getJarName() {
        return System.getProperty(PROP_SIGAR_JAR_NAME, super.getJarName());
    }

    static {
        location = null;
        nativeName = null;
    }

    public SigarLoader(Class loaderClass) {
        super(loaderClass);
    }

    @Override
    public String getArchLibName() throws ArchNotSupportedException {
        return new StringBuilder().insert(0, this.getName()).append(FileWatcher.break("F")).append(ArchName.getName()).toString();
    }

    public static void setSigarJarName(String jarName) {
        System.setProperty(PROP_SIGAR_JAR_NAME, jarName);
    }

    @Override
    protected void systemLoad(String name) {
        System.load(name);
    }

    public static synchronized String getNativeLibraryName() {
        if (nativeName == null) {
            SigarLoader a = new SigarLoader(Sigar.class);
            try {
                nativeName = a.getLibraryName();
            }
            catch (ArchNotSupportedException a2) {
                nativeName = null;
            }
        }
        return nativeName;
    }

    @Override
    protected void systemLoadLibrary(String name) {
        System.loadLibrary(name);
    }

    public static synchronized String getLocation() {
        if (location == null) {
            SigarLoader a = new SigarLoader(Sigar.class);
            try {
                location = a.findJarPath(SigarLoader.getSigarJarName());
            }
            catch (ArchLoaderException a2) {
                location = ".";
            }
        }
        return location;
    }

    public static String getSigarJarName() {
        return System.getProperty(PROP_SIGAR_JAR_NAME);
    }
}

