/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import com.jeesite.autoconfigure.sys.FileAutoConfiguration;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.hyperic.sigar.FileWatcher;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarLoader;
import org.hyperic.sigar.SigarPermissionDeniedException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.cmd.CpuInfo;
import org.hyperic.sigar.cmd.Df;
import org.hyperic.sigar.cmd.Du;
import org.hyperic.sigar.cmd.FileVersionInfo;
import org.hyperic.sigar.cmd.Free;
import org.hyperic.sigar.cmd.Ifconfig;
import org.hyperic.sigar.cmd.Iostat;
import org.hyperic.sigar.cmd.Kill;
import org.hyperic.sigar.cmd.Ls;
import org.hyperic.sigar.cmd.MultiPs;
import org.hyperic.sigar.cmd.NetInfo;
import org.hyperic.sigar.cmd.Netstat;
import org.hyperic.sigar.cmd.Nfsstat;
import org.hyperic.sigar.cmd.Pidof;
import org.hyperic.sigar.cmd.ProcFileInfo;
import org.hyperic.sigar.cmd.ProcInfo;
import org.hyperic.sigar.cmd.ProcModuleInfo;
import org.hyperic.sigar.cmd.Ps;
import org.hyperic.sigar.cmd.Route;
import org.hyperic.sigar.cmd.ShowArgs;
import org.hyperic.sigar.cmd.ShowEnv;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.cmd.SysInfo;
import org.hyperic.sigar.cmd.Time;
import org.hyperic.sigar.cmd.Ulimit;
import org.hyperic.sigar.cmd.Uptime;
import org.hyperic.sigar.cmd.Version;
import org.hyperic.sigar.cmd.Who;
import org.hyperic.sigar.cmd.Win32Service;
import org.hyperic.sigar.ptql.ProcessFinder;
import org.hyperic.sigar.shell.ShellBase;
import org.hyperic.sigar.shell.ShellCommandExecException;
import org.hyperic.sigar.shell.ShellCommandHandler;
import org.hyperic.sigar.shell.ShellCommandInitException;
import org.hyperic.sigar.shell.ShellCommandUsageException;
import org.hyperic.sigar.util.Getline;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Shell
extends ShellBase {
    private static final String CLEAR_SCREEN = "\u001b[2J";
    private long[] foundPids;
    public static final String RCFILE_NAME = ".sigar_shellrc";
    private boolean isInteractive;
    private SigarProxy proxy;
    private Sigar sigar;

    public Shell() {
        Shell shell = this;
        this.sigar = new Sigar();
        this.proxy = SigarProxyCache.newInstance(this.sigar);
        shell.foundPids = new long[0];
        shell.isInteractive = false;
    }

    public static void main(String[] args) {
        Shell a = new Shell();
        try {
            Shell shell;
            if (args.length == 0) {
                a.isInteractive = true;
            }
            Shell shell2 = a;
            Shell shell3 = a;
            Shell shell4 = a;
            shell4.init("sigar", System.out, System.err);
            shell4.registerCommands();
            shell3.readCommandFile(System.getProperty(FileWatcher.break("\u001eH\u000eIES\u0004V\u000e")));
            shell2.readCommandFile(".");
            shell3.readCommandFile(SigarLoader.getLocation());
            if (shell2.isInteractive) {
                Shell shell5 = a;
                shell = shell5;
                shell5.initHistory();
                Getline.setCompleter(shell5);
                shell5.run();
            } else {
                a.handleCommand(null, args);
                shell = a;
            }
            shell.shutdown();
            return;
        }
        catch (Exception a2) {
            System.err.println(new StringBuilder().insert(0, FileAutoConfiguration.break("R\u0019b\u000fw\u0012d\u0003b\u0013'\u0012\u007f\u0014b\u0007s\u001eh\u0019=W")).append(a2).toString());
            return;
        }
        finally {
            a.shutdown();
        }
    }

    @Override
    public void processCommand(ShellCommandHandler handler, String[] args) throws ShellCommandUsageException, ShellCommandExecException {
        try {
            super.processCommand(handler, args);
            if (handler instanceof SigarCommandBase) {
                ((SigarCommandBase)handler).flush();
            }
            return;
        }
        finally {
            SigarProxyCache.clear(this.proxy);
        }
    }

    public boolean isInteractive() {
        return this.isInteractive;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long[] getPids(SigarProxy sigar, String[] args) throws SigarException {
        int a;
        switch (args.length) {
            case 0: {
                long[] lArray = new long[1];
                lArray[0] = sigar.getPid();
                long[] a2 = lArray;
                return lArray;
            }
            case 1: {
                if (args[0].indexOf(FileWatcher.break("V")) > 0) {
                    return ProcessFinder.find(sigar, args[0]);
                }
                if (args[0].equals(FileAutoConfiguration.break("#S"))) {
                    long[] lArray = new long[1];
                    lArray[0] = sigar.getPid();
                    long[] a3 = lArray;
                    return lArray;
                }
                long[] lArray = new long[1];
                lArray[0] = Long.parseLong(args[0]);
                long[] a4 = lArray;
                return lArray;
            }
        }
        long[] a5 = new long[args.length];
        int n = a = 0;
        while (n < args.length) {
            int n2 = a++;
            a5[n2] = Long.parseLong(args[n2]);
            n = a;
        }
        return a5;
    }

    public void setInteractive(boolean value) {
        this.isInteractive = value;
    }

    public String getUserDeniedMessage(long pid) {
        return SigarPermissionDeniedException.getUserDeniedMessage(this.proxy, pid);
    }

    public static void clearScreen() {
        System.out.print(CLEAR_SCREEN);
    }

    public Sigar getSigar() {
        return this.sigar;
    }

    public void readCommandFile(String dir) {
        try {
            File a = new File(dir, RCFILE_NAME);
            Shell shell = this;
            shell.readRCFile(a, false);
            if (shell.isInteractive && Getline.isTTY()) {
                this.out.println(new StringBuilder().insert(0, FileWatcher.break("w\u0004Z\u000f^\u000f\u001b\u0019XK]\u0002W\u000e\u0001K")).append(a).toString());
                return;
            }
        }
        catch (IOException a) {
            // empty catch block
        }
    }

    public void registerCommands() throws ShellCommandInitException {
        Shell shell = this;
        Shell shell2 = this;
        Shell shell3 = this;
        Shell shell4 = this;
        Shell shell5 = this;
        Shell shell6 = this;
        Shell shell7 = this;
        Shell shell8 = this;
        Shell shell9 = this;
        Shell shell10 = this;
        Shell shell11 = this;
        Shell shell12 = this;
        Shell shell13 = this;
        shell13.registerCommandHandler(FileAutoConfiguration.break("c\u0011"), new Df(this));
        shell13.registerCommandHandler(FileWatcher.break("_\u001e"), new Du(this));
        shell12.registerCommandHandler(FileAutoConfiguration.break("k\u0004"), new Ls(this));
        shell12.registerCommandHandler(FileWatcher.break("R\u0004H\u001fZ\u001f"), new Iostat(this));
        shell11.registerCommandHandler(FileAutoConfiguration.break("a\u0005b\u0012"), new Free(this));
        shell11.registerCommandHandler(FileWatcher.break("\u001bZ\u0019\\\u0018"), new ShowArgs(this));
        shell10.registerCommandHandler(FileAutoConfiguration.break("w\u0012i\u0001"), new ShowEnv(this));
        shell10.registerCommandHandler(FileWatcher.break("\u001b]\u0002W\u000e"), new ProcFileInfo(this));
        shell9.registerCommandHandler(FileAutoConfiguration.break("w\u001ah\u0013r\u001bb\u0004"), new ProcModuleInfo(this));
        shell9.registerCommandHandler(FileWatcher.break("\u001bR\u0005]\u0004"), new ProcInfo(this));
        shell8.registerCommandHandler(FileAutoConfiguration.break("\u0014w\u0002n\u0019a\u0018"), new CpuInfo(this));
        shell8.registerCommandHandler(FileWatcher.break("R\rX\u0004U\rR\f"), new Ifconfig(this));
        shell7.registerCommandHandler(FileAutoConfiguration.break("r\u0007s\u001ej\u0012"), new Uptime(this));
        shell7.registerCommandHandler(FileWatcher.break("K\u0018"), new Ps(this));
        shell6.registerCommandHandler(FileAutoConfiguration.break("\u0007n\u0013h\u0011"), new Pidof(this));
        shell6.registerCommandHandler(FileWatcher.break("P\u0002W\u0007"), new Kill(this));
        shell5.registerCommandHandler(FileAutoConfiguration.break("\u0019b\u0003t\u0003f\u0003"), new Netstat(this));
        shell5.registerCommandHandler(FileWatcher.break("\u0005^\u001fR\u0005]\u0004"), new NetInfo(this));
        shell4.registerCommandHandler(FileAutoConfiguration.break("\u0019a\u0004t\u0003f\u0003"), new Nfsstat(this));
        shell4.registerCommandHandler(FileWatcher.break("\u0019T\u001eO\u000e"), new Route(this));
        shell3.registerCommandHandler(FileAutoConfiguration.break("\u0001b\u0005t\u001eh\u0019"), new Version(this));
        shell3.registerCommandHandler(FileWatcher.break("\u0006K\u0018"), new MultiPs(this));
        shell2.registerCommandHandler(FileAutoConfiguration.break("\u0004~\u0004n\u0019a\u0018"), new SysInfo(this));
        shell2.registerCommandHandler(FileWatcher.break("O\u0002V\u000e"), new Time(this));
        shell.registerCommandHandler(FileAutoConfiguration.break("r\u001bn\u001an\u0003"), new Ulimit(this));
        shell.registerCommandHandler(FileWatcher.break("\u001cS\u0004"), new Who(this));
        if (SigarLoader.IS_WIN32) {
            Shell shell14 = this;
            shell14.registerCommandHandler(FileAutoConfiguration.break("\u0004b\u0005q\u001ed\u0012"), new Win32Service(this));
            shell14.registerCommandHandler(FileWatcher.break("]\u001d^\u0019H\u0002T\u0005"), new FileVersionInfo(this));
        }
        try {
            this.break(FileAutoConfiguration.break("s\u0012t\u0003"), "org.hyperic.sigar.test.SigarTestRunner");
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private /* synthetic */ void break(String a, String a2) throws Exception {
        Shell a3;
        Class[] classArray = new Class[1];
        classArray[0] = a3.getClass();
        a2 = Class.forName((String)a2).getConstructor(classArray);
        Object[] objectArray = new Object[1];
        objectArray[0] = a3;
        a3.registerCommandHandler(a, (ShellCommandHandler)((Constructor)a2).newInstance(objectArray));
    }

    public SigarProxy getSigarProxy() {
        return this.proxy;
    }

    public long[] findPids(String[] args) throws SigarException {
        if (args.length == 1 && args[0].equals(FileWatcher.break("F"))) {
            return this.foundPids;
        }
        Shell shell = this;
        shell.foundPids = Shell.getPids(shell.proxy, args);
        return shell.foundPids;
    }

    public long[] findPids(String query) throws SigarException {
        String[] stringArray = new String[1];
        stringArray[0] = query;
        return this.findPids(stringArray);
    }

    @Override
    public void shutdown() {
        Shell shell;
        this.sigar.close();
        try {
            Class.forName("org.hyperic.sigar.test.SigarTestCase").getMethod(FileAutoConfiguration.break("d\u001bh\u0004b$n\u0010f\u0005"), new Class[0]).invoke(null, new Object[0]);
            shell = this;
        }
        catch (ClassNotFoundException classNotFoundException) {
            shell = this;
        }
        catch (Exception a) {
            shell = this;
            a.printStackTrace();
        }
        catch (NoClassDefFoundError a) {
            shell = this;
        }
        super.shutdown();
    }
}

