/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32;

import java.util.List;
import java.util.Vector;
import org.hyperic.sigar.ProcFd;
import org.hyperic.sigar.pager.PageFetcher;
import org.hyperic.sigar.win32.Win32;
import org.hyperic.sigar.win32.Win32Exception;

public class RegistryKey
extends Win32 {
    private static final int HKEY_DYN_DATA = -2147483642;
    private static final int HKEY_USERS = -2147483645;
    private static final int HKEY_PERFORMANCE_DATA = -2147483644;
    private static final int HKEY_CURRENT_CONFIG = -2147483643;
    private static final int HKEY_CURRENT_USER = -2147483647;
    private static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    private long m_hkey;
    public static final RegistryKey LocalMachine;
    public static final RegistryKey CurrentUser;
    public static final RegistryKey ClassesRoot;
    private String subkey;

    public String getStringValue(String name) throws Win32Exception {
        String a = RegistryKey.RegQueryStringValue(this.m_hkey, name);
        if (a == null) {
            throw new Win32Exception(PageFetcher.break("\u001d\u0011*\f*C?\u0006,\u00171\r?C+\u0017*\n6\u0004x\u00159\u000f-\u0006"));
        }
        return a;
    }

    private /* synthetic */ RegistryKey() {
        RegistryKey a;
    }

    private static native /* synthetic */ int RegQueryIntValue(long var0, String var2);

    public RegistryKey createSubKey(String subkey) {
        return new RegistryKey(RegistryKey.RegCreateKey(this.m_hkey, subkey));
    }

    private /* synthetic */ RegistryKey(long a) {
        RegistryKey a2;
        a2.m_hkey = a;
    }

    public void setIntValue(String name, int value) throws Win32Exception {
        if (RegistryKey.RegSetIntValue(this.m_hkey, name, value) != 0) {
            throw new Win32Exception(ProcFd.break("|aK|K3JvMgP}^3P}M3OrUf\\"));
        }
    }

    public String[] getSubKeyNames() {
        String a;
        Vector<String> a2 = new Vector<String>();
        int a3 = 0;
        RegistryKey registryKey = this;
        while ((a = RegistryKey.RegEnumKey(registryKey.m_hkey, a3)) != null) {
            registryKey = this;
            ++a3;
            a2.add(a);
        }
        Vector<String> vector = a2;
        return vector.toArray(new String[vector.size()]);
    }

    public synchronized void close() {
        if (this.m_hkey != 0L) {
            RegistryKey.RegCloseKey(this.m_hkey);
            this.m_hkey = 0L;
        }
    }

    private static native /* synthetic */ int RegSetIntValue(long var0, String var2, int var3);

    private static native /* synthetic */ int RegFlushKey(long var0);

    public int getIntValue(String name, int defaultValue) {
        try {
            int a = this.getIntValue(name);
            return a;
        }
        catch (Win32Exception a) {
            int a2 = defaultValue;
            return a2;
        }
    }

    private static native /* synthetic */ String RegEnumValueName(long var0, int var2);

    private static native /* synthetic */ String RegQueryStringValue(long var0, String var2);

    public int getIntValue(String name) throws Win32Exception {
        int a = 0;
        try {
            a = RegistryKey.RegQueryIntValue(this.m_hkey, name);
            return a;
        }
        catch (Throwable a2) {
            throw new Win32Exception(PageFetcher.break("&*\u00117\u0011x\u0004=\u0017,\n6\u0004x\n6\u0017x\u00159\u000f-\u0006"));
        }
    }

    private static native /* synthetic */ long RegOpenKey(long var0, String var2);

    private static native /* synthetic */ long RegCreateKey(long var0, String var2);

    private static native /* synthetic */ int RegDeleteValue(long var0, String var2);

    public void getMultiStringValue(String name, List values) throws Win32Exception {
        RegistryKey.RegQueryMultiStringValue(this.m_hkey, name, values);
    }

    private static native /* synthetic */ int RegLoadKey(long var0, String var2, String var3);

    public void deleteValue(String name) {
        RegistryKey.RegDeleteValue(this.m_hkey, name);
    }

    private static native /* synthetic */ int RegCloseKey(long var0);

    public String[] getValueNames() {
        String a;
        Vector<String> a2 = new Vector<String>();
        int a3 = 0;
        RegistryKey registryKey = this;
        while ((a = RegistryKey.RegEnumValueName(registryKey.m_hkey, a3)) != null) {
            registryKey = this;
            ++a3;
            a2.add(a);
        }
        Vector<String> vector = a2;
        return vector.toArray(new String[vector.size()]);
    }

    private static native /* synthetic */ int RegDeleteKey(long var0, String var2);

    public void deleteSubKeyTree(String subkey) {
    }

    private static native /* synthetic */ void RegQueryMultiStringValue(long var0, String var2, List var3);

    public RegistryKey createSubKey(String subkey, String value) throws Win32Exception {
        RegistryKey a = null;
        long a2 = RegistryKey.RegCreateKey(this.m_hkey, subkey);
        if (a2 != 0L) {
            a = new RegistryKey(a2);
            if (a != null) {
                RegistryKey registryKey = a;
                registryKey.setStringValue(null, value);
                return registryKey;
            }
        } else {
            throw new Win32Exception(ProcFd.break("|aK|K3Za\\rMzWt\u0019`LqRv@"));
        }
        return a;
    }

    private static native /* synthetic */ int RegSetStringValue(long var0, String var2, String var3);

    public void flush() {
        RegistryKey.RegFlushKey(this.m_hkey);
    }

    public String getSubKeyName() {
        return this.subkey;
    }

    public String getStringValue(String name, String defaultValue) {
        try {
            String a = this.getStringValue(name);
            return a;
        }
        catch (Win32Exception a) {
            String a2 = defaultValue;
            return a2;
        }
    }

    private static native /* synthetic */ byte[] RegQueryBufferValue(long var0, String var2);

    private static native /* synthetic */ String RegEnumKey(long var0, int var2);

    public void setStringValue(String name, String value) throws Win32Exception {
        if (RegistryKey.RegSetStringValue(this.m_hkey, name, value) != 0) {
            throw new Win32Exception(PageFetcher.break("\u001d\u0011*\f*C+\u0006,\u00171\r?C+\u0017*\n6\u0004x\u00159\u000f-\u0006"));
        }
    }

    public RegistryKey openSubKey(String subkey) throws Win32Exception {
        long a = RegistryKey.RegOpenKey(this.m_hkey, subkey);
        if (a == 0L) {
            throw new Win32Exception(ProcFd.break("VKaVa\u0019|IvWzWt\u0019`LqRv@"));
        }
        new RegistryKey(a).subkey = subkey;
        return new RegistryKey(a);
    }

    public RegistryKey createSubKey(String subkey, int value) throws Win32Exception {
        RegistryKey a = null;
        long a2 = RegistryKey.RegCreateKey(this.m_hkey, subkey);
        if (a2 != 0L) {
            a = new RegistryKey(a2);
            if (a != null) {
                RegistryKey registryKey = a;
                registryKey.setIntValue(null, value);
                return registryKey;
            }
        } else {
            throw new Win32Exception(PageFetcher.break("&*\u00117\u0011x\u0000*\u00069\u00171\r?C+\u0016:\b=\u001a"));
        }
        return a;
    }

    protected void finalize() {
        this.close();
    }

    static {
        ClassesRoot = new RegistryKey(Integer.MIN_VALUE);
        CurrentUser = new RegistryKey(-2147483647L);
        LocalMachine = new RegistryKey(-2147483646L);
    }

    public void deleteSubKey(String subkey) {
        RegistryKey.RegDeleteKey(this.m_hkey, subkey);
    }
}

