/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.Who;
import org.hyperic.sigar.win32.F;
import org.hyperic.sigar.win32.ServiceConfig;
import org.hyperic.sigar.win32.Win32;
import org.hyperic.sigar.win32.Win32Exception;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Service
extends Win32 {
    public static final int SERVICE_START_PENDING = 2;
    private long manager = Service.OpenSCManager("", 983103);
    public static final int SERVICE_RUNNING = 4;
    private static final int CONTROL_STOP = 1;
    private static final String[] STATUS;
    private static final int SC_MANAGER_CREATE_SERVICE = 2;
    public static final int SERVICE_CONTINUE_PENDING = 5;
    private static final int CONTROL_PAUSE = 2;
    private static final int SC_MANAGER_MODIFY_BOOT_CONFIG = 32;
    private static final int SERVICE_ENUMERATE_DEPENDENTS = 8;
    private static final int SC_MANAGER_QUERY_LOCK_STATUS = 16;
    private String name;
    private long service;
    private static final int CONTROL_START = 0;
    private static final int SERVICE_USER_DEFINED_CONTROL = 256;
    public static final int SERVICE_STOP_PENDING = 3;
    private static final int SERVICE_STOP = 32;
    public static final int SERVICE_STOPPED = 1;
    public static final int SERVICE_PAUSE_PENDING = 6;
    private static final int SC_MANAGER_LOCK = 8;
    private static final int SERVICE_CHANGE_CONFIG = 2;
    private static final int STANDARD_RIGHTS_REQUIRED = 983040;
    private static final int SERVICE_QUERY_STATUS = 4;
    private static final int SERVICE_QUERY_CONFIG = 1;
    private static final int SC_MANAGER_ALL_ACCESS = 983103;
    private static final int SC_MANAGER_CONNECT = 1;
    private static final int SERVICE_PAUSE_CONTINUE = 64;
    private static final int SERVICE_START = 16;
    private static final int SERVICE_INTERROGATE = 128;
    public static final int SERVICE_PAUSED = 7;
    private static final int SERVICE_ALL_ACCESS = 983551;
    private static final int SC_MANAGER_ENUMERATE_SERVICE = 4;
    private static final int CONTROL_RESUME = 3;

    private /* synthetic */ Service() throws Win32Exception {
        Service a;
    }

    public void setDescription(String description) {
        Service.ChangeServiceDescription(this.service, description);
    }

    private static native /* synthetic */ long OpenService(long var0, String var2, int var3) throws Win32Exception;

    public void start(long timeout) throws Win32Exception {
        this.start();
        if (!new F(this, timeout, 4, 2).break()) {
            throw new Win32Exception(Mem.break("1*\u001e'\u0012/W?\u0018k\u0004?\u00169\u0003k\u0004.\u0005=\u001e(\u0012"));
        }
    }

    public void resume() throws Win32Exception {
        this.break(3);
    }

    public void pause(long timeout) throws Win32Exception {
        this.pause();
        if (!new F(this, timeout, 7, 6).break()) {
            throw new Win32Exception(Who.break("),\u0006!\n)O9\u0000m\u001f,\u001a>\nm\u001c(\u001d;\u0006.\n"));
        }
    }

    protected void finalize() {
        this.close();
    }

    public static List getServiceNames() throws Win32Exception {
        return Service.getServiceNames(null, null);
    }

    public void stop(long timeout) throws Win32Exception {
        this.stop();
        if (!new F(this, timeout, 1, 3).break()) {
            throw new Win32Exception(Mem.break("\r\u0016\"\u001b.\u0013k\u0003$W8\u0003$\u0007k\u0004.\u0005=\u001e(\u0012"));
        }
    }

    public String getStatusString() {
        return STATUS[this.getStatus()];
    }

    private static native /* synthetic */ int QueryServiceStatus(long var0);

    private static native /* synthetic */ long CreateService(long var0, String var2, String var3, int var4, int var5, int var6, String var7, String[] var8, String var9, String var10) throws Win32Exception;

    private static native /* synthetic */ boolean CloseServiceHandle(long var0);

    private static native /* synthetic */ boolean ChangeServiceDescription(long var0, String var2);

    public int getStatus() {
        return Service.QueryServiceStatus(this.service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int a;
        List a2;
        if (args.length == 0) {
            a2 = Service.getServiceNames();
        } else {
            if (args.length == 2 && args[0].equals(Who.break("B9\u0000*\b!\n"))) {
                long a3 = 5000L;
                Service a4 = new Service(args[1]);
                if (a4.getStatus() == 4) {
                    System.out.println(Mem.break("$?\u0018;\u0007\"\u0019,W8\u00129\u0001\"\u0014.YeY"));
                    a4.stop(a3);
                } else {
                    System.out.println(Who.break("<9\u000e?\u001b$\u0001*O>\n?\u0019$\f(AcA"));
                    a4.start(a3);
                }
                System.out.println(a4.getStatusString());
                return;
            }
            if (args.length == 1 && args[0].startsWith(Mem.break("\u0018\u00129\u0001\"\u0014.Y"))) {
                try (Sigar a5 = new Sigar();){
                    a2 = Service.getServiceNames(a5, args[0]);
                }
            }
            if (args.length == 1 && args[0].endsWith(".exe")) {
                int a6;
                List a7;
                try (Sigar a8 = new Sigar();){
                    a7 = Service.getServiceConfigs(args[0]);
                }
                int n = a6 = 0;
                while (n < a7.size()) {
                    ServiceConfig a9 = (ServiceConfig)a7.get(a6);
                    a9.list(System.out);
                    System.out.println("");
                    n = ++a6;
                }
                return;
            }
            a2 = Arrays.asList(args);
        }
        int n = a = 0;
        while (n < a2.size()) {
            String a10 = (String)a2.get(a);
            Service a11 = new Service(a10);
            a11.list(System.out);
            System.out.println("");
            n = ++a;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Service(String string) throws Win32Exception {
        this();
        void serviceName;
        this.service = Service.OpenService(this.manager, (String)serviceName, 983551);
        this.name = string;
    }

    public static Service create(ServiceConfig config) throws Win32Exception {
        if (config.getName() == null) {
            throw new IllegalArgumentException(Who.break("\u0001,\u0002(R#\u001a!\u0003"));
        }
        if (config.getPath() == null) {
            throw new IllegalArgumentException(Mem.break("\u0007*\u0003#J%\u0002'\u001b"));
        }
        Service a = new Service();
        a.service = Service.CreateService(a.manager, config.getName(), config.getDisplayName(), config.getType(), config.getStartType(), config.getErrorControl(), config.getPath(), config.getDependencies(), config.getStartName(), config.getPassword());
        if (config.getDescription() != null) {
            a.setDescription(config.getDescription());
        }
        return a;
    }

    static {
        String[] stringArray = new String[8];
        stringArray[0] = Who.break(":#\u0004#\u0000:\u0001");
        stringArray[1] = Mem.break("$?\u0018;\u0007.\u0013");
        stringArray[2] = Who.break("<9\u000e?\u001bm?(\u0001)\u0006#\b");
        stringArray[3] = Mem.break("\u0018\u0003$\u0007k'.\u0019/\u001e%\u0010");
        stringArray[4] = Who.break("=8\u0001#\u0006#\b");
        stringArray[5] = Mem.break("\b\u0018%\u0003\"\u0019>\u0012k'.\u0019/\u001e%\u0010");
        stringArray[6] = Who.break("?,\u001a>\nm?(\u0001)\u0006#\b");
        stringArray[7] = Mem.break("\u001b\u0016>\u0004.\u0013");
        STATUS = stringArray;
    }

    public synchronized void close() {
        if (this.service != 0L) {
            Service.CloseServiceHandle(this.service);
            this.service = 0L;
        }
        if (this.manager != 0L) {
            Service.CloseServiceHandle(this.manager);
            this.manager = 0L;
        }
    }

    public ServiceConfig getConfig() throws Win32Exception {
        ServiceConfig a;
        ServiceConfig serviceConfig = a = new ServiceConfig();
        Service.QueryServiceConfig(this.service, serviceConfig);
        a.setName(this.name);
        return serviceConfig;
    }

    public void start() throws Win32Exception {
        this.break(0);
    }

    public void pause() throws Win32Exception {
        this.break(2);
    }

    private static native /* synthetic */ boolean QueryServiceConfig(long var0, ServiceConfig var2) throws Win32Exception;

    public void list(PrintStream out) throws Win32Exception {
        this.getConfig().list(out);
        out.println(Who.break("\u001c9\u000e9\u001a>AcAcAcAc4") + this.getStatusString() + Mem.break("*"));
    }

    private static native /* synthetic */ long OpenSCManager(String var0, int var1) throws Win32Exception;

    public void stop() throws Win32Exception {
        this.break(1);
    }

    public static List getServiceConfigs(String exe) throws Win32Exception {
        try (Sigar a = new Sigar();){
            List list = Service.getServiceConfigs(a, exe);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static List getServiceConfigs(Sigar sigar, String exe) throws Win32Exception {
        void a;
        int a2;
        ArrayList arrayList = new ArrayList();
        List a3 = Service.getServiceNames(sigar, Who.break("\u001e\n?\u0019$\f(A\b\u0017(A\u0004\n<R") + exe);
        int n = a2 = 0;
        while (n < a3.size()) {
            try (Service a4 = null;){
                a4 = new Service((String)a3.get(a2));
                ServiceConfig a5 = a4.getConfig();
                a.add(a5);
            }
            n = ++a2;
        }
        return a;
    }

    private static native /* synthetic */ void ControlService(long var0, int var2) throws Win32Exception;

    private /* synthetic */ void break(int a) throws Win32Exception {
        Service a2;
        Service.ControlService(a2.service, a);
    }

    public void delete() throws Win32Exception {
        Service.DeleteService(this.service);
    }

    public void stopAndWait(long timeout) throws Win32Exception {
        this.stop(timeout);
    }

    private static native /* synthetic */ void DeleteService(long var0) throws Win32Exception;

    public static native List getServiceNames(Sigar var0, String var1) throws Win32Exception;

    public int status() {
        return this.getStatus();
    }
}

