/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.file.web;

import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.web.BaseController;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@ConditionalOnProperty(name={"file.isFileStreamDown"}, havingValue="true", matchIfMissing=true)
public class WebOfficeController
extends BaseController {
    @RequestMapping(value={"/file/weboffice/preview"})
    public String preview(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String fileUrl = (String)request.getAttribute("fileUrl");
        String filePath = (String)request.getAttribute("filePath");
        String docType = null;
        if (StringUtils.endsWithAny((CharSequence)filePath, (CharSequence[])new CharSequence[]{".gif", ".bmp", ".jpeg", ".jpg", ".png"})) {
            docType = "img";
        } else if (StringUtils.endsWithAny((CharSequence)filePath, (CharSequence[])new CharSequence[]{".doc", ".docx"})) {
            docType = "doc";
        } else if (StringUtils.endsWithAny((CharSequence)filePath, (CharSequence[])new CharSequence[]{".xls", ".xlsx"})) {
            docType = "xls";
        } else if (StringUtils.endsWithAny((CharSequence)filePath, (CharSequence[])new CharSequence[]{".ppt", ".pptx"})) {
            docType = "ppt";
        } else if (StringUtils.endsWithAny((CharSequence)filePath, (CharSequence[])new CharSequence[]{".wps", ".wpt"})) {
            docType = "wps";
        } else if (StringUtils.endsWithAny((CharSequence)filePath, (CharSequence[])new CharSequence[]{".tif", "tiff"})) {
            docType = "tif";
        } else if (StringUtils.endsWithAny((CharSequence)filePath, (CharSequence[])new CharSequence[]{".pdf"})) {
            docType = "pdf";
        }
        if (docType != null) {
            request.setAttribute("docType", (Object)docType);
            request.setAttribute("fileUrl", (Object)fileUrl);
            return "modules/file/webofficePreview";
        }
        return "redirect:" + fileUrl;
    }
}

