/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.file.web;

import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.idgen.IdGen;
import com.jeesite.common.io.FileUtils;
import com.jeesite.common.lang.ByteUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.lang.TimeUtils;
import com.jeesite.common.mapper.JsonMapper;
import com.jeesite.common.mybatis.mapper.query.QueryWhere;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.file.entity.FileEntity;
import com.jeesite.modules.file.entity.FileUpload;
import com.jeesite.modules.file.entity.FileUploadParms;
import com.jeesite.modules.file.service.FileEntityService;
import com.jeesite.modules.file.service.FileUploadService;
import com.jeesite.modules.file.service.FileUploadServiceExtend;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hyperic.sigar.Who;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"${adminPath}/file"})
@ConditionalOnProperty(name={"file.enabled", "web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class FileUploadController
extends BaseController {
    @Autowired
    private FileUploadService fileUploadService;
    @Autowired
    private FileUploadServiceExtend fileUploadServiceExtend;
    @Autowired
    private FileEntityService fileEntityService;

    @RequestMapping(value={"/download/{fileUploadId}"}, method={RequestMethod.GET})
    public String download(@PathVariable(value="fileUploadId") String fileUploadId, String preview, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FileUpload a2 = (FileUpload)this.fileUploadService.get(fileUploadId);
        if (a2 != null && a2.getFileEntity() != null && a2.getFileEntity().getFileMd5() != null) {
            FileEntity a3 = a2.getFileEntity();
            if (StringUtils.isNotBlank((CharSequence)preview)) {
                return new StringBuilder().insert(0, "redirect:").append(a3.getFileUrl()).append(QueryWhere.char("n\r#\u0018'\u00144\nl")).append(preview).toString();
            }
            String a4 = this.fileUploadServiceExtend.downFile(a2, request, response);
            if (!Who.char("\u000b\u0005\u000b").equals(a4)) {
                if (StringUtils.isNotBlank((CharSequence)a4)) {
                    return new StringBuilder().insert(0, "redirect:").append(a4).toString();
                }
                return null;
            }
        }
        request.setAttribute(QueryWhere.char("\u000f4\u000e!\u0012?\u000e4.%\u001c%\b\""), (Object)200);
        request.setAttribute(Who.char("RPLF^RZ"), (Object)FileUploadController.text(QueryWhere.char("\"\u0004\"S7\u0014=\u0018\u007f\u0019>\n?\u0011>\u001c5;8\u001143>\t\u0014\u00058\u000e%"), new String[0]));
        request.getRequestDispatcher(Who.char("\u001aZGMZM\u001a\u000b\u0005\u000b")).forward((ServletRequest)request, (ServletResponse)response);
        return null;
    }

    @RequestMapping(value={"fileList"})
    @ResponseBody
    public String fileList(FileUpload fileUpload) {
        List<FileUpload> a2;
        if (StringUtils.isNotBlank((CharSequence)fileUpload.getBizKey()) && StringUtils.isNotBlank((CharSequence)fileUpload.getBizType()) && (a2 = this.fileUploadService.findList(fileUpload)) != null && a2.size() > 0) {
            return JsonMapper.toJson(a2);
        }
        return this.renderResult("false", QueryWhere.char("\u001f\u0012q\u001b8\u00114\u000e\u007f"));
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(value={"upload"})
    @ResponseBody
    public String upload(FileUploadParms params, HttpServletRequest request) {
        void a2;
        FileUpload a3;
        FileEntity a4;
        void a5;
        long a6 = System.currentTimeMillis();
        HashMap hashMap = MapUtils.newHashMap();
        a5.put(Who.char("VPQZ"), QueryWhere.char("\u000e4\u000f'\u0018#"));
        if (StringUtils.isBlank((CharSequence)params.getFileMd5()) || StringUtils.isBlank((CharSequence)params.getFileName())) {
            return this.renderResult("false", FileUploadController.text(Who.char("FFF\u0011SVYZ\u001bJESZ^QiTS\\[{PA}Y^[T"), new String[0]), a5);
        }
        params.initialize();
        boolean a7 = false;
        FileEntity fileEntity = new FileEntity();
        a4.setFileMd5(params.getFileMd5());
        a4 = this.fileEntityService.getByMd5(a4);
        if (!"0".equals(a4.getStatus())) {
            a7 = true;
        }
        if (a7) {
            File a8;
            long a9;
            Object a10;
            Object a11;
            a3 = null;
            if (request instanceof MultipartHttpServletRequest && (a11 = (a10 = (MultipartHttpServletRequest)request).getFileNames()).hasNext()) {
                a3 = a10.getFile((String)a11.next());
            }
            if (a3 == null || a3.isEmpty() || a3.getOriginalFilename() == null) {
                return this.renderResult("false", FileUploadController.text(QueryWhere.char("\u000e(\u000e\u007f\u001b8\u00114S$\r=\u00120\u0019\u0017\u0014=\u0018\u0018\u000e\u0014\u0010!\t("), new String[0]), a5);
            }
            a10 = params.getAllowSuffixes();
            if (!StringUtils.contains((CharSequence)a10, (CharSequence)("." + params.getFileExtension() + Who.char("\u0013")))) {
                a5.put(QueryWhere.char("\u001e>\u00194"), Who.char("[PA`TSYPB`AFEZ"));
                a11 = params.getUploadType();
                if ("image".equals(a11)) {
                    String[] stringArray = new String[1];
                    stringArray[0] = a10;
                    return this.renderResult("false", FileUploadController.text(QueryWhere.char("\"\u0004\"S7\u0014=\u0018\u007f\b!\u0011>\u001c5+0\u00118\u0019\u0018\u00100\u001a4"), stringArray), a5);
                }
                if ("media".equals(a11)) {
                    String[] stringArray = new String[1];
                    stringArray[0] = a10;
                    return this.renderResult("false", FileUploadController.text(Who.char("LLL\u001bY\\SP\u0011@OYPT[c^YVQi\\[PP"), stringArray), a5);
                }
                if ("file".equals(a11)) {
                    String[] stringArray = new String[1];
                    stringArray[0] = a10;
                    return this.renderResult("false", FileUploadController.text(QueryWhere.char("\u000e(\u000e\u007f\u001b8\u00114S$\r=\u00120\u0019\u0007\u001c=\u00145;8\u00114"), stringArray), a5);
                }
                String[] stringArray = new String[1];
                stringArray[0] = a10;
                return this.renderResult("false", FileUploadController.text(Who.char("LLL\u001bY\\SP\u0011@OYPT[c^YVQ~YS"), stringArray), a5);
            }
            long a22 = a3.getSize();
            if (a22 > (a9 = params.getMaxFileSize().longValue())) {
                a5.put(QueryWhere.char("\u001e>\u00194"), Who.char("ZM\\PZQ`FVOZ"));
                String[] stringArray = new String[1];
                stringArray[0] = ByteUtils.formatByteSize((long)a9);
                return this.renderResult("false", FileUploadController.text(QueryWhere.char("\u000e(\u000e\u007f\u001b8\u00114S$\r=\u00120\u0019\u0007\u001c=\u00145.8\u00074"), stringArray));
            }
            boolean a12 = false;
            if (StringUtils.isBlank((CharSequence)a4.getFileId())) {
                FileEntity fileEntity2 = a4;
                FileEntity fileEntity3 = a4;
                FileUploadParms fileUploadParms = params;
                a4.setFileId(IdGen.nextId());
                a4.setFileMd5(fileUploadParms.getFileMd5());
                fileEntity3.setFilePath(fileUploadParms.getRelativePath());
                fileEntity3.setFileContentType(a3.getContentType());
                fileEntity2.setFileExtension(params.getFileExtension());
                fileEntity2.setFileSize(a22);
                a12 = true;
            }
            if (!(a8 = new File(a4.getFileRealPath())).getParentFile().exists()) {
                a8.getParentFile().mkdirs();
            }
            try {
                a3.transferTo(a8);
            }
            catch (IOException a13) {
                this.logger.error(new StringBuilder().insert(0, Who.char("\u65b2\u4ec9\u4fe8\u5b67\u5205\u6713\u5705\u590e\u8d10\uff25")).append(a8.getAbsolutePath()).toString(), (Throwable)a13);
            }
            String a14 = Global.getConfig(QueryWhere.char("\u001b8\u00114S0\u0011=\u0012&>>\u0013%\u0018?\t\u0005\u0004!\u0018\""));
            if (StringUtils.isNotBlank((CharSequence)a14) && !StringUtils.inString((String)FileUtils.getRealContentType((File)a8), (String[])a14.split(Who.char("\u0013")))) {
                a8.delete();
                a5.put(QueryWhere.char("\u001e>\u00194"), Who.char("[PA`TSYPB`AFEZ"));
                return this.renderResult("false", FileUploadController.text(QueryWhere.char("\"\u0004\"S7\u0014=\u0018\u007f\b!\u0011>\u001c5+0\u00118\u0019\u0012\u0012?\t4\u0013%"), new String[0]));
            }
            FileUploadController fileUploadController = this;
            fileUploadController.fileUploadService.compressImage(params, a8);
            fileUploadController.fileUploadServiceExtend.uploadFile(a4);
            if (a12) {
                this.fileEntityService.insert(a4);
            }
        }
        a3 = new FileUpload(a4);
        FileUploadController fileUploadController = this;
        FileUpload fileUpload = a3;
        fileUpload.setFileName(params.getFileName());
        fileUpload.setFileType(params.getUploadType());
        fileUploadController.fileUploadServiceExtend.saveUploadFile(a3);
        fileUploadController.fileUploadService.save(a3);
        a5.put(Who.char("SVYZ`OYPT["), a3);
        long a15 = System.currentTimeMillis();
        String string = TimeUtils.formatDateAgo((long)(a15 - a6));
        if (!a7) {
            String[] stringArray = new String[1];
            stringArray[0] = a2;
            return this.renderResult("true", FileUploadController.text(QueryWhere.char("\"\u0004\"S7\u0014=\u0018\u007f\b!\u0011>\u001c5.$\u001e2\u0018\"\u000e\u0002\u00182\u0012?\u0019\""), stringArray), a5);
        }
        String[] stringArray = new String[1];
        stringArray[0] = a2;
        return this.renderResult("true", FileUploadController.text(Who.char("FFF\u0011SVYZ\u001bJESZ^Ql@\\VZFL"), stringArray), a5);
    }
}

