/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.gen.entity.config;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.mapper.MapperException;
import com.jeesite.modules.sys.utils.ModuleUtils;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.hibernate.validator.constraints.Length;

@XmlRootElement(name="template")
public class GenTemplate
extends DataEntity<GenTemplate> {
    private String fileName;
    private String name;
    private String filePath;
    private String category;
    private String content;
    private static final long serialVersionUID = 1L;

    @XmlTransient
    public List<String> getCategoryList() {
        if (this.category == null) {
            return ListUtils.newArrayList();
        }
        return ListUtils.newArrayList((Object[])StringUtils.split((String)this.category, (String)ModuleUtils.char("n")));
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public GenTemplate() {
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getContent() {
        return this.content;
    }

    public void setCategoryList(List<String> categoryList) {
        if (categoryList == null) {
            this.category = "";
            return;
        }
        this.category = new StringBuilder().insert(0, MapperException.char("(")).append(StringUtils.join(categoryList, (String)ModuleUtils.char("n"))).append(MapperException.char("(")).toString();
    }

    public GenTemplate(String id) {
        super(id);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @NotBlank
    @Length(min=0, max=200)
    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }
}

