/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.gen.service;

import com.jeesite.autoconfigure.sys.MsgAutoConfiguration;
import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.datasource.DataSourceHolder;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.mapper.MapperHelper;
import com.jeesite.common.service.CrudService;
import com.jeesite.modules.gen.dao.GenDataDictDao;
import com.jeesite.modules.gen.dao.GenTableColumnDao;
import com.jeesite.modules.gen.dao.GenTableDao;
import com.jeesite.modules.gen.entity.GenTable;
import com.jeesite.modules.gen.entity.GenTableColumn;
import com.jeesite.modules.gen.entity.config.GenConfig;
import com.jeesite.modules.gen.entity.config.GenTemplate;
import com.jeesite.modules.gen.utils.GenUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hyperic.sigar.pager.PageControl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
@ConditionalOnProperty(name={"gen.enabled"}, havingValue="true", matchIfMissing=true)
public class GenTableService
extends CrudService<GenTableDao, GenTable> {
    @Autowired
    private GenDataDictDao genDataDictDao;
    @Autowired
    private GenTableColumnDao genTableColumnDao;

    public boolean checkTableName(String tableName) {
        if (StringUtils.isBlank((CharSequence)tableName)) {
            return true;
        }
        return ((GenTableDao)this.dao).get(new GenTable(tableName)) == null;
    }

    public List<GenTable> findListFromDb(GenTable genTable) {
        GenTableService genTableService;
        String a2 = genTable.getDataSourceName();
        if (StringUtils.isNotBlank((CharSequence)a2)) {
            try {
                DataSourceHolder.setDataSourceName(a2);
                genTableService = this;
            }
            catch (Exception a3) {
                return ListUtils.newArrayList();
            }
        } else {
            genTableService = this;
        }
        List<GenTable> a4 = genTableService.genDataDictDao.findTableList(genTable);
        if (StringUtils.isNotBlank((CharSequence)a2)) {
            DataSourceHolder.clearDataSourceName();
        }
        return a4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional(readOnly=false)
    public void delete(GenTable genTable) {
        void a2;
        GenTable genTable2 = genTable;
        super.delete(genTable2);
        if (StringUtils.isBlank((CharSequence)genTable2.getTableName())) {
            return;
        }
        GenTableColumn genTableColumn = new GenTableColumn();
        a2.setGenTable(new GenTable(genTable.getTableName()));
        this.genTableColumnDao.deleteByEntity(a2);
    }

    /*
     * Unable to fully structure code
     */
    public GenTable getFromDb(GenTable genTable) {
        block18: {
            block19: {
                block20: {
                    if (!StringUtils.isNotBlank((CharSequence)genTable.getTableName())) break block18;
                    a = genTable.getDataSourceName();
                    if (StringUtils.isNotBlank((CharSequence)a)) {
                        try {
                            DataSourceHolder.setDataSourceName(a);
                            v0 = this;
                        }
                        catch (Exception a) {
                            return genTable;
                        }
                    } else {
                        v0 = this;
                    }
                    a = v0.genDataDictDao.findTableList(genTable);
                    if (a.size() <= 0) break block19;
                    if (!genTable.getIsNewRecord()) break block20;
                    genTable = a.get(0);
                    if (StringUtils.isNotBlank((CharSequence)a)) {
                        genTable.setDataSourceName(a);
                    }
                    if (StringUtils.isBlank((CharSequence)genTable.getComments())) {
                        v1 = genTable;
                        v1.setComments(v1.getTableName());
                    }
                    v2 = genTable;
                    v2.setFunctionName(v2.getComments());
                    v2.setFunctionNameSimple(v2.getComments());
                    v3 = genTable;
                    if (StringUtils.startsWith((CharSequence)v2.getTableName(), (CharSequence)Global.getTablePrefix())) {
                        a = StringUtils.substringAfter((String)v3.getTableName(), (String)Global.getTablePrefix());
                        v4 = genTable;
                        v5 = v4;
                        v4.setClassName(StringUtils.capCamelCase((String)a));
                    } else {
                        v3.setClassName(StringUtils.capCamelCase((String)genTable.getTableName()));
                        v5 = genTable;
                    }
                    if (StringUtils.startsWith((CharSequence)v5.getClassName(), (CharSequence)MsgAutoConfiguration.char("\u000fD/"))) {
                        v6 = genTable;
                        v6.setClassName(StringUtils.substringAfter((String)v6.getClassName(), (String)PageControl.char("z<Z")));
                    }
                    if (!StringUtils.isBlank((CharSequence)genTable.getPackageName())) ** GOTO lbl43
                    a = Global.getConfig(MsgAutoConfiguration.char("Z9SrY9[=H0I\f\\?V=Z9s=P9"));
                    v7 = genTable;
                    if (StringUtils.isNotBlank((CharSequence)a)) {
                        v7.setPackageName((String)a);
                        v8 = genTable;
                    } else {
                        v7.setPackageName(PageControl.char("J*DkC L6@1LkD*M0E Z"));
lbl43:
                        // 2 sources

                        v8 = genTable;
                    }
                    if (StringUtils.isBlank((CharSequence)v8.getModuleName())) {
                        a = genTable.getTableName();
                        if (StringUtils.startsWith((CharSequence)a, (CharSequence)Global.getTablePrefix())) {
                            a = StringUtils.substringAfter((String)a, (String)Global.getTablePrefix());
                        }
                        genTable.setModuleName(StringUtils.substringBefore((String)a, (String)MsgAutoConfiguration.char("\u0003")));
                    }
                }
                a = this.genDataDictDao.findTableColumnList(genTable);
                var5_6 = a.iterator();
                while (var5_6.hasNext()) {
                    a = var5_6.next();
                    a = false;
                    for (GenTableColumn a : genTable.getColumnList()) {
                        if (!a.getColumnName().equals(a.getColumnName())) continue;
                        a = true;
                    }
                    if (a) continue;
                    genTable.getColumnList().add(a);
                }
                for (GenTableColumn a : genTable.getColumnList()) {
                    a = false;
                    var8_9 = a.iterator();
                    while (var8_9.hasNext()) {
                        a = var8_9.next();
                        if (!a.getColumnName().equals(a.getColumnName())) continue;
                        a = true;
                    }
                    if (a) continue;
                    a.setStatus("1");
                }
                v9 = genTable;
                v9.setPkList(this.genDataDictDao.findTablePK(v9));
                GenUtils.initColumnField(genTable);
            }
            if (StringUtils.isNotBlank((CharSequence)a)) {
                DataSourceHolder.clearDataSourceName();
            }
        }
        return genTable;
    }

    @Override
    public GenTable get(String tableName) {
        GenTable a2 = (GenTable)super.get(tableName);
        if (a2 != null) {
            GenTableColumn a3 = new GenTableColumn(a2);
            a2.setColumnList(this.genTableColumnDao.findList(a3));
        }
        return a2;
    }

    @Override
    @Transactional(readOnly=false)
    public void save(GenTable genTable) {
        GenTable genTable2 = genTable;
        super.save(genTable2);
        for (GenTableColumn a2 : genTable2.getColumnList()) {
            a2.setGenTable(genTable);
            if (StringUtils.isBlank((CharSequence)a2.getId())) {
                this.genTableColumnDao.insert(a2);
                continue;
            }
            if ("1".equals(a2.getStatus())) {
                this.genTableColumnDao.delete(a2);
                continue;
            }
            this.genTableColumnDao.update(a2);
        }
    }

    @Override
    public Page<GenTable> findPage(GenTable genTable) {
        String a2 = new StringBuilder().insert(0, PageControl.char("mz\u0000e\u0000j\u0011\t&F0G1\u0001t\u0000eo\u0017f\b\t")).append(MapperHelper.getTableName(genTable)).append(MsgAutoConfiguration.char("\u001d\u000bu\u0019o\u0019\u001d,\\.X2I\u0003I=_0X\u0003S=P9\u0000=\u0013(\\>Q9b2\\1Xu\u001d\u001dn|\u001f?U5Q8s)P~")).toString();
        GenTable genTable2 = genTable;
        genTable2.getSqlMap().add(PageControl.char("L=]\u0006F)\\(G"), a2);
        return super.findPage(genTable2);
    }

    /*
     * WARNING - void declaration
     */
    public String generateCode(GenTable genTable) {
        Iterator<GenTemplate> iterator;
        Object a2;
        Iterator<GenTable> a3;
        StringBuilder a4 = new StringBuilder();
        GenConfig genConfig = GenUtils.getConfig();
        List<GenTemplate> a5 = GenUtils.getTemplateList(genConfig, genTable.getTplCategory(), false);
        List<GenTemplate> a6 = GenUtils.getTemplateList(genConfig, genTable.getTplCategory(), true);
        if (a6.size() > 0) {
            GenTable genTable2 = new GenTable();
            GenTable genTable3 = genTable;
            ((DataEntity)((Object)a3)).setStatus("0");
            ((GenTable)((Object)a3)).setParentTableName(genTable3.getTableName());
            genTable3.setChildList(((GenTableDao)this.dao).findList(a3));
        }
        if (a6.size() > 0 && genTable.getChildList().size() > 0) {
            a3 = genTable.getChildList().iterator();
            while (a3.hasNext()) {
                GenTable object2;
                GenTable genTable4 = object2 = a3.next();
                genTable4.setParent(genTable);
                genTable4.setColumnList(this.genTableColumnDao.findList(new GenTableColumn(object2)));
                a2 = GenUtils.getDataModel(genTable4);
                Iterator<GenTemplate> iterator2 = a6.iterator();
                while (iterator2.hasNext()) {
                    void a8;
                    Iterator<GenTemplate> iterator3;
                    GenTemplate genTemplate = iterator3.next();
                    iterator2 = iterator3;
                    a4.append(GenUtils.generateToFile((GenTemplate)a8, (Map<String, Object>)a2, object2));
                }
            }
        }
        Map<String, Object> a7 = GenUtils.getDataModel(genTable);
        Iterator<GenTemplate> iterator4 = iterator = a5.iterator();
        while (iterator4.hasNext()) {
            void a8;
            a2 = iterator.next();
            iterator4 = iterator;
            a4.append(GenUtils.generateToFile((GenTemplate)a8, a7, genTable));
        }
        return a4.toString();
    }
}

