/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.jni;

import com.jeesite.autoconfigure.core.CacheAutoConfiguration;
import com.jeesite.modules.msg.utils.MsgPushUtils;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import org.hyperic.jni.ArchLoaderException;
import org.hyperic.jni.ArchName;
import org.hyperic.jni.ArchNotSupportedException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ArchLoader {
    public static final boolean IS_NETWARE;
    public static final boolean IS_LINUX;
    public static final boolean IS_WIN32;
    private String jarName;
    private String name;
    public static final boolean IS_SOLARIS;
    private Object loadLock;
    private String packageName;
    private String libName;
    public static final boolean IS_FREEBSD;
    public static final boolean IS_DARWIN;
    private boolean loaded;
    private String resourcePath;
    private File nativeLibrary;
    public static final boolean IS_HPUX;
    public static final boolean IS_AIX;
    public static final boolean IS_OSF1;
    private Class loaderClass;
    private static final String osName;
    private String version;

    public ArchLoader(Class loaderClass) {
        ArchLoader archLoader = this;
        ArchLoader archLoader2 = this;
        ArchLoader archLoader3 = this;
        ArchLoader archLoader4 = this;
        archLoader4.loadLock = new Object();
        archLoader3.loaded = false;
        archLoader3.libName = null;
        archLoader2.setLoaderClass(loaderClass);
        String a2 = loaderClass.getName();
        int a3 = a2.lastIndexOf(".");
        a2 = a2.substring(0, a3);
        archLoader2.setPackageName(a2);
        String string = a2;
        a3 = string.lastIndexOf(".");
        archLoader.setName(string.substring(a3 + 1));
        ArchLoader archLoader5 = this;
        archLoader5.setJarName(new StringBuilder().insert(0, archLoader5.getName()).append(".jar").toString());
        archLoader.setResourcePath(archLoader.char(a2));
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getDefaultLibName() throws ArchNotSupportedException {
        return System.getProperty(new StringBuilder().insert(0, this.getPackageName()).append(MsgPushUtils.char("o((&/%,!")).toString(), new StringBuilder().insert(0, CacheAutoConfiguration.char("4[([")).append(this.getArchLibName()).toString());
    }

    public String getLibName() {
        return this.libName;
    }

    public String getArchLibName() throws ArchNotSupportedException {
        return new StringBuilder().insert(0, this.getName()).append(CacheAutoConfiguration.char("\u0017")).append(ArchName.getName()).toString();
    }

    static {
        osName = System.getProperty(CacheAutoConfiguration.char("U-\u00140[3_"));
        IS_WIN32 = osName.startsWith(MsgPushUtils.char("\u0013(*%+67"));
        IS_AIX = osName.equals("AIX");
        IS_HPUX = osName.equals(CacheAutoConfiguration.char("r\u000e\u0017\u000bb"));
        IS_SOLARIS = osName.equals(MsgPushUtils.char("\u00174*\u000e\u0017"));
        IS_LINUX = osName.equals("Linux");
        IS_DARWIN = osName.equals(CacheAutoConfiguration.char("\u0013[=\u001a\u0011i~b")) || osName.equals(MsgPushUtils.char("\u0005%33(*"));
        IS_OSF1 = osName.equals(CacheAutoConfiguration.char("\u0011i\u0018\u000b"));
        IS_FREEBSD = osName.equals("FreeBSD");
        IS_NETWARE = osName.equals("NetWare");
    }

    public static String getLibraryExtension() {
        if (IS_WIN32) {
            return CacheAutoConfiguration.char("p^2V");
        }
        if (IS_NETWARE) {
            return MsgPushUtils.char("o*-)");
        }
        if (IS_DARWIN) {
            return CacheAutoConfiguration.char("p^'V7X");
        }
        if (IS_HPUX) {
            return MsgPushUtils.char("j2(");
        }
        return CacheAutoConfiguration.char("\u0014-U");
    }

    public String findJarPath(String libName) throws ArchLoaderException {
        return this.char(libName, true);
    }

    protected boolean findInJavaLibraryPath(String libName) {
        String a2 = System.getProperty(MsgPushUtils.char(". 2 j--#6 68j1%5,"), "");
        StringTokenizer a3 = new StringTokenizer(a2, File.pathSeparator);
        while (a3.hasMoreTokens()) {
            a2 = a3.nextToken();
            if (!this.findNativeLibrary(a2, libName)) continue;
            return true;
        }
        return false;
    }

    public void setName(String value) {
        this.name = value;
    }

    private /* synthetic */ String char(String a2, boolean a3) throws ArchLoaderException {
        URL uRL;
        Object object;
        URL uRL2;
        String string;
        ArchLoader a4;
        block11: {
            if (a4.getJarName() == null) {
                throw new ArchLoaderException(CacheAutoConfiguration.char("P?H\u0010[3_~S-\u001a0O2V"));
            }
            ArchLoader archLoader = a4;
            string = archLoader.getResourcePath();
            ClassLoader classLoader = archLoader.getClassLoader();
            uRL2 = classLoader.getResource(string);
            if (!archLoader.char(uRL2)) {
                uRL2 = null;
            }
            if (uRL2 == null && classLoader instanceof URLClassLoader) {
                int n;
                object = ((URLClassLoader)classLoader).getURLs();
                int n2 = n = 0;
                while (n2 < ((URL[])object).length) {
                    if (a4.char(object[n])) {
                        uRL = uRL2 = object[n];
                        break block11;
                    }
                    n2 = ++n;
                }
            }
            uRL = uRL2;
        }
        if (uRL == null) {
            if (a3) {
                throw new ArchLoaderException(new StringBuilder().insert(0, MsgPushUtils.char("\u0011/%#($d5+a\"(*%d")).append(a4.getJarName()).toString());
            }
            return null;
        }
        string = uRL2.getFile();
        if (string.startsWith(CacheAutoConfiguration.char("\\7V;\u0000"))) {
            string = string.substring(5);
        }
        object = new File(string);
        String string2 = a4.getJarName();
        Object object2 = object;
        while (object2 != null && !((File)object).getName().startsWith(string2)) {
            object2 = ((File)object).getParentFile();
        }
        if (a2 == null) {
            a2 = string2;
        }
        if (object != null && (object = ((File)object).getParentFile()) != null && a4.findNativeLibrary(a3 = URLDecoder.decode(((File)object).toString()), a2)) {
            return a3;
        }
        return null;
    }

    public void setLibName(String value) {
        this.libName = value;
    }

    public ClassLoader getClassLoader() {
        return this.getLoaderClass().getClassLoader();
    }

    public Class getLoaderClass() {
        return this.loaderClass;
    }

    public void setLoaderClass(Class value) {
        this.loaderClass = value;
    }

    public void load() throws ArchNotSupportedException, ArchLoaderException {
        this.load(null);
    }

    public String getName() {
        return this.name;
    }

    public static String getLibraryPrefix() {
        if (IS_WIN32 || IS_NETWARE) {
            return "";
        }
        return MsgPushUtils.char("((&");
    }

    public void setResourcePath(String value) {
        this.resourcePath = value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadLibrary(String path) throws ArchNotSupportedException, ArchLoaderException {
        try {
            ArchLoader archLoader;
            String a2 = this.getLibraryName();
            if (path == null) {
                path = System.getProperty(new StringBuilder().insert(0, this.getPackageName()).append(CacheAutoConfiguration.char("\u0014.[*R")).toString());
            }
            if (path != null) {
                if (path.equals(MsgPushUtils.char("i"))) {
                    return;
                }
                ArchLoader archLoader2 = this;
                archLoader = archLoader2;
                archLoader2.char(null, false);
                this.findNativeLibrary(path, a2);
            } else {
                if (this.char(a2, false) == null) {
                    this.findInJavaLibraryPath(a2);
                }
                archLoader = this;
            }
            ArchLoader archLoader3 = this;
            if (archLoader.nativeLibrary != null) {
                archLoader3.systemLoad(this.nativeLibrary.toString());
                return;
            }
            archLoader3.systemLoadLibrary(a2);
            return;
        }
        catch (RuntimeException a3) {
            String a4 = a3.getMessage();
            if (a4 == null) {
                a4 = a3.getClass().getName();
            }
            String a5 = new StringBuilder().insert(0, CacheAutoConfiguration.char("|?S2_:\u001a*U~V1[:\u001a")).append(this.libName).append(MsgPushUtils.char("{d")).append(a4).toString();
            throw new ArchLoaderException(a5);
        }
    }

    protected boolean findNativeLibrary(String dir, String name) {
        File a2 = new File(dir).getAbsoluteFile();
        if (this.containsNativeLibrary(a2, name)) {
            return true;
        }
        if (this.containsNativeLibrary(a2, this.getVersionedLibraryName())) {
            return true;
        }
        return this.containsNativeLibrary(a2, ArchLoader.getLibraryPrefix() + this.getName() + ArchLoader.getLibraryExtension());
    }

    public File getNativeLibrary() {
        return this.nativeLibrary;
    }

    protected boolean containsNativeLibrary(File dir, String name) {
        if (name == null) {
            return false;
        }
        File a2 = new File(dir, name);
        if (a2.exists()) {
            this.nativeLibrary = a2;
            return true;
        }
        return false;
    }

    private /* synthetic */ boolean char(URL a2) {
        ArchLoader a3;
        String string;
        if (a2 == null) {
            return false;
        }
        if (((String)(a2 = ((URL)a2).getFile())).indexOf(string = a3.getJarName()) != -1) {
            return true;
        }
        int n = string.indexOf(".jar");
        if (n != -1) {
            if ((n = ((String)a2).lastIndexOf(string = new StringBuilder().insert(0, string.substring(0, n)).append(MsgPushUtils.char("i")).toString())) != -1) {
                string = ((String)a2).substring(n);
                if ((n = string.indexOf(".jar")) == -1) {
                    return false;
                }
                String string2 = string;
                a3.version = string2.substring(string.indexOf(45) + 1, n);
                string = string2.substring(0, n + 4);
                a3.setJarName(string);
                return true;
            }
            return false;
        }
        return false;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setJarName(String value) {
        this.jarName = value;
    }

    public String getLibraryName() throws ArchNotSupportedException {
        String a2 = this.getLibName();
        if (a2 == null) {
            ArchLoader archLoader = this;
            a2 = archLoader.getDefaultLibName();
            archLoader.setLibName(a2);
        }
        String a3 = ArchLoader.getLibraryPrefix();
        String a4 = ArchLoader.getLibraryExtension();
        return new StringBuilder().insert(0, a3).append(a2).append(a4).toString();
    }

    private /* synthetic */ String char(String a2) {
        int n;
        a2 = new StringBuffer((String)a2);
        int n2 = n = 0;
        while (n2 < ((StringBuffer)a2).length()) {
            if (((StringBuffer)a2).charAt(n) == '.') {
                ((StringBuffer)a2).setCharAt(n, '/');
            }
            n2 = ++n;
        }
        return ((StringBuffer)a2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String path) throws ArchNotSupportedException, ArchLoaderException {
        Object object = this.loadLock;
        synchronized (object) {
            block4: {
                if (!this.loaded) break block4;
                return;
            }
            this.loadLibrary(path);
            this.loaded = true;
            return;
        }
    }

    public String getVersionedLibraryName() {
        if (this.version == null) {
            return null;
        }
        try {
            this.getLibraryName();
        }
        catch (ArchNotSupportedException a2) {
            return null;
        }
        String a3 = ArchLoader.getLibraryPrefix();
        String a4 = ArchLoader.getLibraryExtension();
        return new StringBuilder().insert(0, a3).append(this.libName).append('-').append(this.version).append(a4).toString();
    }

    protected void systemLoadLibrary(String name) {
        System.loadLibrary(name);
    }

    public ArchLoader() {
        ArchLoader archLoader = this;
        ArchLoader archLoader2 = this;
        archLoader2.loadLock = new Object();
        archLoader.loaded = false;
        archLoader.libName = null;
    }

    protected void systemLoad(String name) {
        System.load(name);
    }

    public void setPackageName(String value) {
        this.packageName = value;
    }

    public String getJarName() {
        return this.jarName;
    }
}

