/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import com.jeesite.common.shiro.s.G;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ThreadCpu;
import org.hyperic.sigar.jmx.CpuTimerMBean;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CpuTimer
implements CpuTimerMBean {
    private long cpuSampleLast;
    private long cpuSampleTime;
    private long cpuSampleFirst;
    private long cpuTotal;
    private long totalTime;
    private long startTime;
    private static final Map timers = Collections.synchronizedMap(new HashMap());
    private long cpuSys;
    private Sigar sigar;
    private long stopTime;
    private long cpuUser;
    private ThreadCpu cpu;

    public void stop(Sigar sigar) {
        CpuTimer cpuTimer = this;
        ThreadCpu a2 = cpuTimer.getDiff(sigar);
        cpuTimer.cpuTotal += a2.total;
        cpuTimer.cpuUser += a2.user;
        cpuTimer.cpuSys += a2.sys;
        cpuTimer.stopTime = System.currentTimeMillis();
        double a3 = cpuTimer.stopTime - this.startTime;
        cpuTimer.totalTime = (long)((double)cpuTimer.totalTime + a3);
    }

    private /* synthetic */ long char(long a2) {
        return a2 / 1000000L;
    }

    public void start(Sigar sigar) {
        this.startTime = System.currentTimeMillis();
        try {
            this.cpu.gather(sigar, 0L);
        }
        catch (SigarException a2) {
            throw new IllegalArgumentException(a2.toString());
        }
        this.char(this);
    }

    @Override
    public long getCpuSys() {
        CpuTimer cpuTimer = this;
        return cpuTimer.char(cpuTimer.cpuSys);
    }

    public void add(CpuTimer timer) {
        CpuTimer cpuTimer = this;
        cpuTimer.char(timer);
        cpuTimer.cpuTotal += timer.cpuTotal;
        cpuTimer.cpuUser += timer.cpuUser;
        cpuTimer.cpuSys += timer.cpuSys;
        cpuTimer.totalTime += timer.totalTime;
    }

    @Override
    public double getCpuUsage() {
        if (this.cpuSampleFirst == 0L || this.cpuSampleLast == 0L) {
            return 0.0;
        }
        double a2 = System.currentTimeMillis() - this.cpuSampleTime;
        if (a2 == 0.0) {
            return 0.0;
        }
        double a3 = (double)(this.cpuSampleLast - this.cpuSampleFirst) / a2;
        this.cpuSampleFirst = 0L;
        this.cpuSampleLast = 0L;
        this.cpuSampleTime = 0L;
        return a3;
    }

    public CpuTimer() {
        this(null);
    }

    public ThreadCpu getDiff(Sigar sigar) {
        CpuTimer cpuTimer = this;
        long a2 = cpuTimer.cpu.total;
        long a3 = cpuTimer.cpu.user;
        long a4 = cpuTimer.cpu.sys;
        ThreadCpu a5 = new ThreadCpu();
        try {
            this.cpu.gather(sigar, 0L);
        }
        catch (SigarException a6) {
            throw new IllegalArgumentException(a6.toString());
        }
        a5.total = this.cpu.total - a2;
        CpuTimer cpuTimer2 = this;
        CpuTimer cpuTimer3 = this;
        a5.user = cpuTimer3.cpu.user - a3;
        a5.sys = cpuTimer3.cpu.sys - a4;
        cpuTimer2.char(cpuTimer2);
        return a5;
    }

    public void list(PrintStream out) {
        PrintStream printStream = out;
        CpuTimer cpuTimer = this;
        printStream.println(G.char(".\r=\u0004rFrFr") + cpuTimer.format(cpuTimer.getTotalTime()));
        CpuTimer cpuTimer2 = this;
        out.println(new StringBuilder().insert(0, FileSystem.char("B=R<\u0019`\u0019`\u0019")).append(cpuTimer2.format(cpuTimer2.getCpuUser())).toString());
        CpuTimer cpuTimer3 = this;
        printStream.println(new StringBuilder().insert(0, G.char("/\u0011/FrFrFr")).append(cpuTimer3.format(cpuTimer3.getCpuSys())).toString());
        printStream.println(new StringBuilder().insert(0, FileSystem.char("B=V)R`\u0019`\u0019")).append(CpuPerc.format(this.getCpuUsage())).toString());
    }

    private /* synthetic */ void char(CpuTimer a2) {
        CpuTimer a3;
        if (a3.cpuSampleFirst == 0L) {
            a3.cpuSampleFirst = a3.char(a2.cpu.total);
            a3.cpuSampleTime = a2.startTime;
            return;
        }
        a3.cpuSampleLast = a3.char(a2.cpu.total);
    }

    public ThreadCpu getDiff() {
        CpuTimer cpuTimer = this;
        return cpuTimer.getDiff(cpuTimer.sigar);
    }

    @Override
    public long getCpuTotal() {
        CpuTimer cpuTimer = this;
        return cpuTimer.char(cpuTimer.cpuTotal);
    }

    @Override
    public long getTotalTime() {
        return this.totalTime;
    }

    public CpuTimer(Sigar sigar) {
        CpuTimer cpuTimer = this;
        this.cpu = new ThreadCpu();
        this.clear();
        this.sigar = sigar;
    }

    public void start() {
        CpuTimer cpuTimer = this;
        cpuTimer.start(cpuTimer.sigar);
    }

    @Override
    public long getLastSampleTime() {
        return this.stopTime;
    }

    @Override
    public long getCpuUser() {
        CpuTimer cpuTimer = this;
        return cpuTimer.char(cpuTimer.cpuUser);
    }

    public void clear() {
        CpuTimer cpuTimer = this;
        CpuTimer cpuTimer2 = this;
        CpuTimer cpuTimer3 = this;
        CpuTimer cpuTimer4 = this;
        this.startTime = -1L;
        cpuTimer4.stopTime = -1L;
        cpuTimer4.totalTime = 0L;
        cpuTimer3.cpuTotal = 0L;
        cpuTimer3.cpuUser = 0L;
        cpuTimer2.cpuSys = 0L;
        cpuTimer2.cpuSampleFirst = 0L;
        cpuTimer.cpuSampleLast = 0L;
        cpuTimer.cpuSampleTime = 0L;
    }

    public static CpuTimer getInstance(String name) {
        CpuTimer a2 = (CpuTimer)timers.get(name);
        if (a2 == null) {
            a2 = new CpuTimer();
            timers.put(name, a2);
        }
        return a2;
    }

    public String format(long elap) {
        String a2 = elap % 1000L + "";
        int a3 = 3 - a2.length();
        StringBuffer a4 = new StringBuffer().append(elap / 1000L).append('.');
        int n = a3;
        while (true) {
            --a3;
            if (n <= 0) break;
            n = a3;
            a4.append("0");
        }
        StringBuffer stringBuffer = a4;
        stringBuffer.append(a2).append(FileSystem.char("nD+T!Y*D"));
        return stringBuffer.toString();
    }

    public void stop() {
        CpuTimer cpuTimer = this;
        cpuTimer.stop(cpuTimer.sigar);
    }
}

