/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import com.jeesite.autoconfigure.core.CacheAutoConfiguration;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SysInfo;

public class NetFlags {
    public static final int IFF_NOTRAILERS = 32;
    public static final int TCP_FIN_WAIT2 = 5;
    public static final int IFF_ALLMULTI = 512;
    public static final String ANY_ADDR = "0.0.0.0";
    public static final int IFF_MULTICAST = 2048;
    public static final int TCP_BOUND = 13;
    public static final int IFF_BROADCAST = 2;
    public static final int RTF_HOST = 4;
    public static final int TCP_TIME_WAIT = 6;
    public static final int TCP_UNKNOWN = 14;
    public static final int TCP_LISTEN = 10;
    public static final int CONN_UNIX = 128;
    public static final int CONN_PROTOCOLS = 240;
    public static final int TCP_CLOSE = 7;
    public static final int IFF_PROMISC = 256;
    public static final int RTF_UP = 1;
    public static final int TCP_IDLE = 12;
    public static final int CONN_SERVER = 2;
    public static final int TCP_CLOSING = 11;
    public static final int TCP_ESTABLISHED = 1;
    public static final int TCP_SYN_SENT = 2;
    public static final int CONN_RAW = 64;
    public static final int IFF_POINTOPOINT = 16;
    public static final String LOOPBACK_ADDRESS = "127.0.0.1";
    public static final int IFF_UP = 1;
    public static final int CONN_TCP = 16;
    public static final String LOOPBACK_HOSTNAME = "localhost";
    public static final int CONN_CLIENT = 1;
    public static final String ANY_ADDR_V6 = "::";
    public static final int IFF_LOOPBACK = 8;
    public static final String LOOPBACK_ADDRESS_V6 = "::1";
    public static final int TCP_SYN_RECV = 3;
    public static final int TCP_CLOSE_WAIT = 8;
    public static final int IFF_NOARP = 128;
    public static final int RTF_GATEWAY = 2;
    public static final int IFF_DEBUG = 4;
    public static final int IFF_RUNNING = 64;
    public static final int TCP_FIN_WAIT1 = 4;
    public static final String NULL_HWADDR = "00:00:00:00:00:00";
    public static final int CONN_UDP = 32;
    public static final int TCP_LAST_ACK = 9;
    public static final int IFF_SLAVE = 4096;

    public static native String getIfFlagsString(long var0);

    private /* synthetic */ NetFlags() {
        NetFlags a2;
    }

    public static int getConnectionProtocol(String protocol) throws SigarException {
        if (protocol.equals(CacheAutoConfiguration.char("N=J"))) {
            return 16;
        }
        if (protocol.equals(SysInfo.char("\u000ep\u000b"))) {
            return 32;
        }
        if (protocol.equals(CacheAutoConfiguration.char("H?M"))) {
            return 64;
        }
        if (protocol.equals(SysInfo.char("a\u0015}\u0003"))) {
            return 128;
        }
        String a2 = new StringBuilder().insert(0, CacheAutoConfiguration.char("\u000eH1N1Y1V~\u001d")).append(protocol).append(SysInfo.char("\\4\u0015{\u000f4\ba\u000bd\u0014f\u000fq\u001f")).toString();
        throw new SigarException(a2);
    }

    public static boolean isLoopback(String address) {
        return address.equals(LOOPBACK_HOSTNAME) || address.equals(LOOPBACK_ADDRESS) || address.equals(LOOPBACK_ADDRESS_V6);
    }

    public static boolean isAnyAddress(String address) {
        return address == null || address.equals(ANY_ADDR) || address.equals(ANY_ADDR_V6);
    }
}

