/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.io;

import com.jeesite.common.collect.SetUtils;
import com.jeesite.common.io.FileUtils;
import com.jeesite.common.io.ResourceUtils;
import com.jeesite.common.lang.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class PropertiesUtils {
    public static final String[] DEFAULT_CONFIG_FILE = new String[]{"classpath:config/application.yml", "classpath:application.yml"};
    private static Logger logger = PropertiesUtils.initLogger();
    private final Set<String> configSet = SetUtils.newLinkedHashSet();
    private final Properties properties = new Properties();
    private static Environment environment;
    private static Pattern p1;

    public PropertiesUtils(String ... configFiles) {
        for (String location : configFiles) {
            try {
                Resource resource = ResourceUtils.getResource(location);
                if (!resource.exists()) continue;
                if (location.endsWith(".properties")) {
                    try {
                        InputStreamReader is = new InputStreamReader(resource.getInputStream(), "UTF-8");
                        Object object = null;
                        try {
                            this.properties.load(is);
                            this.configSet.add(location);
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (is != null) {
                                if (object != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object).addSuppressed(throwable);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                        }
                    }
                    catch (IOException ex) {
                        logger.error("Load " + location + " failure. ", (Throwable)ex);
                    }
                    continue;
                }
                if (!location.endsWith(".yml")) continue;
                YamlPropertiesFactoryBean bean = new YamlPropertiesFactoryBean();
                bean.setResources(new Resource[]{resource});
                for (Map.Entry entry : bean.getObject().entrySet()) {
                    this.properties.put(ObjectUtils.toString(entry.getKey()), ObjectUtils.toString(entry.getValue()));
                }
                this.configSet.add(location);
            }
            catch (Exception e) {
                logger.error("Load " + location + " failure. ", (Throwable)e);
            }
        }
    }

    public Set<String> getConfigSet() {
        return this.configSet;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static PropertiesUtils getInstance() {
        return PropertiesLoaderHolder.INSTANCE;
    }

    public static void releadInstance() {
        PropertiesLoaderHolder.releadInstance();
    }

    public String getProperty(String key) {
        String value;
        if (environment != null && (value = environment.getProperty(key)) != null) {
            return value;
        }
        value = this.properties.getProperty(key);
        if (value != null) {
            Matcher m = p1.matcher(value);
            while (m.find()) {
                String g = m.group();
                String childKey = g.replaceAll("\\$\\{|\\}", "");
                value = com.jeesite.common.lang.StringUtils.replace((String)value, (String)g, (String)this.getProperty(childKey));
            }
            return value;
        }
        String systemProperty = System.getProperty(key);
        if (systemProperty != null) {
            return systemProperty;
        }
        return null;
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value != null ? value : defaultValue;
    }

    public static void setEnvironment(Environment environment) {
        PropertiesUtils.environment = environment;
    }

    private static Logger initLogger() {
        String logPath = null;
        try {
            logPath = new DefaultResourceLoader().getResource("/").getFile().getPath();
        }
        catch (Exception e) {
            logPath = System.getProperty("user.dir");
        }
        String classesLogPath = FileUtils.path(logPath + "/WEB-INF/classes");
        if (new File(classesLogPath).exists()) {
            logPath = classesLogPath;
        }
        System.setProperty("logPath", FileUtils.path(logPath));
        return LoggerFactory.getLogger(PropertiesUtils.class);
    }

    static {
        p1 = Pattern.compile("\\$\\{.*?\\}");
    }

    private static final class PropertiesLoaderHolder {
        private static PropertiesUtils INSTANCE;

        private PropertiesLoaderHolder() {
        }

        public static void releadInstance() {
            Resource[] resources;
            LinkedHashSet<String> configSet = SetUtils.newLinkedHashSet();
            for (Resource resource : resources = ResourceUtils.getResources("classpath*:/config/jeesite-*.*")) {
                configSet.add("classpath:config/" + resource.getFilename());
            }
            LinkedHashSet<String> set = SetUtils.newLinkedHashSet();
            for (String configFile : DEFAULT_CONFIG_FILE) {
                set.add(configFile);
            }
            String customConfigs = System.getProperty("spring.config.location");
            if (com.jeesite.common.lang.StringUtils.isNotBlank((CharSequence)customConfigs)) {
                for (String customConfig : com.jeesite.common.lang.StringUtils.split((String)customConfigs, (String)",")) {
                    if (!customConfig.contains("$") && !ResourceUtils.isUrl((String)(customConfig = StringUtils.cleanPath((String)customConfig)))) {
                        customConfig = "file:" + customConfig;
                    }
                    set.add(customConfig);
                }
            }
            String[] configFiles = set.toArray(new String[set.size()]);
            String profiles = System.getProperty("spring.profiles.active");
            if (com.jeesite.common.lang.StringUtils.isBlank((CharSequence)profiles)) {
                PropertiesUtils propsTemp = new PropertiesUtils(configFiles);
                profiles = propsTemp.getProperty("spring.profiles.active");
            }
            for (String location : configFiles) {
                configSet.add(location);
                if (!com.jeesite.common.lang.StringUtils.isNotBlank((CharSequence)profiles)) continue;
                if (location.endsWith(".properties")) {
                    configSet.add(com.jeesite.common.lang.StringUtils.substringBeforeLast((String)location, (String)".properties") + "-" + profiles + ".properties");
                    continue;
                }
                if (!location.endsWith(".yml")) continue;
                configSet.add(com.jeesite.common.lang.StringUtils.substringBeforeLast((String)location, (String)".yml") + "-" + profiles + ".yml");
            }
            configFiles = configSet.toArray(new String[configSet.size()]);
            logger.debug("Loading jeesite config: {}", (Object)configFiles);
            INSTANCE = new PropertiesUtils(configFiles);
        }

        static {
            PropertiesLoaderHolder.releadInstance();
        }
    }
}

