/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.lang;

import java.math.BigDecimal;
import java.text.DecimalFormat;

public class NumberUtils
extends org.apache.commons.lang3.math.NumberUtils {
    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double div(double v1, double v2) {
        return NumberUtils.div(v1, v2, 10);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static String formatDouble(Double b) {
        BigDecimal bg = new BigDecimal(b);
        return bg.setScale(2, 4).toString();
    }

    public static String formatScale(double one, long total) {
        BigDecimal bg = new BigDecimal(one * 100.0 / (double)total);
        return bg.setScale(0, 4).toString();
    }

    public static String formatNumber(Object data, String pattern) {
        DecimalFormat df = null;
        df = pattern == null ? new DecimalFormat() : new DecimalFormat(pattern);
        return df.format(data);
    }
}

