/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.text;

import java.util.regex.Pattern;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinUtils {
    public static String getFirstSpell(String chinese) {
        return PinyinUtils.getFirstSpell(chinese, true);
    }

    public static String getFirstSpell(String chinese, boolean isId) {
        if ((chinese = PinyinUtils.getDbc(chinese)) == null) {
            return null;
        }
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > '\u0080') {
                try {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)Static.defaultFormat);
                    if (temp != null) {
                        pybf.append(temp[0].charAt(0));
                        continue;
                    }
                    pybf.append(String.valueOf(arr[i]));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pybf.append(arr[i]);
        }
        if (isId) {
            return Static.idPatt.matcher(pybf.toString()).replaceAll("").trim();
        }
        return pybf.toString();
    }

    public static String getFullSpell(String chinese) {
        return PinyinUtils.getFullSpell(chinese, true);
    }

    public static String getFullSpell(String chinese, boolean isId) {
        if ((chinese = PinyinUtils.getDbc(chinese)) == null) {
            return null;
        }
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > '\u0080') {
                try {
                    String[] ss = PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)Static.defaultFormat);
                    if (ss != null && ss.length > 0) {
                        pybf.append(ss[0]);
                        continue;
                    }
                    pybf.append(String.valueOf(arr[i]));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pybf.append(arr[i]);
        }
        if (isId) {
            return Static.idPatt.matcher(pybf.toString()).replaceAll("").trim();
        }
        return pybf.toString();
    }

    public static String getSbc(String input) {
        if (input == null) {
            return null;
        }
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String getDbc(String input) {
        if (input == null) {
            return null;
        }
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    private static class Static {
        private static Pattern idPatt = Pattern.compile("\\W");
        private static HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();

        private Static() {
        }

        static {
            defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        }
    }
}

