/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.batch.core.DefaultJobKeyGenerator;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobKeyGenerator;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.util.Assert;

public class MapJobInstanceDao
implements JobInstanceDao {
    private static final String STAR_WILDCARD = "\\*";
    private static final String STAR_WILDCARD_PATTERN = ".*";
    private final Map<String, JobInstance> jobInstances = new ConcurrentHashMap<String, JobInstance>();
    private JobKeyGenerator<JobParameters> jobKeyGenerator = new DefaultJobKeyGenerator();
    private final AtomicLong currentId = new AtomicLong(0L);

    public void clear() {
        this.jobInstances.clear();
    }

    @Override
    public JobInstance createJobInstance(String jobName, JobParameters jobParameters) {
        Assert.state((this.getJobInstance(jobName, jobParameters) == null ? 1 : 0) != 0, (String)"JobInstance must not already exist");
        JobInstance jobInstance = new JobInstance(this.currentId.getAndIncrement(), jobName);
        jobInstance.incrementVersion();
        this.jobInstances.put(jobName + "|" + this.jobKeyGenerator.generateKey(jobParameters), jobInstance);
        return jobInstance;
    }

    @Override
    public JobInstance getJobInstance(String jobName, JobParameters jobParameters) {
        return this.jobInstances.get(jobName + "|" + this.jobKeyGenerator.generateKey(jobParameters));
    }

    @Override
    public JobInstance getJobInstance(Long instanceId) {
        for (Map.Entry<String, JobInstance> instanceEntry : this.jobInstances.entrySet()) {
            JobInstance instance = instanceEntry.getValue();
            if (!instance.getId().equals(instanceId)) continue;
            return instance;
        }
        return null;
    }

    @Override
    public List<String> getJobNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, JobInstance> instanceEntry : this.jobInstances.entrySet()) {
            result.add(instanceEntry.getValue().getJobName());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public List<JobInstance> getJobInstances(String jobName, int start, int count) {
        ArrayList<JobInstance> result = new ArrayList<JobInstance>();
        for (Map.Entry<String, JobInstance> instanceEntry : this.jobInstances.entrySet()) {
            JobInstance instance = instanceEntry.getValue();
            if (!instance.getJobName().equals(jobName)) continue;
            result.add(instance);
        }
        this.sortDescending(result);
        return this.subset(result, start, count);
    }

    @Override
    public JobInstance getJobInstance(JobExecution jobExecution) {
        return jobExecution.getJobInstance();
    }

    @Override
    public int getJobInstanceCount(String jobName) throws NoSuchJobException {
        int count = 0;
        for (Map.Entry<String, JobInstance> instanceEntry : this.jobInstances.entrySet()) {
            String key = instanceEntry.getKey();
            String curJobName = key.substring(0, key.lastIndexOf("|"));
            if (!curJobName.equals(jobName)) continue;
            ++count;
        }
        if (count == 0) {
            throw new NoSuchJobException("No job instances for job name " + jobName + " were found");
        }
        return count;
    }

    @Override
    public List<JobInstance> findJobInstancesByName(String jobName, int start, int count) {
        ArrayList<JobInstance> result = new ArrayList<JobInstance>();
        String convertedJobName = jobName.replaceAll(STAR_WILDCARD, STAR_WILDCARD_PATTERN);
        for (Map.Entry<String, JobInstance> instanceEntry : this.jobInstances.entrySet()) {
            JobInstance instance = instanceEntry.getValue();
            if (!instance.getJobName().matches(convertedJobName)) continue;
            result.add(instance);
        }
        this.sortDescending(result);
        return this.subset(result, start, count);
    }

    private void sortDescending(List<JobInstance> result) {
        Collections.sort(result, new Comparator<JobInstance>(){

            @Override
            public int compare(JobInstance o1, JobInstance o2) {
                return Long.signum(o2.getId() - o1.getId());
            }
        });
    }

    private List<JobInstance> subset(List<JobInstance> jobInstances, int start, int count) {
        int startIndex = Math.min(start, jobInstances.size());
        int endIndex = Math.min(start + count, jobInstances.size());
        return jobInstances.subList(startIndex, endIndex);
    }
}

