/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.nowgo.common.utils;

import com.lenovo.nowgo.common.annotation.ResponseMessage;
import com.lenovo.nowgo.common.constant.ResponseCode;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseCodeUtil {
    private static Class<ResponseMessage> ANNO_CLAZZ = ResponseMessage.class;
    private static String INTEGER_CLAZZ_STR = "class java.lang.Integer";

    public static Map<Integer, Map<String, String>> getResponseCodeAndMsgMap() {
        HashMap<Integer, Map<String, String>> responseMap = new HashMap<Integer, Map<String, String>>();
        Class<ResponseCode> responseCodeClazz = ResponseCode.class;
        Field[] fields = responseCodeClazz.getDeclaredFields();
        Integer fieldValue = 0;
        try {
            for (Field f : fields) {
                if (!f.isAnnotationPresent(ANNO_CLAZZ) || !f.getGenericType().toString().equals(INTEGER_CLAZZ_STR)) continue;
                f.setAccessible(true);
                fieldValue = (Integer)f.get(responseCodeClazz);
                responseMap.put(fieldValue, ResponseCodeUtil.getFieldAnnotationAttrs(f));
            }
            return responseMap;
        }
        catch (IllegalArgumentException e) {
            new Throwable("ResponseCode field type must be java.lang.Integer");
        }
        catch (IllegalAccessException e) {
            new Throwable("Please use field.setAccessible(true) in " + ResponseCodeUtil.class.getName());
        }
        return null;
    }

    private static Map<String, String> getFieldAnnotationAttrs(Field f) {
        Integer msgInfoSize;
        ResponseMessage httpResponseMsg = f.getAnnotation(ANNO_CLAZZ);
        String[] lang = httpResponseMsg.lang();
        String[] msgInfo = httpResponseMsg.msg();
        Integer langSize = lang.length;
        if (langSize != (msgInfoSize = Integer.valueOf(msgInfo.length))) {
            new Throwable("Please check HttpResponseMsg annotation field in " + f.getName() + " field");
        }
        HashMap<String, String> attrsMap = new HashMap<String, String>();
        for (int i = 0; i < langSize; ++i) {
            attrsMap.put(lang[i], msgInfo[i]);
        }
        return attrsMap;
    }
}

