/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.redis;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.redis.WxRedisOps;
import org.redisson.api.RedissonClient;

public class RedissonWxRedisOps
implements WxRedisOps {
    private final RedissonClient redissonClient;

    @Override
    public String getValue(String key) {
        Object value = this.redissonClient.getBucket(key).get();
        return value == null ? null : value.toString();
    }

    @Override
    public void setValue(String key, String value, int expire, TimeUnit timeUnit) {
        if (expire <= 0) {
            this.redissonClient.getBucket(key).set((Object)value);
        } else {
            this.redissonClient.getBucket(key).set((Object)value, (long)expire, timeUnit);
        }
    }

    @Override
    public Long getExpire(String key) {
        long expire = this.redissonClient.getBucket(key).remainTimeToLive();
        if (expire > 0L) {
            expire /= 1000L;
        }
        return expire;
    }

    @Override
    public void expire(String key, int expire, TimeUnit timeUnit) {
        this.redissonClient.getBucket(key).expire((long)expire, timeUnit);
    }

    @Override
    public Lock getLock(String key) {
        return this.redissonClient.getLock(key);
    }

    public RedissonWxRedisOps(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

