/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.environment;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyDetector;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySourceConverter;
import com.ulisesbocchio.jasyptspringboot.InterceptionMode;
import com.ulisesbocchio.jasyptspringboot.detector.DefaultPropertyDetector;
import com.ulisesbocchio.jasyptspringboot.encryptor.DefaultLazyEncryptor;
import com.ulisesbocchio.jasyptspringboot.filter.DefaultPropertyFilter;
import com.ulisesbocchio.jasyptspringboot.resolver.DefaultPropertyResolver;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.StandardEnvironment;

public class StandardEncryptableEnvironment
extends StandardEnvironment
implements ConfigurableEnvironment {
    private EncryptablePropertyResolver resolver;
    private final EncryptablePropertyFilter filter;
    private final InterceptionMode interceptionMode;
    private MutablePropertySources encryptablePropertySources;
    private MutablePropertySources originalPropertySources;

    public StandardEncryptableEnvironment() {
        this(InterceptionMode.WRAPPER);
    }

    public StandardEncryptableEnvironment(InterceptionMode interceptionMode) {
        this(interceptionMode, new DefaultPropertyDetector(), (EncryptablePropertyFilter)new DefaultPropertyFilter());
    }

    public StandardEncryptableEnvironment(InterceptionMode interceptionMode, StringEncryptor encryptor) {
        this(interceptionMode, (EncryptablePropertyFilter)new DefaultPropertyFilter());
        this.resolver = new DefaultPropertyResolver(encryptor, new DefaultPropertyDetector(), (Environment)this);
    }

    public StandardEncryptableEnvironment(StringEncryptor encryptor) {
        this(InterceptionMode.WRAPPER, (EncryptablePropertyFilter)new DefaultPropertyFilter());
        this.resolver = new DefaultPropertyResolver(encryptor, new DefaultPropertyDetector(), (Environment)this);
    }

    public StandardEncryptableEnvironment(InterceptionMode interceptionMode, StringEncryptor encryptor, EncryptablePropertyDetector detector) {
        this(interceptionMode, (EncryptablePropertyFilter)new DefaultPropertyFilter());
        this.resolver = new DefaultPropertyResolver(encryptor, detector, (Environment)this);
    }

    public StandardEncryptableEnvironment(EncryptablePropertyResolver resolver) {
        this(InterceptionMode.WRAPPER, resolver, (EncryptablePropertyFilter)new DefaultPropertyFilter());
    }

    public StandardEncryptableEnvironment(EncryptablePropertyFilter filter) {
        this(InterceptionMode.WRAPPER, filter);
    }

    public StandardEncryptableEnvironment(InterceptionMode interceptionMode, EncryptablePropertyFilter filter) {
        this(interceptionMode, new DefaultPropertyDetector(), filter);
    }

    public StandardEncryptableEnvironment(InterceptionMode interceptionMode, StringEncryptor encryptor, EncryptablePropertyFilter filter) {
        this(interceptionMode, filter);
        this.resolver = new DefaultPropertyResolver(encryptor, new DefaultPropertyDetector(), (Environment)this);
    }

    public StandardEncryptableEnvironment(StringEncryptor encryptor, EncryptablePropertyFilter filter) {
        this(InterceptionMode.WRAPPER, filter);
        this.resolver = new DefaultPropertyResolver(encryptor, new DefaultPropertyDetector(), (Environment)this);
    }

    public StandardEncryptableEnvironment(InterceptionMode interceptionMode, StringEncryptor encryptor, EncryptablePropertyDetector detector, EncryptablePropertyFilter filter) {
        this(interceptionMode, filter);
        this.resolver = new DefaultPropertyResolver(encryptor, detector, (Environment)this);
    }

    public StandardEncryptableEnvironment(EncryptablePropertyResolver resolver, EncryptablePropertyFilter filter) {
        this(InterceptionMode.WRAPPER, resolver, filter);
    }

    public StandardEncryptableEnvironment(InterceptionMode interceptionMode, EncryptablePropertyResolver resolver, EncryptablePropertyFilter filter) {
        this.interceptionMode = interceptionMode;
        this.filter = filter;
        this.resolver = resolver;
        this.actuallyCustomizePropertySources();
    }

    public StandardEncryptableEnvironment(InterceptionMode interceptionMode, EncryptablePropertyDetector detector, EncryptablePropertyFilter filter) {
        this.interceptionMode = interceptionMode;
        this.filter = filter;
        this.resolver = new DefaultPropertyResolver(new DefaultLazyEncryptor((Environment)this), detector, (Environment)this);
        this.actuallyCustomizePropertySources();
    }

    protected void customizePropertySources(MutablePropertySources propertySources) {
        super.customizePropertySources(propertySources);
        this.originalPropertySources = propertySources;
    }

    protected void actuallyCustomizePropertySources() {
        EncryptablePropertySourceConverter.convertPropertySources(this.interceptionMode, this.resolver, this.filter, this.originalPropertySources);
        this.encryptablePropertySources = EncryptablePropertySourceConverter.proxyPropertySources(this.interceptionMode, this.resolver, this.filter, this.originalPropertySources);
    }

    public MutablePropertySources getPropertySources() {
        return this.encryptablePropertySources;
    }
}

