/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.aggregator.DefaultAggregatingMessageGroupProcessor;
import org.springframework.integration.aggregator.ExpressionEvaluatingMessageGroupProcessor;
import org.springframework.integration.config.AggregatorFactoryBean;
import org.springframework.integration.config.xml.AbstractCorrelatingMessageHandlerParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AggregatorParser
extends AbstractCorrelatingMessageHandlerParser {
    private static final String EXPIRE_GROUPS_UPON_COMPLETION = "expire-groups-upon-completion";

    @Override
    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanComponentDefinition innerHandlerDefinition = IntegrationNamespaceUtils.parseInnerHandlerDefinition(element, parserContext);
        String ref = element.getAttribute("ref");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AggregatorFactoryBean.class);
        Object processor = null;
        if (innerHandlerDefinition != null || StringUtils.hasText((String)ref)) {
            processor = innerHandlerDefinition != null ? innerHandlerDefinition : new RuntimeBeanReference(ref);
            builder.addPropertyValue("processorBean", processor);
        } else if (StringUtils.hasText((String)element.getAttribute("expression"))) {
            String expression = element.getAttribute("expression");
            BeanDefinitionBuilder adapterBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionEvaluatingMessageGroupProcessor.class);
            adapterBuilder.addConstructorArgValue((Object)expression);
            builder.addPropertyValue("processorBean", (Object)adapterBuilder.getBeanDefinition());
        } else {
            builder.addPropertyValue("processorBean", (Object)BeanDefinitionBuilder.genericBeanDefinition(DefaultAggregatingMessageGroupProcessor.class).getBeanDefinition());
        }
        if (StringUtils.hasText((String)element.getAttribute("method"))) {
            String method = element.getAttribute("method");
            builder.addPropertyValue("methodName", (Object)method);
        }
        this.doParse(builder, element, (BeanMetadataElement)processor, parserContext);
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, EXPIRE_GROUPS_UPON_COMPLETION);
        return builder;
    }
}

